/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.Distributor;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class DistributorList {
    private HashMap<Integer, Distributor> _distributors = new HashMap();
    private static DistributorList _instance;

    private DistributorList() {
        this.refreshDistributorList(false);
    }

    public static DistributorList getInstance() {
        if (null == _instance) {
            _instance = new DistributorList();
        }
        return _instance;
    }

    public void refreshDistributorList(boolean notify) {
        this._distributors.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getDistributors();
        try {
            if (null != rs) {
                while (rs.next()) {
                    Distributor element = new Distributor();
                    element.setDistributorContact(rs.getString("DistributorContact"));
                    element.setDistributorEmail(rs.getString("DistributorEmail"));
                    element.setDistributorID(rs.getInt("DistributorID"));
                    element.setDistributorName(rs.getString("DistributorName"));
                    element.setDistributorPhone(rs.getString("DistributorPhone"));
                    element.setDistributorWebsite(rs.getString("DistributorWebsite"));
                    this._distributors.put(element.getDistributorID(), element);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        if (notify) {
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.DISTRIBUTOR_LIST_LISTENER);
        }
    }

    public Distributor[] getDistributors() {
        return this._distributors.values().toArray(new Distributor[0]);
    }

    public void setDistributor(Distributor distributor) {
        PNPDatabaseManager.getInstance().updateDistributor(distributor);
        this.refreshDistributorList(true);
    }
}

