/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.ArrayList;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.EtsyAccount;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class EtsyAccountsList {
    private static EtsyAccountsList _instance;

    public static EtsyAccountsList getInstance() {
        if (null == _instance) {
            _instance = new EtsyAccountsList();
        }
        return _instance;
    }

    public void updateEtsyAccount(EtsyAccount account) {
        PNPDatabaseManager.getInstance().updateEtsyAccount(account);
    }

    public void deleteEtsyAccount(String etsyStore, String etsyLogin) {
        PNPDatabaseManager.getInstance().deleteEtsyAccount(etsyStore, etsyLogin);
    }

    public ArrayList<EtsyAccount> getEtsyAccounts() {
        ArrayList<EtsyAccount> etsyAccounts = new ArrayList<EtsyAccount>();
        ResultSet rs = PNPDatabaseManager.getInstance().getEtsyAccounts();
        try {
            while (rs != null && !rs.isClosed() && rs.next()) {
                EtsyAccount etsyAccount = new EtsyAccount();
                etsyAccount.setEtsyLogin(rs.getString("EtsyLogin"));
                etsyAccount.setEtsyStore(rs.getString("EtsyStore"));
                etsyAccount.setToken(rs.getString("Token"));
                etsyAccount.setTokenSecret(rs.getString("TokenSecret"));
                etsyAccounts.add(etsyAccount);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return etsyAccounts;
    }
}

