/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.Expense;
import pnp.services.listener.GenericListener;
import pnp.services.listener.TransactionListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class ExpenseList
implements TransactionListener {
    private HashMap<Integer, Expense> _expenseList;
    private static ExpenseList _instance;
    private long _searchTo;
    private long _searchFrom;
    private ArrayList<Integer> _filteredList;
    private String _searchString;
    private final Object _lock = new Object();

    private ExpenseList() {
        this._expenseList = new HashMap();
        this._filteredList = new ArrayList();
        ListenerManager.getInstance().subscribe((GenericListener)this);
    }

    public static ExpenseList getInstance() {
        if (null == _instance) {
            _instance = new ExpenseList();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshExpenses(long from, long to, ArrayList<Integer> filteredList, String searchString) {
        Object object = this._lock;
        synchronized (object) {
            this._searchFrom = from;
            this._searchTo = to;
            this._filteredList = filteredList;
            this._searchString = searchString;
        }
        this.newTransactionAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshExpenseList() {
        Object object = this._lock;
        synchronized (object) {
            this._expenseList.clear();
            ResultSet rs = PNPDatabaseManager.getInstance().getExpenses(this._searchFrom, this._searchTo, this._filteredList, this._searchString, null);
            try {
                if (null != rs) {
                    while (rs.next()) {
                        Expense element = new Expense();
                        element.setExpenseComment(rs.getString("ExpenseComment"));
                        element.setExpenseCost(rs.getFloat("ExpenseCost"));
                        element.setExpenseDate(rs.getDate("ExpenseDate"));
                        element.setExpenseID(rs.getInt("ExpenseID"));
                        element.setExpenseReason(rs.getString("ExpenseReason"));
                        element.setExpenseReasonID(rs.getInt("ExpenseReasonID"));
                        element.setCompanyName(rs.getString("CompanyName"));
                        this._expenseList.put(element.getExpenseID(), element);
                    }
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
            DatabaseConnector.removeObject((ResultSet)rs);
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.EXPENSE_LIST_LISTENER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expense[] getExpenses() {
        Object object = this._lock;
        synchronized (object) {
            return this._expenseList.values().toArray(new Expense[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExpense(Expense expense) {
        Object object = this._lock;
        synchronized (object) {
            expense.setExpenseID(PNPDatabaseManager.getInstance().updateExpense(expense));
            this._expenseList.put(expense.getExpenseID(), expense);
            this.newTransactionAvailable();
        }
    }

    public void deleteExpense(Expense expense) {
        PNPDatabaseManager.getInstance().deleteExpense(expense);
    }

    public void newTransactionAvailable() {
        this.refreshExpenseList();
    }
}

