/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.ExpenseReason;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class ExpenseReasonsList {
    private HashMap<Integer, ExpenseReason> _expenseReasons = new HashMap();
    private static ExpenseReasonsList _instance;

    private ExpenseReasonsList() {
        this.refreshExpenseReasonList(false);
    }

    public static ExpenseReasonsList getInstance() {
        if (null == _instance) {
            _instance = new ExpenseReasonsList();
        }
        return _instance;
    }

    public void refreshExpenseReasonList(boolean notify) {
        this._expenseReasons.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getExpenseReasonsList();
        try {
            if (null != rs) {
                while (rs.next()) {
                    ExpenseReason element = new ExpenseReason();
                    element.setExpenseReasonID(rs.getInt("ExpenseReasonID"));
                    element.setReason(rs.getString("Reason"));
                    this._expenseReasons.put(element.getExpenseReasonID(), element);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        if (notify) {
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.EXPENSE_REASONS_LIST_LISTENER);
        }
    }

    public ExpenseReason[] getExpenseReasons() {
        return this._expenseReasons.values().toArray(new ExpenseReason[0]);
    }

    public void setExpenseReasons(ExpenseReason expenseReason) {
        PNPDatabaseManager.getInstance().updateExpenseReason(expenseReason);
        this.refreshExpenseReasonList(true);
    }
}

