/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class InventoryList {
    private HashMap<String, ArrayList<InventoryElement>> _inventory = new HashMap();
    private HashMap<String, Item> _items = new HashMap();
    private static InventoryList _instance;

    private InventoryList() {
        this.refreshItemList();
    }

    public static InventoryList getInstance() {
        if (null == _instance) {
            _instance = new InventoryList();
        }
        return _instance;
    }

    public HashMap<String, ArrayList<InventoryElement>> getFullInventoryList() {
        return this._inventory;
    }

    private void refreshInventoryList() {
        this._inventory.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getInventoryList();
        try {
            if (null != rs) {
                while (rs.next()) {
                    InventoryElement element = new InventoryElement();
                    element.setInventoryID(rs.getInt("InventoryID"));
                    element.setItemQuantity(rs.getInt("ItemQuantity"));
                    element.setItemCost(rs.getFloat("ItemCost"));
                    element.setItemID(rs.getString("ItemID"));
                    element.setOosItem(rs.getBoolean("OOSItem"));
                    element.setStockDate(rs.getDate("StockDate"));
                    if (!this._inventory.containsKey(element.getItemID())) {
                        this._inventory.put(element.getItemID(), new ArrayList());
                    }
                    ArrayList<InventoryElement> elementArrayList = this._inventory.get(element.getItemID());
                    if (element.isOosItem() && (elementArrayList.isEmpty() || !elementArrayList.isEmpty() && !elementArrayList.get(0).isOosItem())) {
                        elementArrayList.add(0, element);
                        continue;
                    }
                    if (element.isOosItem()) {
                        System.out.println(element.getItemID());
                        if (element.getItemQuantity() <= 0) {
                            if (element.getItemQuantity() < 0) {
                                System.out.println(element.getItemID() + " - " + elementArrayList.get(0).getItemQuantity() + " - " + element.getItemQuantity());
                            }
                            elementArrayList.get(0).setItemQuantity(elementArrayList.get(0).getItemQuantity() + element.getItemQuantity());
                            PNPDatabaseManager.getInstance().updateInventory(elementArrayList.get(0));
                            PNPDatabaseManager.getInstance().deleteInventoryElement(element);
                        } else if (element.getItemQuantity() > 0) {
                            System.out.println(element.getItemID() + " - " + element.getItemQuantity());
                            element.setOosItem(false);
                            PNPDatabaseManager.getInstance().updateInventory(element);
                        }
                    }
                    elementArrayList.add(element);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
    }

    private void refreshItemList() {
        this._items.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getItemList();
        try {
            if (null != rs) {
                while (rs.next()) {
                    Item element = new Item();
                    element.setDistributorID(rs.getInt("DistributorID"));
                    element.setDropShipped(rs.getBoolean("DropShipped"));
                    element.setDistributorProductID(rs.getString("DistributorProductID"));
                    element.setItemDescription(rs.getString("ItemDescription"));
                    element.setItemID(rs.getString("ItemID"));
                    element.setItemName(rs.getString("ItemName"));
                    element.setItemWeight(rs.getFloat("ItemWeight"));
                    element.setLocation(rs.getString("Location"));
                    element.setDiscontinued(rs.getBoolean("Discontinued"));
                    element.setPackedWeight(rs.getFloat("PackedWeight"));
                    this._items.put(element.getItemID(), element);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
    }

    public Collection<ArrayList<InventoryElement>> getInventory() {
        return this._inventory.values();
    }

    public ArrayList<InventoryElement> getInventoryElement(String itemID) {
        return this._inventory.get(itemID.toLowerCase());
    }

    public void setInventoryElementChain(ArrayList<InventoryElement> inventoryElement) {
        PNPDatabaseManager.getInstance().updateInventory(inventoryElement);
        this._inventory.put(inventoryElement.get(0).getItemID().toLowerCase(), inventoryElement);
    }

    public void setInventoryElement(InventoryElement inventoryElement) {
        if (inventoryElement.getItemQuantity() == 0 && !inventoryElement.isOosItem()) {
            PNPDatabaseManager.getInstance().deleteInventoryElement(inventoryElement);
        } else {
            PNPDatabaseManager.getInstance().updateInventory(inventoryElement);
        }
        ArrayList<Object> inventoryElements = this._inventory.get(inventoryElement.getItemID());
        boolean found = false;
        if (null != inventoryElements) {
            for (int i = 0; i < inventoryElements.size(); ++i) {
                if (((InventoryElement)inventoryElements.get(i)).getInventoryID() != inventoryElement.getInventoryID()) continue;
                ((InventoryElement)inventoryElements.get(i)).setItemQuantity(inventoryElement.getItemQuantity());
                found = true;
            }
        } else {
            inventoryElements = new ArrayList();
        }
        if (!found) {
            inventoryElements.add(inventoryElement);
            this._inventory.put(((InventoryElement)inventoryElements.get(0)).getItemID().toLowerCase(), inventoryElements);
        }
    }

    public Item getItem(String itemID) {
        return this._items.get(itemID.toLowerCase());
    }

    public void setItem(Item item) {
        PNPDatabaseManager.getInstance().updateItem(item);
        this._items.put(item.getItemID().toLowerCase(), item);
    }

    public int getItemQuantity(String itemID) {
        int quantity = 0;
        ArrayList<InventoryElement> inventoryElements = this._inventory.get(itemID);
        if (inventoryElements != null) {
            Iterator<InventoryElement> iter = inventoryElements.iterator();
            while (iter.hasNext()) {
                quantity += iter.next().getItemQuantity();
            }
        }
        return quantity;
    }

    public void refreshInventoryList(String searchString, boolean instock, boolean oos, boolean inhouse, boolean discontinued, String[] distributorsFilter, boolean fullText) {
        this._inventory.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getInventoryList(searchString, instock, oos, inhouse, discontinued, distributorsFilter, fullText);
        try {
            if (null != rs) {
                while (rs.next()) {
                    InventoryElement element = new InventoryElement();
                    element.setInventoryID(rs.getInt("InventoryID"));
                    element.setItemQuantity(rs.getInt("ItemQuantity"));
                    element.setItemCost(rs.getFloat("ItemCost"));
                    element.setItemID(rs.getString("ItemID"));
                    element.setOosItem(rs.getBoolean("OOSItem"));
                    element.setStockDate(rs.getDate("StockDate"));
                    if (!this._inventory.containsKey(element.getItemID())) {
                        this._inventory.put(element.getItemID(), new ArrayList());
                    }
                    ArrayList<InventoryElement> elementArrayList = this._inventory.get(element.getItemID());
                    if (element.isOosItem() && (elementArrayList.isEmpty() || !elementArrayList.isEmpty() && !elementArrayList.get(0).isOosItem())) {
                        elementArrayList.add(0, element);
                        continue;
                    }
                    if (element.isOosItem()) {
                        System.out.println(element.getItemID());
                        if (element.getItemQuantity() <= 0) {
                            if (element.getItemQuantity() < 0) {
                                System.out.println(element.getItemID() + " - " + elementArrayList.get(0).getItemQuantity() + " - " + element.getItemQuantity());
                            }
                            elementArrayList.get(0).setItemQuantity(elementArrayList.get(0).getItemQuantity() + element.getItemQuantity());
                            PNPDatabaseManager.getInstance().updateInventory(elementArrayList.get(0));
                            PNPDatabaseManager.getInstance().deleteInventoryElement(element);
                        } else if (element.getItemQuantity() > 0) {
                            System.out.println(element.getItemID() + " - " + element.getItemQuantity());
                            element.setOosItem(false);
                            PNPDatabaseManager.getInstance().updateInventory(element);
                        }
                    }
                    elementArrayList.add(element);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVENTORY_LIST_LISTENER);
    }
}

