/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.Date;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.comms.db.lists.OrderStatusList;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class OOSList {
    private HashMap<String, OrderDetails> _oosOrderDetailsList;
    private HashMap<String, InventoryElement> _oosInventoryList;
    private HashMap<Integer, CompleteOrder> _oosOrderList;
    private static OOSList _instance;
    private final Object _lock = new Object();

    private OOSList() {
        this._oosOrderDetailsList = new HashMap();
        this._oosInventoryList = new HashMap();
        this._oosOrderList = new HashMap();
    }

    public static OOSList getInstance() {
        if (null == _instance) {
            _instance = new OOSList();
        }
        return _instance;
    }

    public OrderDetails[] getOosOrderDetailsList() {
        this._oosOrderDetailsList.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getOosOrderDetailsList();
        try {
            while (null != rs && !rs.isClosed() && rs.next()) {
                if (rs.getBoolean("Deleted")) continue;
                OrderDetails orderDetailsElement = new OrderDetails();
                orderDetailsElement.setItemID(rs.getString("OrderDetails.ItemID"));
                orderDetailsElement.setOrderDetailsID(rs.getInt("OrderDetails.OrderDetailsID"));
                orderDetailsElement.setBackordered(rs.getBoolean("OrderDetails.Backordered"));
                orderDetailsElement.setItemCost(rs.getFloat("OrderDetails.ItemCost"));
                orderDetailsElement.setTransactionID(rs.getString("OrderDetails.TransactionID"));
                this._oosOrderDetailsList.put(orderDetailsElement.getTransactionID(), orderDetailsElement);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return this._oosOrderDetailsList.values().toArray(new OrderDetails[0]);
    }

    public InventoryElement[] getOosInventoryList() {
        this._oosInventoryList.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getOosInventory();
        try {
            while (null != rs && !rs.isClosed() && rs.next()) {
                InventoryElement element = new InventoryElement();
                element.setInventoryID(rs.getInt("InventoryID"));
                element.setItemQuantity(rs.getInt("ItemQuantity"));
                element.setItemCost(rs.getFloat("ItemCost"));
                element.setItemID(rs.getString("ItemID"));
                element.setOosItem(rs.getBoolean("OOSItem"));
                this._oosInventoryList.put(element.getItemID(), element);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return this._oosInventoryList.values().toArray(new InventoryElement[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOosOrderDetails(OrderDetails order) {
        Object object = this._lock;
        synchronized (object) {
            PNPDatabaseManager.getInstance().updateOosOrderDetails(order);
        }
    }

    public CompleteOrder[] getOosOrderList() {
        ResultSet rs = PNPDatabaseManager.getInstance().getOosOrderList();
        this._oosOrderList.clear();
        try {
            while (null != rs && !rs.isClosed() && rs.next()) {
                if (rs.getBoolean("OrderDetails.Deleted")) continue;
                CompleteOrder completeOrder = new CompleteOrder();
                if (this._oosOrderList.containsKey(rs.getInt("Orders.OrderID"))) {
                    completeOrder = this._oosOrderList.get(rs.getInt("Orders.OrderID"));
                } else {
                    Order orderElement = new Order();
                    try {
                        orderElement.setOrderComments(rs.getString("Orders.OrderComments"));
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    orderElement.setOrderDate(rs.getDate("Orders.OrderDate"));
                    orderElement.setOrderID(rs.getInt("Orders.OrderID"));
                    orderElement.setOrderStatus(OrderStatusList.getInstance().getOrderStatus(rs.getInt("Orders.OrderStatusID")));
                    orderElement.setOrderTotal(rs.getFloat("Orders.OrderTotal"));
                    orderElement.setShippingCost(rs.getFloat("Orders.ShippingCost"));
                    orderElement.setShippingMethodName(rs.getString("Orders.ShippingMethodID"));
                    orderElement.setShippingPaid(rs.getFloat("Orders.ShippingPaid"));
                    orderElement.setPaypalAccount(rs.getString("Orders.OrderPaypal"));
                    Customer customer = new Customer();
                    customer.setCustomerAddress(rs.getString("Customers.CustomerAddress"));
                    customer.setCustomerCity(rs.getString("Customers.CustomerCity"));
                    customer.setCustomerCountry(rs.getString("Customers.CustomerCountry"));
                    customer.setCustomerEmail(rs.getString("Customers.CustomerEmail"));
                    customer.setCustomerName(rs.getString("Customers.CustomerName"));
                    customer.setCustomerState(rs.getString("Customers.CustomerState"));
                    customer.setCustomerUserName(rs.getString("Customers.CustomerUserName"));
                    customer.setCustomerZipcode(rs.getString("Customers.CustomerZipCode"));
                    orderElement.setCustomer(customer);
                    completeOrder.setOrder(orderElement);
                }
                OrderDetails orderDetailsElement = new OrderDetails();
                orderDetailsElement.setItemID(rs.getString("OrderDetails.ItemID"));
                orderDetailsElement.setOrderDetailsID(rs.getInt("OrderDetails.OrderDetailsID"));
                orderDetailsElement.setOrderID(rs.getInt("OrderDetails.OrderID"));
                orderDetailsElement.setBackordered(rs.getBoolean("OrderDetails.Backordered"));
                orderDetailsElement.setOrderNumber(rs.getString("OrderDetails.OrderNumber"));
                orderDetailsElement.setSalesPrice(rs.getFloat("OrderDetails.Salesprice"));
                orderDetailsElement.setItemCost(rs.getFloat("OrderDetails.ItemCost"));
                Date date = rs.getDate("OrderDetails.ShipDate");
                if (null != date) {
                    orderDetailsElement.setShipDate(date);
                }
                orderDetailsElement.setTransactionID(rs.getString("OrderDetails.TransactionID"));
                orderDetailsElement.setInhouse(rs.getBoolean("OrderDetails.Inhouse"));
                orderDetailsElement.setOrderDescription(rs.getString("OrderDetails.OrderDescription"));
                ArrayList orderDetailsList = completeOrder.getOrderDetails();
                orderDetailsList.add(orderDetailsElement);
                completeOrder.setOrderDetails(orderDetailsList);
                this._oosOrderList.put(completeOrder.getOrder().getOrderID(), completeOrder);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return this._oosOrderList.values().toArray(new CompleteOrder[0]);
    }
}

