/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.Date;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.JOptionPane;
import pnp.comms.db.PNPDatabaseManager;
import pnp.comms.db.lists.OrderStatusList;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.Order;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.OrderStatus;
import pnp.services.datatypes.PrintDetails;
import pnp.services.listener.GenericListener;
import pnp.services.listener.TransactionListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;

public class OrderList
implements TransactionListener {
    private HashMap<Integer, Integer> _statusFilters;
    private static OrderList _instance;
    private final Object _lock;
    private boolean _toggleSearch = false;
    private String _searchString = "";
    private OrderStatus[] _searchFilters;
    private long _searchFrom;
    private long _searchTo;
    private String _numResults;
    private boolean _toggleTracking = false;
    private boolean _toggleMultiOrder = false;
    private boolean _toggleNoInventory = false;
    private boolean _toggleOrderComments;
    private HashMap<Integer, CompleteOrder> _orderList;
    private HashMap<Integer, CompleteOrder> _orderListCached;
    private boolean refresh = true;
    private HashMap<OrderStatus, Integer> filterQuantities = new HashMap();
    private boolean useFilters = true;
    boolean forceRefresh = true;

    private OrderList() {
        this._orderList = new HashMap();
        this._orderListCached = new HashMap();
        this._lock = new Object();
        this._statusFilters = new HashMap();
        this._statusFilters.put(OrderStatusList.getInstance().getNewOrderStatus().getOrderStatusID(), OrderStatusList.getInstance().getNewOrderStatus().getOrderStatusID());
        ListenerManager.getInstance().subscribe((GenericListener)this);
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public HashMap<OrderStatus, Integer> getFilterQuantities() {
        return this.filterQuantities;
    }

    public void setFilterQuantities(HashMap<OrderStatus, Integer> filterQuantities) {
        this.filterQuantities = filterQuantities;
    }

    public static OrderList getInstance() {
        if (null == _instance) {
            _instance = new OrderList();
        }
        return _instance;
    }

    private Order parseOrder(ResultSet rs) {
        Order orderElement;
        block4: {
            orderElement = new Order();
            try {
                if (rs.isClosed()) break block4;
                try {
                    orderElement.setOrderComments(rs.getString("Orders.OrderComments"));
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex, false);
                }
                orderElement.setOrderDate(rs.getDate("Orders.OrderDate"));
                orderElement.setOrderID(rs.getInt("Orders.OrderID"));
                orderElement.setOrderStatus(OrderStatusList.getInstance().getOrderStatus(rs.getInt("Orders.OrderStatusID")));
                orderElement.setOrderTotal(rs.getFloat("Orders.OrderTotal"));
                orderElement.setShippingCost(rs.getFloat("Orders.ShippingCost"));
                orderElement.setShippingMethodName(rs.getString("Orders.ShippingMethodID"));
                orderElement.setShippingPaid(rs.getFloat("Orders.ShippingPaid"));
                orderElement.setPaypalAccount(rs.getString("Orders.OrderPaypal"));
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        return orderElement;
    }

    private OrderDetails parseOrderDetails(ResultSet rs) {
        OrderDetails orderDetailsElement = new OrderDetails();
        try {
            if (!rs.isClosed()) {
                orderDetailsElement.setItemID(rs.getString("OrderDetails.ItemID"));
                orderDetailsElement.setAccountName(rs.getString("OrderDetails.AccountName"));
                orderDetailsElement.setEbaySite(rs.getString("OrderDetails.EbaySite"));
                orderDetailsElement.setTrackingNumber(rs.getString("OrderDetails.TrackingNumber"));
                orderDetailsElement.setCarrier(rs.getString("OrderDetails.Carrier"));
                orderDetailsElement.setOrderDetailsID(rs.getInt("OrderDetails.OrderDetailsID"));
                orderDetailsElement.setOrderID(rs.getInt("OrderDetails.OrderID"));
                orderDetailsElement.setBackordered(rs.getBoolean("OrderDetails.Backordered"));
                orderDetailsElement.setOrderNumber(rs.getString("OrderDetails.OrderNumber"));
                orderDetailsElement.setSalesPrice(rs.getFloat("OrderDetails.Salesprice"));
                orderDetailsElement.setItemCost(rs.getFloat("OrderDetails.ItemCost"));
                orderDetailsElement.setTransactionID(rs.getString("OrderDetails.TransactionID"));
                orderDetailsElement.setInhouse(rs.getBoolean("OrderDetails.Inhouse"));
                orderDetailsElement.setOrderDescription(rs.getString("OrderDetails.OrderDescription"));
                orderDetailsElement.setEbayWeight(rs.getFloat("OrderDetails.EbayWeight"));
                Date date = rs.getDate("OrderDetails.ShipDate");
                if (null != date) {
                    orderDetailsElement.setShipDate(date);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return orderDetailsElement;
    }

    private Customer parseCustomer(ResultSet rs) {
        Customer customer = new Customer();
        try {
            if (!rs.isClosed()) {
                customer.setCustomerAddress(rs.getString("Customers.CustomerAddress"));
                customer.setCustomerCity(rs.getString("Customers.CustomerCity"));
                customer.setCustomerCountry(rs.getString("Customers.CustomerCountry"));
                customer.setCustomerEmail(rs.getString("Customers.CustomerEmail"));
                customer.setCustomerName(rs.getString("Customers.CustomerName"));
                customer.setCustomerState(rs.getString("Customers.CustomerState"));
                customer.setCustomerUserName(rs.getString("Customers.CustomerUserName"));
                customer.setCustomerZipcode(rs.getString("Customers.CustomerZipCode"));
                try {
                    customer.setCustomerComments(rs.getString("Customers.CustomerComments"));
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex, false);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return customer;
    }

    private HashMap<Integer, CompleteOrder> parseResultSet(ResultSet rs, boolean collectQuantities) {
        HashMap<Integer, CompleteOrder> orderList = new HashMap<Integer, CompleteOrder>();
        try {
            while (null != rs && !rs.isClosed() && rs.next()) {
                if (rs.getBoolean("OrderDetails.Deleted")) continue;
                int orderID = rs.getInt("Orders.OrderID");
                CompleteOrder completeOrder = new CompleteOrder();
                if (!orderList.containsKey(orderID)) {
                    Order order = this.parseOrder(rs);
                    Customer customer = this.parseCustomer(rs);
                    order.setCustomer(customer);
                    completeOrder.setOrder(order);
                } else {
                    completeOrder = orderList.get(orderID);
                }
                OrderDetails orderDetails = this.parseOrderDetails(rs);
                completeOrder.getOrderDetails().add(orderDetails);
                orderList.put(orderID, completeOrder);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return orderList;
    }

    public void refreshCachedOrderList() {
        this._orderListCached = this.createCachedOrderList();
    }

    public HashMap<Integer, CompleteOrder> createCachedOrderList() {
        HashMap<Integer, CompleteOrder> newHashMap = new HashMap<Integer, CompleteOrder>();
        for (CompleteOrder completeOrder : this._orderList.values()) {
            if (!newHashMap.containsKey(completeOrder.getOrder().getOrderID())) {
                newHashMap.put(completeOrder.getOrder().getOrderID(), new CompleteOrder());
            }
            CompleteOrder newOrder = newHashMap.get(completeOrder.getOrder().getOrderID());
            newOrder.setOrder(completeOrder.getOrder().copy());
            for (OrderDetails details : completeOrder.getOrderDetails()) {
                if (newOrder.getOrderDetails() == null) {
                    newOrder.setOrderDetails(new ArrayList());
                }
                newOrder.getOrderDetails().add(details.copy());
            }
        }
        return newHashMap;
    }

    public HashMap<Integer, CompleteOrder> getOrderListSpecial(boolean filtered) {
        boolean createFilters;
        boolean bl = createFilters = this.filterQuantities.isEmpty() || this.useFilters;
        if (createFilters) {
            this.filterQuantities.clear();
        }
        HashMap<Integer, CompleteOrder> newHashMap = new HashMap<Integer, CompleteOrder>();
        for (CompleteOrder completeOrder : this._orderList.values()) {
            if (createFilters) {
                if (!this.filterQuantities.containsKey(completeOrder.getOrder().getOrderStatus())) {
                    this.filterQuantities.put(completeOrder.getOrder().getOrderStatus(), completeOrder.getOrderDetails().size());
                } else {
                    Integer counter = this.filterQuantities.get(completeOrder.getOrder().getOrderStatus()) + completeOrder.getOrderDetails().size();
                    this.filterQuantities.put(completeOrder.getOrder().getOrderStatus(), counter);
                }
            }
            if (!filtered || !this._statusFilters.containsKey(completeOrder.getOrder().getOrderStatus().getOrderStatusID())) continue;
            newHashMap.put(completeOrder.getOrder().getOrderID(), completeOrder);
        }
        if (filtered) {
            return newHashMap;
        }
        return this._orderList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Integer, CompleteOrder> getOrderList(boolean cached) {
        Object object = this._lock;
        synchronized (object) {
            HashMap<Object, Object> orderList = new HashMap();
            orderList = cached ? this._orderListCached : (this._statusFilters != null && !this._statusFilters.isEmpty() ? this.getOrderListSpecial(true) : this.getOrderListSpecial(false));
            LookupServicesUtil.getManagerServices().manageFilters();
            return orderList;
        }
    }

    public HashMap<Integer, CompleteOrder> getBaseOrders() {
        ArrayList<OrderStatus> statusList = new ArrayList<OrderStatus>(OrderStatusList.getInstance().getOrderStatusList());
        statusList.remove(OrderStatusList.getInstance().getCanceledOrderStatus());
        statusList.remove(OrderStatusList.getInstance().getCompletedOrderStatus());
        ArrayList<Integer> statusInteger = new ArrayList<Integer>();
        for (OrderStatus status : statusList) {
            statusInteger.add(status.getOrderStatusID());
        }
        return this.parseResultSet(PNPDatabaseManager.getInstance().getOrderList(statusInteger.toArray(new Integer[0])), false);
    }

    public HashMap<Integer, CompleteOrder> getOrders(Integer[] statusFilters) {
        return this.parseResultSet(PNPDatabaseManager.getInstance().getOrderList(statusFilters), true);
    }

    public HashMap<Integer, CompleteOrder> getOrders(String searchString, OrderStatus[] searchFilters, long searchFrom, long searchTo, String numResults) {
        return this.parseResultSet(PNPDatabaseManager.getInstance().getOrderList(searchString, searchFilters, searchFrom, searchTo, numResults), false);
    }

    public HashMap<Integer, CompleteOrder> getOrdersForTracking() {
        HashMap<Integer, CompleteOrder> resultSet = this.parseResultSet(PNPDatabaseManager.getInstance().getOrderListForTrackingCheck(), false);
        HashMap<Integer, CompleteOrder> parsedResultSet = new HashMap<Integer, CompleteOrder>();
        block0: for (CompleteOrder completeOrder : resultSet.values()) {
            for (OrderDetails detail : completeOrder.getOrderDetails()) {
                if (detail.getTrackingNumber() != null && !detail.getTrackingNumber().isEmpty() || detail.getAccountName() == null || detail.getAccountName().isEmpty()) continue;
                parsedResultSet.put(completeOrder.getOrder().getOrderID(), completeOrder);
                continue block0;
            }
        }
        return parsedResultSet;
    }

    public HashMap<Integer, CompleteOrder> getCompletedOrders(long searchFrom, long searchTo) {
        return this.parseResultSet(PNPDatabaseManager.getInstance().getCompletedOrders(searchFrom, searchTo, null), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrder(Order order) {
        Object object = this._lock;
        synchronized (object) {
            PNPDatabaseManager.getInstance().updateOrder(order);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOrderDetails(OrderDetails orderDetails) {
        Object object = this._lock;
        synchronized (object) {
            PNPDatabaseManager.getInstance().updateOrderDetails(orderDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOrder(Order order) {
        Object object = this._lock;
        synchronized (object) {
            PNPDatabaseManager.getInstance().deleteOrder(order);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOrderDetails(CompleteOrder completeOrder, OrderDetails details) {
        Object object = this._lock;
        synchronized (object) {
            details.setDeleted(true);
            PNPDatabaseManager.getInstance().updateOrderDetails(details);
            boolean delete = true;
            for (OrderDetails orderDetails : completeOrder.getOrderDetails()) {
                if (orderDetails.isDeleted()) continue;
                delete = false;
            }
            if (delete) {
                completeOrder.getOrder().setOrderStatus(OrderStatusList.getInstance().getCanceledOrderStatus());
                PNPDatabaseManager.getInstance().updateOrder(completeOrder.getOrder());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmergeOrders(HashMap<CompleteOrder, ArrayList<OrderDetails>> unmergeList) {
        Object object = this._lock;
        synchronized (object) {
            for (CompleteOrder completeOrder : unmergeList.keySet()) {
                if (completeOrder.getOrderDetails().size() == 1) continue;
                for (OrderDetails orderDetails : unmergeList.get(completeOrder)) {
                    Order order = completeOrder.getOrder().copy();
                    order.setOrderID(0);
                    order.setShippingCost(0.0f);
                    order.setShippingPaid(0.0f);
                    order.setOrderTotal(orderDetails.getSalesPrice());
                    this.updateOrder(order);
                    orderDetails.setOrderID(order.getOrderID());
                    this.updateOrderDetails(orderDetails);
                    completeOrder.getOrder().setOrderTotal(completeOrder.getOrder().getOrderTotal() - orderDetails.getSalesPrice());
                    this.updateOrder(completeOrder.getOrder());
                }
            }
        }
    }

    public ArrayList<OrderDetails> splitOrders(OrderDetails orderDetails, boolean createBlank) {
        ArrayList<OrderDetails> detailList = new ArrayList<OrderDetails>();
        boolean original = true;
        boolean multiply = false;
        if (orderDetails.getItemID().contains("/")) {
            multiply = true;
        }
        String itemID = orderDetails.getItemID().trim().toLowerCase().replace(" and ", ",").replace("*", "x").replace(" ", "").replace(";", ",").replace("/", ",");
        HashMap<String, Integer> itemList = new HashMap<String, Integer>();
        if (!orderDetails.isInhouse()) {
            int largestMatch = 0;
            for (String item : itemID.split(",")) {
                int matchesFound = 1;
                if (item.matches(".*x[0-9]+$")) {
                    matchesFound = Integer.valueOf(item.substring(item.lastIndexOf("x") + 1, item.length()));
                    item = item.substring(0, item.lastIndexOf("x"));
                }
                if (largestMatch < matchesFound) {
                    largestMatch = matchesFound;
                }
                if (!itemList.containsKey(item)) {
                    itemList.put(item, matchesFound);
                    continue;
                }
                itemList.put(item, (Integer)itemList.get(item) + matchesFound);
            }
            for (String item : itemList.keySet()) {
                if (multiply) {
                    itemList.put(item, largestMatch);
                }
                for (int i = 0; i < (Integer)itemList.get(item); ++i) {
                    OrderDetails newDetails = orderDetails.copy();
                    newDetails.setItemID(item);
                    if (!original) {
                        newDetails.setSalesPrice(0.0f);
                        newDetails.setItemCost(0.0f);
                        newDetails.setOrderDetailsID(0);
                        newDetails.setAccountName("");
                        newDetails.setEbaySite("");
                        newDetails.setOrderNumber("");
                        newDetails.setTransactionID(UUID.randomUUID().toString());
                    }
                    original = false;
                    detailList.add(newDetails);
                }
            }
        }
        if (createBlank && (itemList.isEmpty() || itemList.size() == 1 && itemList.values().contains(1))) {
            OrderDetails newDetails = new OrderDetails();
            newDetails.setOrderID(orderDetails.getOrderID());
            newDetails.setTransactionID(UUID.randomUUID().toString());
            this.updateOrderDetails(newDetails);
        }
        return detailList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void splitOrders(HashMap<CompleteOrder, ArrayList<OrderDetails>> splitList) {
        Object object = this._lock;
        synchronized (object) {
            for (CompleteOrder completeOrder : splitList.keySet()) {
                for (OrderDetails orderDetails : splitList.get(completeOrder)) {
                    ArrayList<OrderDetails> detailList = this.splitOrders(orderDetails, true);
                    for (OrderDetails detail : detailList) {
                        this.updateOrderDetails(detail);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompleteOrder mergeOrders(ArrayList<CompleteOrder> mergeList) {
        float shippingCost = 0.0f;
        String shippingMethod = "";
        CompleteOrder parentOrder = null;
        boolean invalidMerge = false;
        Object object = this._lock;
        synchronized (object) {
            for (CompleteOrder completeOrder : mergeList) {
                PrintDetails detail = LookupServicesUtil.getDBServices().getPrintDetails(String.valueOf(completeOrder.getOrder().getOrderID()));
                if (detail == null || detail.isPrinted() || detail.getStampsID() == null) continue;
                if (parentOrder == null) {
                    parentOrder = completeOrder;
                    shippingCost = parentOrder.getOrder().getShippingCost();
                    shippingMethod = parentOrder.getOrder().getShippingMethodName();
                    continue;
                }
                invalidMerge = true;
            }
            if (!invalidMerge) {
                for (CompleteOrder completeOrder : mergeList) {
                    if (parentOrder == null) {
                        parentOrder = completeOrder;
                        shippingCost = parentOrder.getOrder().getShippingCost();
                        shippingMethod = parentOrder.getOrder().getShippingMethodName();
                        continue;
                    }
                    if (completeOrder == parentOrder) continue;
                    parentOrder.getOrder().setOrderComments(this.combineComments(parentOrder.getOrder().getOrderComments(), completeOrder.getOrder().getOrderComments()));
                    parentOrder.getOrder().setOrderTotal(parentOrder.getOrder().getOrderTotal() + completeOrder.getOrder().getOrderTotal());
                    parentOrder.getOrder().setShippingCost(parentOrder.getOrder().getShippingCost() + completeOrder.getOrder().getShippingCost());
                    parentOrder.getOrder().setShippingPaid(parentOrder.getOrder().getShippingPaid() + completeOrder.getOrder().getShippingPaid());
                    if (completeOrder.getOrder().getShippingCost() > shippingCost) {
                        shippingCost = completeOrder.getOrder().getShippingCost();
                        shippingMethod = completeOrder.getOrder().getShippingMethodName();
                    }
                    for (OrderDetails orderDetails : completeOrder.getOrderDetails()) {
                        orderDetails.setOrderID(parentOrder.getOrder().getOrderID());
                        parentOrder.getOrderDetails().add(orderDetails);
                        this.updateOrderDetails(orderDetails);
                    }
                    this.deleteOrder(completeOrder.getOrder());
                }
                if (parentOrder != null) {
                    parentOrder.getOrder().setShippingMethodName(shippingMethod);
                    this.updateOrder(parentOrder.getOrder());
                }
            } else {
                JOptionPane.showMessageDialog(null, "Invalid Merge. Two or more of the orders specified for merge are waiting printing. \nPlease finish printing to merge these items.");
            }
        }
        return parentOrder;
    }

    public Set<String> parseTransactions(String comment) {
        HashSet<String> transactions = new HashSet<String>();
        if (comment != null) {
            comment = comment.trim();
            for (String split1 : comment.split("TRANSACTIONID: \\[")) {
                String[] split2 = split1.split("\\]");
                if (split2.length <= 0 || !split2[0].matches("[A-Z0-9]+")) continue;
                transactions.add(split2[0]);
            }
        }
        return transactions;
    }

    public String[] parseString(String comments) {
        String[] parsedString = new String[]{"", ""};
        if (comments != null) {
            comments = comments.trim();
            String[] fullComments = comments.split("TRANSACTIONID: \\[[A-Z0-9]*\\]");
            int counter = 0;
            for (String comment : fullComments) {
                if (!(comment = comment.trim()).isEmpty()) {
                    if (counter != 0 && counter == fullComments.length - 1) {
                        parsedString[1] = comment;
                    } else {
                        parsedString[0] = parsedString[0] + comment + " ";
                    }
                }
                ++counter;
            }
            parsedString[0] = parsedString[0].trim();
        }
        return parsedString;
    }

    public String combineComments(String first, String second) {
        String orderComments = "";
        HashSet<String> transactions = new HashSet<String>();
        transactions.addAll(this.parseTransactions(first));
        transactions.addAll(this.parseTransactions(second));
        String[] parsedFirstString = this.parseString(first);
        String[] parsedSecondString = this.parseString(second);
        if (!parsedFirstString[0].equalsIgnoreCase(parsedSecondString[0]) && !parsedFirstString[0].toLowerCase().contains(parsedSecondString[0].toLowerCase())) {
            if (!parsedFirstString[0].isEmpty()) {
                parsedFirstString[0] = parsedFirstString[0] + "\n";
            }
            parsedFirstString[0] = parsedFirstString[0] + parsedSecondString[0];
        }
        if (!parsedFirstString[1].equalsIgnoreCase(parsedSecondString[1]) && !parsedFirstString[1].toLowerCase().contains(parsedSecondString[1].toLowerCase())) {
            if (!parsedFirstString[1].isEmpty()) {
                parsedFirstString[1] = parsedFirstString[1] + "\n";
            }
            parsedFirstString[1] = parsedFirstString[1] + parsedSecondString[1];
        }
        orderComments = parsedFirstString[0];
        for (String transaction : transactions) {
            orderComments = orderComments + "\nTRANSACTIONID: [" + transaction + "]";
        }
        if (!parsedFirstString[1].isEmpty()) {
            orderComments = orderComments + "\n" + parsedFirstString[1];
        }
        return orderComments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchOrders(String searchString, OrderStatus[] filters, long from, long to, String results) {
        Object object = this._lock;
        synchronized (object) {
            this._toggleSearch = true;
            this._toggleTracking = false;
            this._toggleMultiOrder = false;
            this._toggleNoInventory = false;
            this._toggleOrderComments = false;
            this._statusFilters.clear();
            this._searchString = searchString;
            this._searchFilters = filters;
            this._searchFrom = from;
            this._searchTo = to;
            this._numResults = results;
            this.newTransactionAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useStatusFilters(Integer[] statusFilters) {
        Object object = this._lock;
        synchronized (object) {
            this._toggleTracking = false;
            this._toggleSearch = false;
            this._toggleMultiOrder = false;
            this._statusFilters.clear();
            Integer[] arr$ = statusFilters;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int index = arr$[i$];
                this._statusFilters.put(index, index);
            }
            this.newTransactionAvailable();
        }
    }

    private ArrayList<OrderStatus> pruneFilters(ArrayList<OrderStatus> filter) {
        ArrayList<OrderStatus> filters = new ArrayList<OrderStatus>();
        for (OrderStatus status : filter) {
            if (status.getOrderStatusType().equalsIgnoreCase("canceled") || status.getOrderStatusType().equalsIgnoreCase("complete")) continue;
            filters.add(status);
        }
        return filters;
    }

    private Integer[] getFilters(ArrayList<OrderStatus> filter) {
        Integer[] filters = new Integer[filter.size()];
        int counter = 0;
        for (OrderStatus status : filter) {
            filters[counter++] = status.getOrderStatusID();
        }
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackingOverride(boolean enabled) {
        Object object = this._lock;
        synchronized (object) {
            this._toggleTracking = enabled;
            this._toggleSearch = false;
            this._toggleMultiOrder = false;
            this._toggleNoInventory = false;
            this._toggleOrderComments = false;
            this._statusFilters.clear();
            this.newTransactionAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMultiOrders(boolean enabled) {
        Object object = this._lock;
        synchronized (object) {
            this._toggleMultiOrder = enabled;
            this._toggleTracking = false;
            this._toggleSearch = false;
            this._toggleNoInventory = false;
            this._toggleOrderComments = false;
            this._statusFilters.clear();
            this.newTransactionAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoInventory(boolean enabled) {
        Object object = this._lock;
        synchronized (object) {
            this._toggleNoInventory = enabled;
            this._toggleMultiOrder = false;
            this._toggleTracking = false;
            this._toggleSearch = false;
            this._toggleOrderComments = false;
            this.newTransactionAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrderComments(boolean enabled) {
        Object object = this._lock;
        synchronized (object) {
            this._toggleOrderComments = enabled;
            this._toggleNoInventory = false;
            this._toggleMultiOrder = false;
            this._toggleTracking = false;
            this._toggleSearch = false;
            this.newTransactionAvailable();
        }
    }

    private HashMap<Integer, CompleteOrder> multiOrder(HashMap<Integer, CompleteOrder> baseOrders) {
        HashMap allCustomerOrders = new HashMap();
        HashMap<Integer, CompleteOrder> finalCustomerOrders = new HashMap<Integer, CompleteOrder>();
        for (CompleteOrder completeOrder : baseOrders.values()) {
            if (completeOrder.getOrder().getOrderStatus().getOrderStatusType().equalsIgnoreCase("Export Labels")) continue;
            if (!allCustomerOrders.containsKey(completeOrder.getOrder().getCustomer().getCustomerUserName())) {
                allCustomerOrders.put(completeOrder.getOrder().getCustomer().getCustomerUserName(), new HashMap());
            }
            ((HashMap)allCustomerOrders.get(completeOrder.getOrder().getCustomer().getCustomerUserName())).put(completeOrder.getOrder().getOrderID(), completeOrder);
        }
        for (String customer : allCustomerOrders.keySet()) {
            if (((HashMap)allCustomerOrders.get(customer)).size() <= 1) continue;
            finalCustomerOrders.putAll((Map)allCustomerOrders.get(customer));
        }
        return finalCustomerOrders;
    }

    private HashMap<Integer, CompleteOrder> noInventory(HashMap<Integer, CompleteOrder> baseOrders) {
        HashMap<Integer, CompleteOrder> finalCustomerOrders = new HashMap<Integer, CompleteOrder>();
        block0: for (CompleteOrder completeOrder : baseOrders.values()) {
            for (OrderDetails detail : completeOrder.getOrderDetails()) {
                if (detail.isInhouse()) continue;
                finalCustomerOrders.put(completeOrder.getOrder().getOrderID(), completeOrder);
                continue block0;
            }
        }
        return finalCustomerOrders;
    }

    private HashMap<Integer, CompleteOrder> orderComments(HashMap<Integer, CompleteOrder> baseOrders) {
        HashMap<Integer, CompleteOrder> finalCustomerOrders = new HashMap<Integer, CompleteOrder>();
        for (CompleteOrder completeOrder : baseOrders.values()) {
            Order detail = completeOrder.getOrder();
            if (detail.getOrderComments() == null || detail.getOrderComments().trim().isEmpty()) continue;
            String pruneResults = detail.getOrderComments().trim().replace(" ", "").replace("[", "").replace("]", ";").replace("TRANSACTIONID:", ";");
            if ((pruneResults = pruneResults.replaceAll(";([0-9 |a-z |A-Z]+);", "")).isEmpty()) continue;
            finalCustomerOrders.put(completeOrder.getOrder().getOrderID(), completeOrder);
        }
        return finalCustomerOrders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newTransactionAvailable() {
        Object object = this._lock;
        synchronized (object) {
            if (this._toggleSearch) {
                this._orderList = this.getOrders(this._searchString, this._searchFilters, this._searchFrom, this._searchTo, this._numResults);
                this.forceRefresh = true;
            } else if (this._toggleTracking) {
                this._orderList = this.getOrdersForTracking();
                this.forceRefresh = true;
            } else if (this._toggleMultiOrder) {
                this._orderList = this.multiOrder(this.getBaseOrders());
                this.forceRefresh = true;
            } else if (this._toggleNoInventory) {
                this.useFilters = true;
                HashMap<Integer, Integer> allStatus = new HashMap<Integer, Integer>();
                Integer[] arr$ = this.getFilters(this.pruneFilters(LookupServicesUtil.getDBServices().getOrderStatusList()));
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    int index = arr$[i$];
                    allStatus.put(index, index);
                }
                this._orderList = this.noInventory(this.getOrders(allStatus.values().toArray(new Integer[0])));
                this.forceRefresh = true;
            } else if (this._toggleOrderComments) {
                this.useFilters = true;
                HashMap<Integer, Integer> allStatus = new HashMap<Integer, Integer>();
                Integer[] arr$ = this.getFilters(this.pruneFilters(LookupServicesUtil.getDBServices().getOrderStatusList()));
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    int index = arr$[i$];
                    allStatus.put(index, index);
                }
                this._orderList = this.orderComments(this.getOrders(allStatus.values().toArray(new Integer[0])));
                this.forceRefresh = true;
            } else if (this.refresh || this.forceRefresh) {
                this.useFilters = true;
                HashMap<Integer, Integer> allStatus = new HashMap<Integer, Integer>();
                Integer[] arr$ = this.getFilters(this.pruneFilters(LookupServicesUtil.getDBServices().getOrderStatusList()));
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    int index = arr$[i$];
                    allStatus.put(index, index);
                }
                this._orderList = this.getOrders(allStatus.values().toArray(new Integer[0]));
                this.forceRefresh = false;
            }
            this._orderListCached = this.createCachedOrderList();
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.ORDER_LIST_LISTENER);
            this.refresh = true;
            this.useFilters = false;
        }
    }
}

