/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.OrderStatus;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class OrderStatusList {
    private static OrderStatusList _instance;
    private ArrayList<OrderStatus> orderStatusList = new ArrayList();
    private OrderStatus _newOrderStatus;
    private OrderStatus _pendingOrderStatus;
    private OrderStatus _oosOrderStatus;
    private OrderStatus _npbOrderStatus;
    private OrderStatus _canceledOrderStatus;
    private OrderStatus _completedOrderStatus;
    private OrderStatus _pendingPrintStatus;
    private OrderStatus _pendingMOStatus;
    private OrderStatus _pendingECheckStatus;
    private OrderStatus _exportLabels;
    private OrderStatus _adminHold;

    private OrderStatusList() {
        ResultSet rs = PNPDatabaseManager.getInstance().getOrderStatusList();
        try {
            if (null != rs) {
                while (rs.next()) {
                    if (rs.getString("OrderStatusType").equals("New")) {
                        this._newOrderStatus = new OrderStatus(rs.getInt("OrderStatusID"), rs.getString("OrderStatusType"));
                        this.orderStatusList.add(this._newOrderStatus);
                        continue;
                    }
                    if (rs.getString("OrderStatusType").equals("Pending")) {
                        this._pendingOrderStatus = new OrderStatus(rs.getInt("OrderStatusID"), rs.getString("OrderStatusType"));
                        this.orderStatusList.add(this._pendingOrderStatus);
                        continue;
                    }
                    if (rs.getString("OrderStatusType").equals("Complete")) {
                        this._completedOrderStatus = new OrderStatus(rs.getInt("OrderStatusID"), rs.getString("OrderStatusType"));
                        this.orderStatusList.add(this._completedOrderStatus);
                        continue;
                    }
                    if (rs.getString("OrderStatusType").equals("OOS")) {
                        this._oosOrderStatus = new OrderStatus(rs.getInt("OrderStatusID"), rs.getString("OrderStatusType"));
                        this.orderStatusList.add(this._oosOrderStatus);
                        continue;
                    }
                    if (rs.getString("OrderStatusType").equals("NPB")) {
                        this._npbOrderStatus = new OrderStatus(rs.getInt("OrderStatusID"), rs.getString("OrderStatusType"));
                        this.orderStatusList.add(this._npbOrderStatus);
                        continue;
                    }
                    if (rs.getString("OrderStatusType").equals("Canceled")) {
                        this._canceledOrderStatus = new OrderStatus(rs.getInt("OrderStatusID"), rs.getString("OrderStatusType"));
                        this.orderStatusList.add(this._canceledOrderStatus);
                        continue;
                    }
                    if (rs.getString("OrderStatusType").equals("Pending Print")) {
                        this._pendingPrintStatus = new OrderStatus(rs.getInt("OrderStatusID"), rs.getString("OrderStatusType"));
                        this.orderStatusList.add(this._pendingPrintStatus);
                        continue;
                    }
                    if (rs.getString("OrderStatusType").equals("Pending MO")) {
                        this._pendingMOStatus = new OrderStatus(rs.getInt("OrderStatusID"), rs.getString("OrderStatusType"));
                        this.orderStatusList.add(this._pendingMOStatus);
                        continue;
                    }
                    if (rs.getString("OrderStatusType").equals("Pending E-Check")) {
                        this._pendingECheckStatus = new OrderStatus(rs.getInt("OrderStatusID"), rs.getString("OrderStatusType"));
                        this.orderStatusList.add(this._pendingECheckStatus);
                        continue;
                    }
                    if (rs.getString("OrderStatusType").equals("Export Labels")) {
                        this._exportLabels = new OrderStatus(rs.getInt("OrderStatusID"), rs.getString("OrderStatusType"));
                        this.orderStatusList.add(this._exportLabels);
                        continue;
                    }
                    if (!rs.getString("OrderStatusType").equals("Admin Hold")) continue;
                    this._adminHold = new OrderStatus(rs.getInt("OrderStatusID"), rs.getString("OrderStatusType"));
                    this.orderStatusList.add(this._adminHold);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
    }

    public static OrderStatusList getInstance() {
        if (null == _instance) {
            _instance = new OrderStatusList();
        }
        return _instance;
    }

    public ArrayList<OrderStatus> getOrderStatusList() {
        return this.orderStatusList;
    }

    public OrderStatus getCanceledOrderStatus() {
        return this._canceledOrderStatus;
    }

    public OrderStatus getCompletedOrderStatus() {
        return this._completedOrderStatus;
    }

    public OrderStatus getNewOrderStatus() {
        return this._newOrderStatus;
    }

    public OrderStatus getNpbOrderStatus() {
        return this._npbOrderStatus;
    }

    public OrderStatus getOosOrderStatus() {
        return this._oosOrderStatus;
    }

    public OrderStatus getPendingOrderStatus() {
        return this._pendingOrderStatus;
    }

    public OrderStatus getPendingPrintStatus() {
        return this._pendingPrintStatus;
    }

    public OrderStatus getPendingECheckStatus() {
        return this._pendingECheckStatus;
    }

    public OrderStatus getPendingMOStatus() {
        return this._pendingMOStatus;
    }

    public OrderStatus getExportLabelsStatus() {
        return this._exportLabels;
    }

    public OrderStatus getAdminHoldStatus() {
        return this._adminHold;
    }

    public OrderStatus getOrderStatus(int orderStatusID) {
        Iterator<OrderStatus> iterator = this.orderStatusList.iterator();
        boolean found = false;
        OrderStatus status = null;
        while (iterator.hasNext() && !found) {
            status = iterator.next();
            if (status.getOrderStatusID() != orderStatusID) continue;
            found = true;
        }
        return status;
    }
}

