/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import StampsSDK.PackageTypeV6;
import StampsSDK.ServiceType;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.PrintDetails;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.GenericFunctions;
import pnp.services.util.LookupServicesUtil;

public class PrintDetailsList {
    private static PrintDetailsList _instance;
    private int lastPrintID = 0;

    private PrintDetailsList() {
    }

    public int getLastPrintID() {
        return ++this.lastPrintID;
    }

    public static PrintDetailsList getInstance() {
        if (null == _instance) {
            _instance = new PrintDetailsList();
        }
        return _instance;
    }

    private String createSubstring(String name, int length) {
        name = GenericFunctions.getInstance().prepareString(name);
        if (name.trim().length() > length) {
            name = name.trim().substring(0, length);
        }
        return name;
    }

    public void insertPrintDetails(PrintDetails newDetails) {
        newDetails.setFirstName(this.createSubstring(newDetails.getFirstName(), 50));
        newDetails.setLastName(this.createSubstring(newDetails.getLastName(), 50));
        newDetails.setEmail(this.createSubstring(newDetails.getEmail(), 256));
        newDetails.setStreet1(this.createSubstring(newDetails.getStreet1(), 150));
        newDetails.setStreet2(this.createSubstring(newDetails.getStreet2(), 150));
        newDetails.setCustomer(this.createSubstring(newDetails.getCustomer(), 128));
        newDetails.setCity(this.createSubstring(newDetails.getCity(), 32));
        newDetails.setCountryCode(this.createSubstring(newDetails.getCountryCode(), 2));
        newDetails.setState(this.createSubstring(newDetails.getState(), 40));
        newDetails.setPostalCode(this.createSubstring(newDetails.getPostalCode(), 20));
        PNPDatabaseManager.getInstance().insertPrintDetails(newDetails);
    }

    public HashMap<String, PrintDetails> parseResultSet(ResultSet rs) {
        HashMap<String, PrintDetails> detailArray;
        block15: {
            detailArray = new HashMap<String, PrintDetails>();
            try {
                if (null == rs) break block15;
                while (rs.next()) {
                    PrintDetails newDetails = new PrintDetails();
                    newDetails.setCity(rs.getString("City"));
                    newDetails.setCost(Double.valueOf(rs.getDouble("Cost")));
                    newDetails.setCountryCode(rs.getString("CountryCode"));
                    newDetails.setCustomer(rs.getString("Customer"));
                    newDetails.setEmail(rs.getString("Email"));
                    newDetails.setFirstName(rs.getString("FirstName"));
                    newDetails.setLastName(rs.getString("LastName"));
                    newDetails.setPostalCode(rs.getString("PostalCode"));
                    String packageType = rs.getString("PackageType");
                    String serviceType = rs.getString("ShippingType");
                    if (serviceType == null || serviceType.trim().isEmpty()) {
                        serviceType = !DatabaseConnector.usingSQLDB ? this.getServiceName((ServiceType)rs.getObject("Shipping")) : "UNKNOWN";
                    }
                    if (packageType == null || packageType.trim().isEmpty()) {
                        packageType = !DatabaseConnector.usingSQLDB ? ((PackageTypeV6)rs.getObject("Package")).value() : "UNKNOWN";
                    }
                    newDetails.setPackageType(packageType);
                    newDetails.setShipping(serviceType);
                    newDetails.setState(rs.getString("State"));
                    newDetails.setStreet1(rs.getString("Street1"));
                    newDetails.setStreet2(rs.getString("Street2"));
                    newDetails.setOrderID(rs.getString("OrderID"));
                    newDetails.setWeight(Double.valueOf(rs.getDouble("Weight")));
                    newDetails.setPackedWeight(Double.valueOf(rs.getDouble("PackedWeight")));
                    try {
                        newDetails.setErrorDetails(rs.getString("IndiciumID"));
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    try {
                        newDetails.setActualErrorDetails(rs.getString("ActualErrorDetails"));
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    newDetails.setTracking(rs.getString("Tracking"));
                    try {
                        newDetails.setUrl(rs.getString("URL"));
                    }
                    catch (Exception ex) {
                        newDetails.setUrl("");
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    newDetails.setStampsID(rs.getString("StampsID"));
                    newDetails.setScan(rs.getBoolean("Scan"));
                    newDetails.setError(rs.getBoolean("Error"));
                    newDetails.setCanceled(rs.getBoolean("Canceled"));
                    newDetails.setPrinted(rs.getBoolean("Printed"));
                    try {
                        newDetails.setLabelInstructions(rs.getString("LabelInstructions"));
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    newDetails.setDateEntered((Date)rs.getDate("DateEntered"));
                    newDetails.setCopies(rs.getInt("Copies"));
                    newDetails.setParentOrderID(rs.getString("ParentOrderID"));
                    newDetails.setOrderTotal(rs.getDouble("OrderTotal"));
                    newDetails.setShipDate((Date)rs.getDate("ShipDate"));
                    newDetails.setDeclaredWeight(rs.getDouble("DeclaredValue"));
                    newDetails.setPrintDate((Date)rs.getTimestamp("PrintDate"));
                    newDetails.setPaypalAccount(rs.getString("PayPalAccount"));
                    int printID = rs.getInt("PrintID");
                    if (printID > this.lastPrintID) {
                        this.lastPrintID = printID;
                    }
                    newDetails.setPrintID(printID);
                    newDetails.setPrintPage(rs.getInt("PrintPage"));
                    HashMap checkDetails = LookupServicesUtil.getDBServices().getCheckDetails(newDetails.getParentOrderID());
                    if (checkDetails != null) {
                        newDetails.setOrderDetailsList(checkDetails);
                    }
                    detailArray.put(newDetails.getOrderID(), newDetails);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        return detailArray;
    }

    public HashMap<String, PrintDetails> getPrintDetails() {
        ResultSet rs = PNPDatabaseManager.getInstance().getPrintDetails();
        return this.parseResultSet(rs);
    }

    public PrintDetails getPrintDetails(String orderID) {
        ResultSet rs = PNPDatabaseManager.getInstance().getPrintDetails(orderID);
        HashMap<String, PrintDetails> printList = this.parseResultSet(rs);
        PrintDetails newPrintDetails = null;
        if (printList.containsKey(orderID)) {
            newPrintDetails = printList.get(orderID);
        }
        return newPrintDetails;
    }

    public void deletePrintDetails(String transactionID) {
        PNPDatabaseManager.getInstance().deletePrintDetails(transactionID);
    }

    public HashMap<String, PrintDetails> searchPrintDetails(String searchString) {
        ResultSet rs = PNPDatabaseManager.getInstance().searchPrintDetails(searchString);
        return this.parseResultSet(rs);
    }

    private String getServiceName(ServiceType serviceType) {
        String serviceString = "First Class";
        if (serviceType != null) {
            if (serviceType.equals((Object)ServiceType.US_FC)) {
                serviceString = "First Class";
            } else if (serviceType.equals((Object)ServiceType.US_FCI)) {
                serviceString = "Int. First Class";
            } else if (serviceType.equals((Object)ServiceType.US_EMI)) {
                serviceString = "Int. Express";
            } else if (serviceType.equals((Object)ServiceType.US_PMI)) {
                serviceString = "Int. Priority";
            } else if (serviceType.equals((Object)ServiceType.US_MM)) {
                serviceString = "Media Mail";
            } else if (serviceType.equals((Object)ServiceType.US_PM)) {
                serviceString = "Priority";
            } else if (serviceType.equals((Object)ServiceType.US_PS)) {
                serviceString = "Parcel Select";
            } else if (serviceType.equals((Object)ServiceType.US_XM)) {
                serviceString = "Express";
            }
        }
        return serviceString;
    }
}

