/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.RESTData;
import pnp.services.datatypes.webservices.Amazonaccount;
import pnp.services.datatypes.webservices.Ebayaccount;
import pnp.services.datatypes.webservices.Paypalaccount;
import pnp.services.datatypes.webservices.SubscriptionTemp;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class RESTList {
    private static RESTList _instance;

    private RESTList() {
    }

    public static RESTList getInstance() {
        if (null == _instance) {
            _instance = new RESTList();
        }
        return _instance;
    }

    public RESTData getRESTdata(String userName) {
        RESTData restData;
        ResultSet subscriptionRS;
        SubscriptionTemp subscription;
        block20: {
            subscription = new SubscriptionTemp();
            subscriptionRS = PNPDatabaseManager.getInstance().getSubscription(userName);
            restData = new RESTData();
            if (subscriptionRS != null) {
                try {
                    if (!subscriptionRS.next()) break block20;
                    subscription.setCustomerUserName(userName);
                    restData.setFinance(subscriptionRS.getBoolean("Finance"));
                    restData.setInventory(subscriptionRS.getBoolean("Inventory"));
                    restData.setWebsite(subscriptionRS.getBoolean("Website"));
                    restData.setMulti(subscriptionRS.getBoolean("Multi"));
                    restData.setPaypal(subscriptionRS.getBoolean("Paypal"));
                    restData.setPrint(subscriptionRS.getBoolean("Print"));
                    restData.setCurrent(subscriptionRS.getBoolean("Current"));
                    restData.setExpire(subscriptionRS.getDate("Expire"));
                    restData.setOffline(subscriptionRS.getBoolean("Offline"));
                    restData.setTimer(subscriptionRS.getDate("Timer"));
                    restData.setPassword(subscriptionRS.getString("Password"));
                    restData.setLicense(subscriptionRS.getString("License"));
                    ResultSet ebayRS = PNPDatabaseManager.getInstance().getEbayAccount(userName);
                    ResultSet paypalRS = PNPDatabaseManager.getInstance().getPaypalAccount(userName);
                    ResultSet amazonRS = PNPDatabaseManager.getInstance().getAmazonAccount(userName);
                    while (ebayRS != null && ebayRS.next()) {
                        try {
                            Ebayaccount ebayAccount = new Ebayaccount();
                            ebayAccount.setEbayAccountID(ebayRS.getString("EbayAccountID"));
                            ebayAccount.setEbayAccountNumber(Integer.valueOf(ebayRS.getInt("EbayAccountNumber")));
                            try {
                                ebayAccount.setUserToken(ebayRS.getString("UserToken"));
                            }
                            catch (Exception ex) {
                                ErrorsUtil.getInstance().logError(ex, false);
                            }
                            ebayAccount.setCustomerUserName(subscription);
                            subscription.getEbayaccountCollection().add(ebayAccount);
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex);
                        }
                    }
                    while (paypalRS != null && paypalRS.next()) {
                        try {
                            Paypalaccount paypalAccount = new Paypalaccount();
                            paypalAccount.setPaypalAccountNumber(Integer.valueOf(paypalRS.getInt("PaypalAccountNumber")));
                            paypalAccount.setPaypalAccountID(paypalRS.getString("PaypalAccountID"));
                            try {
                                paypalAccount.setAccessToken(paypalRS.getString("AccessToken"));
                            }
                            catch (Exception ex) {
                                ErrorsUtil.getInstance().logError(ex, false);
                            }
                            try {
                                paypalAccount.setTokenSecret(paypalRS.getString("TokenSecret"));
                            }
                            catch (Exception ex) {
                                ErrorsUtil.getInstance().logError(ex, false);
                            }
                            paypalAccount.setCustomerUserName(subscription);
                            subscription.getPaypalaccountCollection().add(paypalAccount);
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex);
                        }
                    }
                    while (amazonRS != null && amazonRS.next()) {
                        try {
                            Amazonaccount amazonAccount = new Amazonaccount();
                            amazonAccount.setAmazonAccountNumber(Integer.valueOf(amazonRS.getInt("AmazonAccountNumber")));
                            amazonAccount.setAmazonAccountID(amazonRS.getString("AmazonAccountID"));
                            try {
                                amazonAccount.setUserToken(amazonRS.getString("UserToken"));
                            }
                            catch (Exception ex) {
                                ErrorsUtil.getInstance().logError(ex, false);
                            }
                            amazonAccount.setCustomerUserName(subscription);
                            subscription.getAmazonaccountCollection().add(amazonAccount);
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex);
                        }
                    }
                    DatabaseConnector.removeObject((ResultSet)ebayRS);
                    DatabaseConnector.removeObject((ResultSet)amazonRS);
                    DatabaseConnector.removeObject((ResultSet)paypalRS);
                }
                catch (Exception ex) {
                    ErrorsUtil.getInstance().logError(ex);
                }
            }
        }
        DatabaseConnector.removeObject((ResultSet)subscriptionRS);
        restData.setSubscription(subscription);
        return restData;
    }

    public void updateRESTData(RESTData restData) {
        PNPDatabaseManager.getInstance().updateRESTData(restData);
    }
}

