/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.Date;
import java.sql.ResultSet;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.comms.db.lists.RMAStatusList;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.OrderDetails;
import pnp.services.datatypes.RMADetails;
import pnp.services.listener.GenericListener;
import pnp.services.listener.RMAListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class RMAList
implements RMAListener {
    private HashMap<Integer, RMADetails> _rmaList;
    private HashMap<Integer, Integer> _statusFilters;
    private HashMap<Integer, Integer> _reasonFilters;
    private static RMAList _instance;
    private final Object _lock = new Object();
    private String _searchString = "";
    private long _searchFrom;
    private long _searchTo;

    private RMAList() {
        this._rmaList = new HashMap();
        this._reasonFilters = new HashMap();
        this._statusFilters = new HashMap();
        this._statusFilters.put(RMAStatusList.getInstance().getNewRmaStatus().getRmaStatusID(), RMAStatusList.getInstance().getNewRmaStatus().getRmaStatusID());
        ListenerManager.getInstance().subscribe((GenericListener)this);
    }

    public static RMAList getInstance() {
        if (null == _instance) {
            _instance = new RMAList();
        }
        return _instance;
    }

    public RMADetails[] getRMAList() {
        RMADetails[] RMADetails2 = new RMADetails[this._rmaList.size()];
        RMADetails[] baseList = this._rmaList.values().toArray(new RMADetails[this._rmaList.size()]);
        for (int i = 0; i < baseList.length; ++i) {
            RMADetails2[i] = baseList[i].copy();
        }
        return RMADetails2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchRMADetails(String searchString, long from, long to) {
        Object object = this._lock;
        synchronized (object) {
            this._searchString = searchString;
            this._searchFrom = from;
            this._searchTo = to;
        }
        this.newRMAAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRMAList(Integer[] statusFilters, Integer[] reasonFilters) {
        Object object = this._lock;
        synchronized (object) {
            int index;
            int i$;
            this._statusFilters.clear();
            this._reasonFilters.clear();
            Integer[] arr$ = statusFilters;
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                index = arr$[i$];
                this._statusFilters.put(index, index);
            }
            arr$ = reasonFilters;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                index = arr$[i$];
                this._reasonFilters.put(index, index);
            }
        }
        this.newRMAAvailable();
    }

    private void refreshRMAList(String searchString, HashMap<Integer, Integer> statusFilters, HashMap<Integer, Integer> reasonFilters, long searchFrom, long searchTo) {
        ResultSet rs;
        block7: {
            this._rmaList.clear();
            rs = PNPDatabaseManager.getInstance().getRMAList(searchString, statusFilters.values(), reasonFilters.values(), searchFrom, searchTo);
            try {
                if (null == rs) break block7;
                while (rs.next()) {
                    RMADetails rmaElement = new RMADetails();
                    if (!this._rmaList.containsKey(rs.getInt("RMADetails.RmaNumberID"))) {
                        rmaElement = new RMADetails();
                        try {
                            rmaElement.setRmaComments(rs.getString("RMADetails.RMAComments"));
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex, false);
                        }
                        rmaElement.setRmaDate(rs.getDate("RMADetails.RMADate"));
                        rmaElement.setCustomerUsername(rs.getString("RMADetails.CustomerUserName"));
                        rmaElement.setOrderDetailsID(rs.getInt("RMADetails.OrderDetailsID"));
                        rmaElement.setReplacementTracking(rs.getString("RMADetails.ReplacementTracking"));
                        rmaElement.setReturnTracking(rs.getString("RMADetails.ReturnTracking"));
                        rmaElement.setRmaNumberID(rs.getInt("RMADetails.RmaNumberID"));
                        rmaElement.setRmaReasonID(rs.getInt("RMADetails.RmaReasonID"));
                        rmaElement.setRmaStatusID(rs.getInt("RMADetails.RmaStatusID"));
                        this._rmaList.put(rmaElement.getRmaNumberID(), rmaElement);
                    }
                    OrderDetails orderDetailsElement = new OrderDetails();
                    orderDetailsElement.setItemID(rs.getString("OrderDetails.ItemID"));
                    Date date = rs.getDate("OrderDetails.ShipDate");
                    if (null != date) {
                        orderDetailsElement.setShipDate(date);
                    }
                    orderDetailsElement.setOrderDescription(rs.getString("OrderDetails.OrderDescription"));
                    rmaElement.setOrderDetails(orderDetailsElement);
                    Customer customer = new Customer();
                    customer.setCustomerEmail(rs.getString("Customers.CustomerEmail"));
                    rmaElement.setCustomer(customer);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.RMA_LIST_LISTENER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMADetails updateRMA(RMADetails rmaDetails) {
        Object object = this._lock;
        synchronized (object) {
            rmaDetails.setRmaNumberID(PNPDatabaseManager.getInstance().updateRMA(rmaDetails));
            if (this._statusFilters.containsKey(rmaDetails.getRmaStatusID()) || this._statusFilters.isEmpty()) {
                if (this._reasonFilters.containsKey(rmaDetails.getRmaReasonID()) || this._reasonFilters.isEmpty()) {
                    this._rmaList.put(rmaDetails.getRmaStatusID(), rmaDetails.copy());
                }
            } else {
                this._rmaList.remove(rmaDetails.getRmaStatusID());
            }
        }
        return rmaDetails;
    }

    public void deleteRMA(RMADetails rmaDetails) {
        PNPDatabaseManager.getInstance().deleteRma(rmaDetails);
        if (this._rmaList.containsKey(rmaDetails.getRmaNumberID())) {
            this._rmaList.remove(rmaDetails.getRmaNumberID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newRMAAvailable() {
        Object object = this._lock;
        synchronized (object) {
            this.refreshRMAList(this._searchString, this._statusFilters, this._reasonFilters, this._searchFrom, this._searchTo);
        }
    }
}

