/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.RMAReason;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class RMAReasonList {
    private static RMAReasonList _instance;
    private ArrayList<RMAReason> rmaReasonList = new ArrayList();
    private RMAReason _noReason;
    private RMAReason _changedMindReason;
    private RMAReason _defectiveReason;
    private RMAReason _wrongItemReason;
    private RMAReason _wrongSizeReason;

    private RMAReasonList() {
        ResultSet rs = PNPDatabaseManager.getInstance().getRMAReasonList();
        try {
            if (null != rs) {
                while (rs.next()) {
                    if (rs.getString("RMAReasonType").equals("")) {
                        this._noReason = new RMAReason(rs.getInt("RMAReasonID"), rs.getString("RMAReasonType"));
                        this.rmaReasonList.add(this._noReason);
                        continue;
                    }
                    if (rs.getString("RMAReasonType").equals("Changed Mind")) {
                        this._changedMindReason = new RMAReason(rs.getInt("RMAReasonID"), rs.getString("RMAReasonType"));
                        this.rmaReasonList.add(this._changedMindReason);
                        continue;
                    }
                    if (rs.getString("RMAReasonType").equals("Defective")) {
                        this._defectiveReason = new RMAReason(rs.getInt("RMAReasonID"), rs.getString("RMAReasonType"));
                        this.rmaReasonList.add(this._defectiveReason);
                        continue;
                    }
                    if (rs.getString("RMAReasonType").equals("Wrong Item")) {
                        this._wrongItemReason = new RMAReason(rs.getInt("RMAReasonID"), rs.getString("RMAReasonType"));
                        this.rmaReasonList.add(this._wrongItemReason);
                        continue;
                    }
                    if (!rs.getString("RMAReasonType").equals("Wrong Size")) continue;
                    this._wrongSizeReason = new RMAReason(rs.getInt("RMAReasonID"), rs.getString("RMAReasonType"));
                    this.rmaReasonList.add(this._wrongSizeReason);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
    }

    public static RMAReasonList getInstance() {
        if (null == _instance) {
            _instance = new RMAReasonList();
        }
        return _instance;
    }

    public ArrayList<RMAReason> getRMAReasonList() {
        return this.rmaReasonList;
    }

    public RMAReason getNoReason() {
        return this._noReason;
    }

    public void setNoReason(RMAReason _noReason) {
        this._noReason = _noReason;
    }

    public RMAReason getChangedMindReason() {
        return this._changedMindReason;
    }

    public RMAReason getDefectiveReason() {
        return this._defectiveReason;
    }

    public RMAReason getWrongItemReason() {
        return this._wrongItemReason;
    }

    public RMAReason getWrongSizeReason() {
        return this._wrongSizeReason;
    }

    public RMAReason getRMAReason(int rmaReasonID) {
        Iterator<RMAReason> iterator = this.rmaReasonList.iterator();
        boolean found = false;
        RMAReason status = null;
        while (iterator.hasNext() && !found) {
            status = iterator.next();
            if (status.getRmaReasonID() != rmaReasonID) continue;
            found = true;
        }
        return status;
    }
}

