/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.RMAStatus;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class RMAStatusList {
    private static RMAStatusList _instance;
    private ArrayList<RMAStatus> rmaStatusList = new ArrayList();
    private RMAStatus _newRMAStatus;
    private RMAStatus _exchangingRMAStatus;
    private RMAStatus _pendingResponseRMAStatus;
    private RMAStatus _refundedRMAStatus;
    private RMAStatus _reshippedRMAStatus;
    private RMAStatus _returningRMAStatus;
    private RMAStatus _returnLabelStatus;
    private RMAStatus _returnProcessedRMAStatus;

    private RMAStatusList() {
        ResultSet rs = PNPDatabaseManager.getInstance().getRMAStatusList();
        try {
            if (null != rs) {
                while (rs.next()) {
                    if (rs.getString("RMAStatusType").equals("New RMA")) {
                        this._newRMAStatus = new RMAStatus(rs.getInt("RMAStatusID"), rs.getString("RMAStatusType"));
                        this.rmaStatusList.add(this._newRMAStatus);
                        continue;
                    }
                    if (rs.getString("RMAStatusType").equals("Exchanging")) {
                        this._exchangingRMAStatus = new RMAStatus(rs.getInt("RMAStatusID"), rs.getString("RMAStatusType"));
                        this.rmaStatusList.add(this._exchangingRMAStatus);
                        continue;
                    }
                    if (rs.getString("RMAStatusType").equals("Pending Response")) {
                        this._pendingResponseRMAStatus = new RMAStatus(rs.getInt("RMAStatusID"), rs.getString("RMAStatusType"));
                        this.rmaStatusList.add(this._pendingResponseRMAStatus);
                        continue;
                    }
                    if (rs.getString("RMAStatusType").equals("Refunded")) {
                        this._refundedRMAStatus = new RMAStatus(rs.getInt("RMAStatusID"), rs.getString("RMAStatusType"));
                        this.rmaStatusList.add(this._refundedRMAStatus);
                        continue;
                    }
                    if (rs.getString("RMAStatusType").equals("Reshipped")) {
                        this._reshippedRMAStatus = new RMAStatus(rs.getInt("RMAStatusID"), rs.getString("RMAStatusType"));
                        this.rmaStatusList.add(this._reshippedRMAStatus);
                        continue;
                    }
                    if (rs.getString("RMAStatusType").equals("Returning")) {
                        this._returningRMAStatus = new RMAStatus(rs.getInt("RMAStatusID"), rs.getString("RMAStatusType"));
                        this.rmaStatusList.add(this._returningRMAStatus);
                        continue;
                    }
                    if (rs.getString("RMAStatusType").equals("Return Label Issued")) {
                        this._returnLabelStatus = new RMAStatus(rs.getInt("RMAStatusID"), rs.getString("RMAStatusType"));
                        this.rmaStatusList.add(this._returnLabelStatus);
                        continue;
                    }
                    if (!rs.getString("RMAStatusType").equals("Return Processed")) continue;
                    this._returnProcessedRMAStatus = new RMAStatus(rs.getInt("RMAStatusID"), rs.getString("RMAStatusType"));
                    this.rmaStatusList.add(this._returnProcessedRMAStatus);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
    }

    public static RMAStatusList getInstance() {
        if (null == _instance) {
            _instance = new RMAStatusList();
        }
        return _instance;
    }

    public ArrayList<RMAStatus> getRMAStatusList() {
        return this.rmaStatusList;
    }

    public RMAStatus getNewRmaStatus() {
        return this._newRMAStatus;
    }

    public RMAStatus getExchangingStatus() {
        return this._exchangingRMAStatus;
    }

    public RMAStatus getPendingResponseStatus() {
        return this._pendingResponseRMAStatus;
    }

    public RMAStatus getRefundedStatus() {
        return this._refundedRMAStatus;
    }

    public RMAStatus getReshippedStatus() {
        return this._reshippedRMAStatus;
    }

    public RMAStatus getReturningStatus() {
        return this._returningRMAStatus;
    }

    public RMAStatus getReturnLabelStatus() {
        return this._returnLabelStatus;
    }

    public RMAStatus getReturnProcessedStatus() {
        return this._returnProcessedRMAStatus;
    }

    public RMAStatus getRMAStatus(int rmaStatusID) {
        Iterator<RMAStatus> iterator = this.rmaStatusList.iterator();
        boolean found = false;
        RMAStatus status = null;
        while (iterator.hasNext() && !found) {
            status = iterator.next();
            if (status.getRmaStatusID() != rmaStatusID) continue;
            found = true;
        }
        return status;
    }
}

