/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.ArrayList;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.ShippingMethod;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class ShippingMethodList {
    private static ShippingMethodList _instance;
    private static final String STANDARD_METHOD = "Standard";
    private static final String EXPEDITED_METHOD = "Expedited";
    private static final String TWODAY_METHOD = "2-Day";
    private ArrayList<ShippingMethod> _shippingMethodList = new ArrayList();
    private ShippingMethod _standardMethod;
    private ShippingMethod _expeditedMethod;
    private ShippingMethod _2DayMethod;

    private ShippingMethodList() {
        ResultSet rs = PNPDatabaseManager.getInstance().getShippingMethodList();
        try {
            if (null != rs) {
                while (rs.next()) {
                    if (rs.getString("ShippingMethodName").equals(STANDARD_METHOD)) {
                        this._standardMethod = new ShippingMethod();
                        this._standardMethod.setDeliveryTimeMin(rs.getInt("DeliveryTimeMin"));
                        this._standardMethod.setDeliveryTimeMax(rs.getInt("DeliveryTimeMax"));
                        this._standardMethod.setShippingMethodName(rs.getString("ShippingMethodName"));
                        this._shippingMethodList.add(this._standardMethod);
                        continue;
                    }
                    if (rs.getString("ShippingMethodName").equals(EXPEDITED_METHOD)) {
                        this._expeditedMethod = new ShippingMethod();
                        this._expeditedMethod.setDeliveryTimeMin(rs.getInt("DeliveryTimeMin"));
                        this._expeditedMethod.setDeliveryTimeMax(rs.getInt("DeliveryTimeMax"));
                        this._expeditedMethod.setShippingMethodName(rs.getString("ShippingMethodName"));
                        this._shippingMethodList.add(this._expeditedMethod);
                        continue;
                    }
                    if (!rs.getString("ShippingMethodName").equals(TWODAY_METHOD)) continue;
                    this._2DayMethod = new ShippingMethod();
                    this._2DayMethod.setDeliveryTimeMin(rs.getInt("DeliveryTimeMin"));
                    this._2DayMethod.setDeliveryTimeMax(rs.getInt("DeliveryTimeMax"));
                    this._2DayMethod.setShippingMethodName(rs.getString("ShippingMethodName"));
                    this._shippingMethodList.add(this._2DayMethod);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
    }

    public static ShippingMethodList getInstance() {
        if (_instance == null) {
            _instance = new ShippingMethodList();
        }
        return _instance;
    }

    public ShippingMethod get2DayMethod() {
        return this._2DayMethod;
    }

    public ShippingMethod getExpeditedMethod() {
        return this._expeditedMethod;
    }

    public ArrayList<ShippingMethod> getShippingMethodList() {
        return this._shippingMethodList;
    }

    public ShippingMethod getStandardMethod() {
        return this._standardMethod;
    }
}

