/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.webservices.WebsiteCategories;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class WebsiteCategoriesList {
    private HashMap<Integer, WebsiteCategories> _websiteCategories = new HashMap();
    private static WebsiteCategoriesList _instance;

    private WebsiteCategoriesList() {
        this.refreshWebsiteCategoryList(false);
    }

    public static WebsiteCategoriesList getInstance() {
        if (null == _instance) {
            _instance = new WebsiteCategoriesList();
        }
        return _instance;
    }

    private void refreshWebsiteCategoryList(boolean notify) {
        this._websiteCategories.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getWebsiteCategories();
        try {
            if (null != rs) {
                while (rs.next()) {
                    WebsiteCategories element;
                    if (this._websiteCategories.containsKey(rs.getInt("WebsiteID"))) {
                        element = this._websiteCategories.get(rs.getInt("WebsiteID"));
                    } else {
                        element = new WebsiteCategories();
                        element.setWebsiteID(rs.getInt("WebsiteID"));
                        this._websiteCategories.put(element.getWebsiteID(), element);
                    }
                    element.addCategory(Integer.valueOf(rs.getInt("CategoryID")));
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        if (notify) {
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_CATEGORIES_LIST_LISTENER);
        }
    }

    public WebsiteCategories[] getWebsiteCategories() {
        return this._websiteCategories.values().toArray(new WebsiteCategories[0]);
    }

    public void setWebsiteCategories(WebsiteCategories websiteCategory) {
        PNPDatabaseManager.getInstance().updateWebsiteCategories(websiteCategory);
        this.refreshWebsiteCategoryList(true);
    }
}

