/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.InventoryElement;
import pnp.services.datatypes.Item;
import pnp.services.datatypes.webservices.WebsiteElement;
import pnp.services.datatypes.webservices.WebsiteProduct;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class WebsiteInventoryList {
    private HashMap<String, WebsiteProduct> _websiteProducts;
    private HashMap<String, WebsiteElement> _websiteElements = new HashMap();
    private HashMap<String, Item> _items;
    private HashMap<String, InventoryElement> _inventory;
    private static WebsiteInventoryList _instance;

    private WebsiteInventoryList() {
        this._websiteProducts = new HashMap();
        this._items = new HashMap();
        this._inventory = new HashMap();
        this.refreshItemList();
        this.refreshWebsiteList();
    }

    public static WebsiteInventoryList getInstance() {
        if (null == _instance) {
            _instance = new WebsiteInventoryList();
        }
        return _instance;
    }

    public void refreshWebsiteList() {
        ResultSet rs;
        block9: {
            this._websiteElements.clear();
            this._websiteProducts.clear();
            this.refreshInventoryList("");
            this.refreshItemList();
            rs = PNPDatabaseManager.getInstance().getWebsiteList();
            try {
                if (null == rs) break block9;
                while (rs.next()) {
                    WebsiteElement element = new WebsiteElement();
                    element.setItemID(rs.getString("ItemID"));
                    element.setOem(rs.getString("Oem"));
                    element.setPrice(rs.getFloat("Price"));
                    element.setPriceRetail(rs.getFloat("PriceRetail"));
                    try {
                        element.setBriefDescription(rs.getString("BriefDescription"));
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    try {
                        element.setDescription(rs.getString("Description"));
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    try {
                        element.setKeywords(rs.getString("Keywords"));
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    element.setThumbnail(rs.getString("Thumbnail"));
                    element.setPhoto1(rs.getString("Photo1"));
                    element.setPhoto2(rs.getString("Photo2"));
                    element.setPhoto3(rs.getString("Photo3"));
                    element.setCategoryID(rs.getInt("CategoryID"));
                    element.setEnabled(rs.getBoolean("Enabled"));
                    element.setFeatured(rs.getBoolean("Featured"));
                    element.setGender(rs.getString("Gender"));
                    element.setAgeGroup(rs.getString("AgeGroup"));
                    this._websiteElements.put(element.getItemID(), element);
                }
                this.assembleWebsiteProductList(true, false, false);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        DatabaseConnector.removeObject((ResultSet)rs);
    }

    private void assembleWebsiteProductList(boolean createNew, boolean searchString, boolean hideOOS) {
        WebsiteElement websiteElement;
        Item item;
        WebsiteProduct websiteProduct;
        int i;
        InventoryElement[] inventoryList = this._inventory.values().toArray(new InventoryElement[0]);
        for (i = 0; i < inventoryList.length; ++i) {
            if ((!hideOOS || inventoryList[i].getItemQuantity() <= 0) && hideOOS || !createNew && !this._websiteElements.containsKey(inventoryList[i].getItemID())) continue;
            websiteProduct = new WebsiteProduct();
            websiteProduct.setInventoryElement(inventoryList[i]);
            if (this._items.containsKey(inventoryList[i].getItemID())) {
                websiteProduct.setItem(this._items.get(inventoryList[i].getItemID()));
            } else {
                item = new Item();
                item.setItemID(inventoryList[i].getItemID());
                item.setItemWeight(inventoryList[i].getItem().getItemWeight());
                websiteProduct.setItem(this._items.get(inventoryList[i].getItemID()));
            }
            if (this._websiteElements.containsKey(inventoryList[i].getItemID())) {
                websiteProduct.setWebsiteElement(this._websiteElements.get(inventoryList[i].getItemID()));
            } else {
                websiteElement = new WebsiteElement();
                websiteElement.setItemID(inventoryList[i].getItemID());
                websiteProduct.setWebsiteElement(websiteElement);
            }
            this._websiteProducts.put(inventoryList[i].getItemID(), websiteProduct);
        }
        if (searchString) {
            this.refreshInventoryList("");
            inventoryList = this._inventory.values().toArray(new InventoryElement[0]);
            for (i = 0; i < inventoryList.length; ++i) {
                if ((!hideOOS || inventoryList[i].getItemQuantity() <= 0) && hideOOS || !this._websiteElements.containsKey(inventoryList[i].getItemID())) continue;
                websiteProduct = new WebsiteProduct();
                websiteProduct.setInventoryElement(inventoryList[i]);
                if (this._items.containsKey(inventoryList[i].getItemID())) {
                    websiteProduct.setItem(this._items.get(inventoryList[i].getItemID()));
                } else {
                    item = new Item();
                    item.setItemID(inventoryList[i].getItemID());
                    item.setItemWeight(inventoryList[i].getItem().getItemWeight());
                    websiteProduct.setItem(this._items.get(inventoryList[i].getItemID()));
                }
                if (this._websiteElements.containsKey(inventoryList[i].getItemID())) {
                    websiteProduct.setWebsiteElement(this._websiteElements.get(inventoryList[i].getItemID()));
                } else {
                    websiteElement = new WebsiteElement();
                    websiteElement.setItemID(inventoryList[i].getItemID());
                    websiteProduct.setWebsiteElement(websiteElement);
                }
                this._websiteProducts.put(inventoryList[i].getItemID(), websiteProduct);
            }
        }
    }

    private void refreshItemList() {
        this._items.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getItemList();
        try {
            if (null != rs) {
                while (rs.next()) {
                    Item element = new Item();
                    element.setDistributorID(rs.getInt("DistributorID"));
                    element.setDropShipped(rs.getBoolean("DropShipped"));
                    element.setDistributorProductID(rs.getString("DistributorProductID"));
                    element.setItemDescription(rs.getString("ItemDescription"));
                    element.setItemID(rs.getString("ItemID"));
                    element.setItemName(rs.getString("ItemName"));
                    element.setItemWeight(rs.getFloat("ItemWeight"));
                    element.setPackedWeight(rs.getFloat("PackedWeight"));
                    element.setLocation(rs.getString("Location"));
                    this._items.put(element.getItemID(), element);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
    }

    private void refreshInventoryList(String searchString) {
        this._inventory.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getInventoryList(searchString, false, false, true, false, null, false);
        try {
            if (null != rs) {
                while (rs.next()) {
                    InventoryElement element;
                    if (this._inventory.containsKey(rs.getString("ItemID"))) {
                        element = this._inventory.get(rs.getString("ItemID"));
                        if (element.getItemQuantity() <= 0) {
                            element.setItemQuantity(rs.getInt("ItemQuantity") + element.getItemQuantity());
                            element.setItemCost(rs.getFloat("ItemCost"));
                            if (element.getItemQuantity() > 0) {
                                element.setOosItem(true);
                                continue;
                            }
                            element.setOosItem(false);
                            continue;
                        }
                        element.setItemQuantity(element.getItemQuantity() + rs.getInt("ItemQuantity"));
                        element.setItemCost((element.getItemCost() * (float)(element.getItemQuantity() - rs.getInt("ItemQuantity")) + (float)rs.getInt("ItemQuantity") * rs.getFloat("ItemCost")) / (float)element.getItemQuantity());
                        if (element.getItemQuantity() > 0) {
                            element.setOosItem(true);
                            continue;
                        }
                        element.setOosItem(false);
                        continue;
                    }
                    element = new InventoryElement();
                    element.setInventoryID(rs.getInt("InventoryID"));
                    element.setItemQuantity(rs.getInt("ItemQuantity"));
                    element.setItemCost(rs.getFloat("ItemCost"));
                    element.setItemID(rs.getString("ItemID"));
                    if (element.getItemQuantity() > 0) {
                        element.setOosItem(true);
                    } else {
                        element.setOosItem(false);
                    }
                    element.setStockDate(rs.getDate("StockDate"));
                    this._inventory.put(element.getItemID(), element);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
    }

    public HashMap<String, WebsiteProduct> getWebsiteList() {
        if (this._websiteProducts == null) {
            this._websiteProducts = new HashMap();
        }
        return this._websiteProducts;
    }

    public WebsiteElement getWebsiteElement(String itemID) {
        return this._websiteElements.get(itemID.toLowerCase());
    }

    public void setWebsiteElement(WebsiteElement websiteElement) {
        PNPDatabaseManager.getInstance().updateWebsiteElement(websiteElement);
        if (this._websiteProducts != null && this._websiteProducts.containsKey(websiteElement.getItemID().toLowerCase())) {
            this._websiteElements.put(websiteElement.getItemID().toLowerCase(), websiteElement);
            this._websiteProducts.get(websiteElement.getItemID().toLowerCase()).setWebsiteElement(websiteElement);
        }
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_LIST_LISTENER);
    }

    public Item getItem(String itemID) {
        return this._items.get(itemID.toLowerCase());
    }

    public void setItem(Item item) {
        PNPDatabaseManager.getInstance().updateItem(item);
        this._items.put(item.getItemID().toLowerCase(), item);
    }

    public void refreshWebsiteList(String searchString, boolean enabled, boolean hideOOS) {
        ResultSet rs;
        block11: {
            this._websiteElements.clear();
            this._websiteProducts.clear();
            this.refreshInventoryList(searchString);
            this.refreshItemList();
            rs = PNPDatabaseManager.getInstance().getWebsiteList(searchString, enabled);
            try {
                if (null == rs) break block11;
                while (rs.next()) {
                    WebsiteElement element = new WebsiteElement();
                    element.setItemID(rs.getString("ItemID"));
                    element.setOem(rs.getString("Oem"));
                    element.setPrice(rs.getFloat("Price"));
                    element.setPriceRetail(rs.getFloat("PriceRetail"));
                    try {
                        element.setBriefDescription(rs.getString("BriefDescription"));
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    try {
                        element.setDescription(rs.getString("Description"));
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    try {
                        element.setKeywords(rs.getString("Keywords"));
                    }
                    catch (Exception ex) {
                        ErrorsUtil.getInstance().logError(ex, false);
                    }
                    element.setThumbnail(rs.getString("Thumbnail"));
                    element.setPhoto1(rs.getString("Photo1"));
                    element.setPhoto2(rs.getString("Photo2"));
                    element.setPhoto3(rs.getString("Photo3"));
                    element.setCategoryID(rs.getInt("CategoryID"));
                    element.setEnabled(rs.getBoolean("Enabled"));
                    element.setFeatured(rs.getBoolean("Featured"));
                    this._websiteElements.put(element.getItemID(), element);
                }
                if (!enabled) {
                    this.assembleWebsiteProductList(true, true, hideOOS);
                } else {
                    this.assembleWebsiteProductList(false, true, hideOOS);
                }
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_ITEM_LIST_LISTENER);
    }
}

