/*
 * Decompiled with CFR 0.152.
 */
package pnp.comms.db.lists;

import java.sql.ResultSet;
import java.util.HashMap;
import pnp.comms.db.PNPDatabaseManager;
import pnp.services.datatypes.webservices.Website;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.DatabaseConnector;
import pnp.services.util.ErrorsUtil;

public class WebsiteList {
    private HashMap<Integer, Website> _websites = new HashMap();
    private static WebsiteList _instance;

    private WebsiteList() {
        this.refreshWebsiteList(false);
    }

    public static WebsiteList getInstance() {
        if (null == _instance) {
            _instance = new WebsiteList();
        }
        return _instance;
    }

    public void refreshWebsiteList(boolean notify) {
        this._websites.clear();
        ResultSet rs = PNPDatabaseManager.getInstance().getWebsites();
        try {
            if (null != rs) {
                while (rs.next()) {
                    Website element = new Website();
                    element.setWebsiteID(rs.getInt("WebsiteID"));
                    element.setWebsiteName(rs.getString("WebsiteName"));
                    element.setWebsiteURI(rs.getString("WebsiteURI"));
                    element.setWebsiteActive(rs.getBoolean("WebsiteActive"));
                    element.setLastUpdate(rs.getLong("LastUpdate"));
                    this._websites.put(element.getWebsiteID(), element);
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        DatabaseConnector.removeObject((ResultSet)rs);
        if (notify) {
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.WEBSITE_LIST_LISTENER);
        }
    }

    public Website[] getWebsites() {
        return this._websites.values().toArray(new Website[0]);
    }

    public void updateWebsite(Website website) {
        PNPDatabaseManager.getInstance().updateWebsite(website);
        this.refreshWebsiteList(true);
    }
}

