/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.attributes;

import com.ebay.sdk.attributes.AttrInfo;
import com.ebay.sdk.attributes.model.Attribute;
import com.ebay.sdk.attributes.model.AttributeSet;
import com.ebay.sdk.attributes.model.Value;
import com.ebay.sdk.attributes.model.YMD;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

abstract class AttrParamParser {
    public static final String ATTR = "attr";
    public static final String ATTR_D = "attr_d";
    public static final String ATTR_T = "attr_t";
    public static final String US = "_";
    public static final String USC = "_c";
    public static final String USD = "_d";
    public static final String USM = "_m";
    public static final String UST = "_t";
    public static final String USY = "_y";
    public static final String SEP = ",";
    public static String SEPS = ",";

    AttrParamParser() {
    }

    public static AttributeSet parse(int vcsid, Map request) {
        Hashtable<String, Object> htAttr = new Hashtable<String, Object>();
        String csidStr = new Integer(vcsid).toString();
        Object[] keys = request.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            int index;
            String key = (String)keys[i];
            if (!key.startsWith(ATTR + csidStr) && !key.startsWith(ATTR_D + csidStr) && !key.startsWith(ATTR_T + csidStr)) continue;
            int type = 0;
            String[] val = (String[])request.get(key);
            String skey = key.substring(ATTR.length());
            if (skey.startsWith(USD)) {
                index = skey.lastIndexOf(US);
                String ekey = skey.substring(index);
                skey = skey.substring(0, index);
                skey = skey.substring(USD.length());
                if (USC.equals(ekey)) {
                    type = 11;
                } else if (USD.equals(ekey)) {
                    type = 101;
                } else if (USM.equals(ekey)) {
                    type = 102;
                } else if (USY.equals(ekey)) {
                    type = 103;
                }
            } else if (skey.startsWith(UST)) {
                skey = skey.substring(UST.length());
                type = 11;
            } else {
                type = val.length > 1 ? 1 : 0;
            }
            AttrInfo info = new AttrInfo();
            info.typeId = type;
            index = skey.indexOf(US);
            info.attrId = skey.substring(index + 1);
            info.csid = skey.substring(0, index);
            info.val = (String[])request.get(key);
            skey = info.attrId;
            Object obj = htAttr.get(info.attrId);
            if (obj != null) {
                if (obj instanceof ArrayList) {
                    ((ArrayList)obj).add(info);
                    continue;
                }
                ArrayList<Object> al = new ArrayList<Object>();
                al.add(obj);
                al.add(info);
                htAttr.remove(info.attrId);
                htAttr.put(skey, al);
                continue;
            }
            htAttr.put(info.attrId, info);
        }
        return AttrParamParser.compile(htAttr, vcsid);
    }

    static void ArrayList_removeRange(ArrayList al, int index, int count) {
        for (int i = 0; i < count; ++i) {
            al.remove(index + i);
        }
    }

    private static AttributeSet compile(Hashtable ht, int vcsid) {
        AttributeSet attrSet = new AttributeSet();
        attrSet.setAttributeSetID(vcsid);
        int cnt = ht.size();
        Enumeration iter = ht.keys();
        Attribute attr = null;
        while (iter.hasMoreElements()) {
            AttrInfo info;
            String key = iter.nextElement().toString();
            Object val = ht.get(key);
            if (val instanceof ArrayList) {
                ArrayList al = (ArrayList)val;
                cnt = al.size();
                if (cnt == 2) {
                    AttrInfo info0 = (AttrInfo)al.get(0);
                    AttrInfo info1 = (AttrInfo)al.get(1);
                    if (info0.typeId == 0) {
                        attr = AttrParamParser.ExtractAttr2(info0, info1);
                        attrSet.add(attr);
                        continue;
                    }
                    if (info1.typeId != 0) continue;
                    attr = AttrParamParser.ExtractAttr2(info1, info0);
                    attrSet.add(attr);
                    continue;
                }
                if (cnt != 3) continue;
                YMD ymd = new YMD(null, null, null);
                block6: for (int i = 0; i < cnt; ++i) {
                    info = (AttrInfo)al.get(i);
                    switch (info.typeId) {
                        case 101: {
                            ymd.day = info.val[0];
                            continue block6;
                        }
                        case 102: {
                            ymd.month = info.val[0];
                            continue block6;
                        }
                        case 103: {
                            ymd.year = info.val[0];
                        }
                    }
                }
                YMD.FixYMD(ymd);
                if (ymd.day == null || ymd.month == null || ymd.year == null) continue;
                info = (AttrInfo)al.get(0);
                AttrParamParser.ArrayList_removeRange(al, 0, cnt);
                info.typeId = 12;
                info.val = new String[]{ymd.year + ymd.month + ymd.day};
                al.add(info);
                attr = AttrParamParser.ExtractAttr(info);
                ((Value)attr.getValue()[0]).setValueID(new Integer(-5));
                attrSet.add(attr);
                continue;
            }
            info = (AttrInfo)val;
            if (info.typeId == 103) {
                info.typeId = 103;
                info.val = info.val;
                attr = AttrParamParser.ExtractAttr(info);
                ((Value)attr.getValue()[0]).setValueID(new Integer(-3));
                attrSet.add(attr);
                continue;
            }
            attr = AttrParamParser.ExtractAttr(info);
            if (attr.getType() == 11) {
                ((Value)attr.getValue()[0]).setValueID(new Integer(-3));
            }
            attrSet.add(attr);
        }
        return attrSet;
    }

    private static int AttrToValType(int attrType) {
        if (attrType == 0 || attrType == 1) {
            return 0;
        }
        return 1;
    }

    private static Attribute ExtractAttr(AttrInfo info) {
        Value val = null;
        Attribute attr = new Attribute();
        attr.setAttributeID(Integer.parseInt(info.attrId));
        attr.setType(info.typeId);
        int valType = AttrParamParser.AttrToValType(info.typeId);
        if (info.typeId == 0) {
            val = new Value(valType);
            val.setValueID(new Integer(info.val[0]));
            attr.addValue(val);
        } else if (info.typeId == 1) {
            for (int i = 0; i < info.val.length; ++i) {
                val = new Value(valType);
                val.setValueID(new Integer(info.val[i]));
                attr.addValue(val);
            }
        } else {
            val = new Value(valType);
            val.setValueLiteral(info.val[0]);
            attr.addValue(val);
        }
        return attr;
    }

    private static Attribute ExtractAttr2(AttrInfo info1, AttrInfo info2) {
        Attribute attr = new Attribute();
        attr.setAttributeID(Integer.parseInt(info1.attrId));
        attr.setType(info1.typeId);
        Value val = new Value();
        val.setValueID(new Integer(info1.val[0]));
        val.setValueLiteral(info2.val[0]);
        attr.addValue(val);
        return attr;
    }

    private static Attribute ExtractAttr(AttrInfo[] infos) {
        Value val = null;
        Attribute attr = new Attribute();
        attr.setAttributeID(Integer.parseInt(infos[0].attrId));
        for (AttrInfo info : infos) {
            if (info.typeId == 0) {
                val = new Value();
                val.setValueID(new Integer(info.val[0]));
                attr.addValue(val);
                continue;
            }
            if (info.typeId == 1) {
                for (int j = 0; j < info.val.length; ++j) {
                    val = new Value();
                    val.setValueID(new Integer(info.val[j]));
                    attr.addValue(val);
                }
                continue;
            }
            val = new Value();
            val.setValueLiteral(info.val[0]);
            attr.addValue(val);
        }
        return attr;
    }
}

