/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.attributes;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.attributes.model.AttributeSet;
import com.ebay.sdk.attributes.model.IAttributesXmlProvider;
import com.ebay.sdk.call.GetAttributesCSCall;
import com.ebay.sdk.call.GetProductSellingPagesCall;
import com.ebay.sdk.util.XmlUtil;
import com.ebay.soap.eBLBaseComponents.CharacteristicsSetType;
import com.ebay.soap.eBLBaseComponents.DetailLevelCodeType;
import com.ebay.soap.eBLBaseComponents.ProductType;
import com.ebay.soap.eBLBaseComponents.ProductUseCaseCodeType;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AttributesXmlDownloader
implements IAttributesXmlProvider {
    private Document csXml;
    private ApiContext apiContext;
    private String currentVersion;
    private String ROOT_DIR;
    private String ATTR_XML_FILE_NAME_PREFIX;
    private String ATTR_XML_FILE_NAME;
    private static final String ATTR_XML_FILE_EXTENSION = "attrcs";

    public AttributesXmlDownloader(ApiContext apiContext) throws ApiException, SdkException, Exception {
        this.apiContext = apiContext;
    }

    private void init(AttributeSet[] asList) throws ApiException, SdkException, Exception {
        if (this.currentVersion == null || this.currentVersion.length() == 0) {
            this.currentVersion = this.getCurrentAttributeSystemVersion();
        }
        this.ROOT_DIR = new File(".").getCanonicalPath();
        File dir = new File(this.ROOT_DIR);
        String[] dataFiles = this.getDataFiles(dir);
        boolean foundVersion = false;
        boolean foundAllVersion = false;
        String site = this.apiContext.getSite().toString();
        String fileNamePrefix = site + "." + this.ATTR_XML_FILE_NAME_PREFIX + "." + this.currentVersion;
        if (dataFiles != null) {
            foundVersion = this.foundVersion(dataFiles, fileNamePrefix);
            if (!foundVersion) {
                foundAllVersion = this.foundVersion(dataFiles, site + "." + "ALL" + "." + this.currentVersion);
            }
            if (foundAllVersion) {
                fileNamePrefix = site + "." + "ALL" + "." + this.currentVersion;
            }
        }
        this.ATTR_XML_FILE_NAME = this.ROOT_DIR + "/" + fileNamePrefix + "." + ATTR_XML_FILE_EXTENSION;
        if (foundVersion || foundAllVersion) {
            try {
                File csFile = new File(this.ATTR_XML_FILE_NAME);
                this.csXml = XmlUtil.createDom((File)csFile);
            }
            catch (IOException ioe) {
                throw new SdkException("Error processing file: " + this.ATTR_XML_FILE_NAME + " : " + ioe.getMessage());
            }
            catch (SAXException se) {
                throw new SdkException("Error processing file: " + this.ATTR_XML_FILE_NAME + " : " + se.getMessage());
            }
            catch (ParserConfigurationException pce) {
                throw new SdkException("Error processing file: " + this.ATTR_XML_FILE_NAME + " : " + pce.getMessage());
            }
        } else {
            int[] attrSetIds = null;
            if (asList != null) {
                attrSetIds = new int[asList.length];
                for (int i = 0; i < asList.length; ++i) {
                    attrSetIds[i] = asList[i].getAttributeSetID();
                }
            }
            this.csXml = this.downloadXml(attrSetIds);
            this.writeXmlFile(this.csXml, this.ATTR_XML_FILE_NAME);
        }
    }

    private boolean foundVersion(String[] dataFiles, String fileNamePrefix) {
        for (int i = 0; i < dataFiles.length; ++i) {
            String fileName = dataFiles[i];
            if (!fileName.startsWith(fileNamePrefix)) continue;
            return true;
        }
        return false;
    }

    private void writeXmlFile(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    private boolean validateCurrentVersion() throws ApiException, SdkException, Exception {
        String currentSystemVersion = this.getCurrentAttributeSystemVersion();
        if (this.currentVersion == null) {
            this.currentVersion = currentSystemVersion;
            return false;
        }
        return this.currentVersion.equals(currentSystemVersion);
    }

    private String createXmlFilePrefix(AttributeSet[] asList) {
        if (asList == null) {
            return "ALL";
        }
        HashSet<Integer> attrListSet = new HashSet<Integer>();
        for (int i = 0; i < asList.length; ++i) {
            attrListSet.add(new Integer(asList[i].getAttributeSetID()));
        }
        return String.valueOf(((Object)attrListSet).hashCode());
    }

    public synchronized String getMultipleCSXmlText(AttributeSet[] asList) throws SdkException, Exception {
        Document xmlDoc = this.getMultipleCSXml(asList);
        return XmlUtil.getXmlStringFromDom((Document)xmlDoc);
    }

    public synchronized Document getMultipleCSXml(AttributeSet[] asList) throws SdkException, Exception {
        boolean validVersion = this.validateCurrentVersion();
        if (validVersion) {
            String fileNamePrefix;
            boolean isAllAttributesFile;
            boolean bl = isAllAttributesFile = this.ATTR_XML_FILE_NAME_PREFIX != null && this.ATTR_XML_FILE_NAME_PREFIX.indexOf(".ALL.") != -1;
            if (!isAllAttributesFile && !(fileNamePrefix = this.createXmlFilePrefix(asList)).equals(this.ATTR_XML_FILE_NAME_PREFIX)) {
                this.ATTR_XML_FILE_NAME_PREFIX = fileNamePrefix;
                this.init(asList);
            }
        } else {
            this.ATTR_XML_FILE_NAME_PREFIX = this.createXmlFilePrefix(asList);
            this.init(asList);
        }
        if (this.csXml == null) {
            return null;
        }
        Document doc = null;
        ArrayList<AttributeSet> asListWithProdIds = new ArrayList<AttributeSet>();
        ArrayList<AttributeSet> asListNoProdIds = new ArrayList<AttributeSet>();
        for (int i = 0; i < asList.length; ++i) {
            AttributeSet ast = asList[i];
            if (ast.getProductID() != null) {
                asListWithProdIds.add(ast);
                continue;
            }
            asListNoProdIds.add(ast);
        }
        AttributeSet[] asArrayWithProdIds = new AttributeSet[asListWithProdIds.size()];
        for (int i = 0; i < asArrayWithProdIds.length; ++i) {
            asArrayWithProdIds[i] = (AttributeSet)((Object)asListWithProdIds.get(i));
        }
        AttributeSet[] asArrayNoProdIds = new AttributeSet[asListNoProdIds.size()];
        for (int i = 0; i < asArrayNoProdIds.length; ++i) {
            asArrayNoProdIds[i] = (AttributeSet)((Object)asListNoProdIds.get(i));
        }
        if (asArrayWithProdIds.length != 0) {
            GetProductSellingPagesCall psp = new GetProductSellingPagesCall(this.apiContext);
            psp.setDetailLevel(new DetailLevelCodeType[]{DetailLevelCodeType.RETURN_ALL});
            ProductType[] products = new ProductType[asArrayWithProdIds.length];
            int[] csidArray = new int[asArrayWithProdIds.length];
            for (int i = 0; i < asArrayWithProdIds.length; ++i) {
                ProductType prod = new ProductType();
                prod.setProductID(asArrayWithProdIds[i].getProductID());
                CharacteristicsSetType cs = new CharacteristicsSetType();
                cs.setAttributeSetID(new Integer(asArrayWithProdIds[i].getAttributeSetID()));
                prod.setCharacteristicsSet(cs);
                products[i] = prod;
                csidArray[i] = asArrayWithProdIds[i].getAttributeSetID();
            }
            psp.setProducts(products);
            psp.setUseCase(ProductUseCaseCodeType.ADD_ITEM);
            String spText = psp.getProductSellingPages();
            Document rawDoc = XmlUtil.createDom((String)spText);
            doc = GetAttributesCSCall.extractMultiCSFromXml((Document)rawDoc, (int[])csidArray, (boolean)true, (String)"/Products/Product", (Document)doc);
            String xmlBefore = XmlUtil.getXmlStringFromDom((Document)doc);
            String xmlPatched = GetAttributesCSCall.fixAttributesXml((String)xmlBefore, (String)GetAttributesCSCall.getDefaultStyleXsl());
            doc = XmlUtil.createDom((String)xmlPatched);
        }
        if (asArrayNoProdIds.length != 0) {
            int[] csidArray = new int[asArrayNoProdIds.length];
            for (int i = 0; i < asArrayNoProdIds.length; ++i) {
                csidArray[i] = asArrayNoProdIds[i].getAttributeSetID();
            }
            Document rawDoc = this.csXml;
            doc = GetAttributesCSCall.extractMultiCSFromXml((Document)rawDoc, (int[])csidArray, (boolean)true, (String)"/eBay", doc);
        }
        return doc;
    }

    private String[] getDataFiles(File dir) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                String site = AttributesXmlDownloader.this.apiContext.getSite().toString();
                boolean acceptIt = (name.startsWith(site + "." + AttributesXmlDownloader.this.ATTR_XML_FILE_NAME_PREFIX) || name.startsWith(site + "." + "ALL")) && name.endsWith(AttributesXmlDownloader.ATTR_XML_FILE_EXTENSION);
                return acceptIt;
            }
        };
        String[] files = dir.list(filter);
        return files;
    }

    private String getCurrentAttributeSystemVersion() throws ApiException, SdkException, Exception {
        GetAttributesCSCall api = new GetAttributesCSCall(this.apiContext);
        api.addDetailLevel(DetailLevelCodeType.RETURN_SUMMARY);
        api.getAttributesCS();
        return api.getReturnedattributeSystemVersion();
    }

    public Document downloadXml() throws ApiException, SdkException, Exception {
        return this.downloadXml((int[])null);
    }

    public Document downloadXml(int[] attrSetIds) throws ApiException, SdkException, Exception {
        GetAttributesCSCall api = new GetAttributesCSCall(this.apiContext);
        api.addDetailLevel(DetailLevelCodeType.RETURN_ALL);
        if (attrSetIds != null) {
            api.setAttributeSetIDs(attrSetIds);
        }
        String xmlText = api.getAttributesCS();
        api.setIncludeCategoryMappingDetails(new Boolean(true));
        this.csXml = XmlUtil.createDom((String)xmlText);
        return this.csXml;
    }

    public Document downloadXml(AttributeSet[] attrSets) throws ApiException, SdkException, Exception {
        if (attrSets == null) {
            return this.downloadXml();
        }
        int[] attrSetIds = new int[attrSets.length];
        for (int i = 0; i < attrSets.length; ++i) {
            attrSetIds[i] = attrSets[i].getAttributeSetID();
        }
        return this.downloadXml(attrSetIds);
    }
}

