/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.attributes;

import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.attributes.model.ICategoryCSProvider;
import com.ebay.sdk.call.GetCategory2CSCall;
import com.ebay.soap.eBLBaseComponents.CategoryArrayType;
import com.ebay.soap.eBLBaseComponents.CategoryType;
import com.ebay.soap.eBLBaseComponents.CharacteristicsSetType;
import com.ebay.soap.eBLBaseComponents.DetailLevelCodeType;
import com.ebay.soap.eBLBaseComponents.GetCategory2CSResponseType;
import com.ebay.soap.eBLBaseComponents.SiteWideCharacteristicsType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CategoryCSDownloader
implements ICategoryCSProvider {
    private ApiContext apiContext;
    private String currentVersion;
    private String ROOT_DIR;
    private String CATCS_FILE_NAME;
    private static final String CATCS_FILE_EXTENSION = "catcs";
    private String CATCS_FILE_NAME_PREFIX;
    private GetCategory2CSResponseType resp;
    private CategoryType[] cats;
    private SiteWideCharacteristicsType[] siteWideCharacteristicSets;

    public CategoryCSDownloader(ApiContext apiContext) throws ApiException, SdkException, Exception {
        this.apiContext = apiContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(String catId) throws ApiException, SdkException, Exception {
        if (this.currentVersion == null || this.currentVersion.length() == 0) {
            this.currentVersion = this.getCurrentAttributeSystemVersion();
        }
        if (catId != null && catId.length() == 0) {
            catId = null;
        }
        String site = this.apiContext.getSite().toString();
        this.CATCS_FILE_NAME_PREFIX = catId == null ? "ALL" : catId;
        this.ROOT_DIR = new File(".").getCanonicalPath();
        File dir = new File(this.ROOT_DIR);
        String[] dataFiles = this.getDataFiles(dir);
        boolean foundVersion = false;
        boolean foundAllVersion = false;
        String fileNamePrefix = site + "." + this.CATCS_FILE_NAME_PREFIX + "." + this.currentVersion;
        if (dataFiles != null) {
            foundVersion = this.foundVersion(dataFiles, fileNamePrefix);
            if (!foundVersion) {
                foundAllVersion = this.foundVersion(dataFiles, site + "." + "ALL" + "." + this.currentVersion);
            }
            if (foundAllVersion) {
                fileNamePrefix = site + "." + "ALL" + "." + this.currentVersion;
            }
        }
        this.CATCS_FILE_NAME = this.ROOT_DIR + "/" + fileNamePrefix + "." + CATCS_FILE_EXTENSION;
        if (foundVersion || foundAllVersion) {
            try {
                Object obj = this.readObjectFromDisk();
                this.resp = (GetCategory2CSResponseType)obj;
                if (this.resp == null) return;
                CategoryArrayType mappedArray = this.resp.getMappedCategoryArray();
                if (mappedArray != null) {
                    this.cats = mappedArray.getCategory();
                }
                this.siteWideCharacteristicSets = this.resp.getSiteWideCharacteristicSets();
                return;
            }
            catch (IOException ioe) {
                throw new SdkException("Error processing file: " + this.CATCS_FILE_NAME + " : " + ioe.getMessage());
            }
            catch (ClassNotFoundException cnfe) {
                throw new SdkException("Error processing file: " + this.CATCS_FILE_NAME + " : " + cnfe.getMessage());
            }
            catch (ClassCastException cce) {
                throw new SdkException("Error processing file: " + this.CATCS_FILE_NAME + " : " + cce.getMessage());
            }
        } else {
            this.downloadCategoryCS(catId);
            this.writeObjectToDisk(this.resp);
        }
    }

    private boolean foundVersion(String[] dataFiles, String fileNamePrefix) {
        for (int i = 0; i < dataFiles.length; ++i) {
            String fileName = dataFiles[i];
            if (!fileName.startsWith(fileNamePrefix)) continue;
            return true;
        }
        return false;
    }

    private String[] getDataFiles(File dir) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                String site = CategoryCSDownloader.this.apiContext.getSite().toString();
                return name.startsWith(site + "." + CategoryCSDownloader.this.CATCS_FILE_NAME_PREFIX) || name.startsWith(site + "." + "ALL") && name.endsWith(CategoryCSDownloader.CATCS_FILE_EXTENSION);
            }
        };
        String[] files = dir.list(filter);
        return files;
    }

    private String getCurrentAttributeSystemVersion() throws ApiException, SdkException, Exception {
        GetCategory2CSCall api = new GetCategory2CSCall(this.apiContext);
        api.addDetailLevel(DetailLevelCodeType.RETURN_SUMMARY);
        api.getCategory2CS();
        return api.getReturnedAttributeSystemVersion();
    }

    private boolean validate() throws ApiException, SdkException, Exception {
        String currentSystemVersion = this.getCurrentAttributeSystemVersion();
        if (this.currentVersion == null) {
            this.currentVersion = currentSystemVersion;
            return false;
        }
        return this.currentVersion.equals(currentSystemVersion);
    }

    public CategoryType[] getCategoriesCS() throws ApiException, SdkException, Exception {
        return this.getCategoriesCS(null);
    }

    public CategoryType[] getCategoriesCS(String catId) throws ApiException, SdkException, Exception {
        if (!this.validate()) {
            this.init(catId);
        }
        if (this.resp != null) {
            this.cats = this.resp.getMappedCategoryArray() == null ? new CategoryType[0] : this.resp.getMappedCategoryArray().getCategory();
        }
        return this.cats;
    }

    public int getVCSId(int categoryId) throws ApiException, SdkException, Exception {
        int[] vcsIds = this.getVCSIdArray(categoryId);
        return vcsIds[0];
    }

    public int[] getVCSIdArray(int categoryId) throws ApiException, SdkException, Exception {
        Map vcsIdMap = this.getVCSIdMap(categoryId);
        CharacteristicsSetType[] sets = (CharacteristicsSetType[])vcsIdMap.get(Integer.valueOf(String.valueOf(categoryId)));
        int setsLength = sets == null ? 1 : sets.length;
        int[] vcsIds = new int[setsLength];
        if (sets == null) {
            vcsIds[0] = 0;
        } else {
            for (int i = 0; i < setsLength; ++i) {
                vcsIds[i] = sets[i].getAttributeSetID();
            }
        }
        return vcsIds;
    }

    public Map getVCSIdMap(int categoryId) throws ApiException, SdkException, Exception {
        HashMap<Integer, Object> vcsIdMap = new HashMap<Integer, Object>(1);
        if (!this.validate()) {
            this.init(String.valueOf(categoryId));
        }
        if (this.cats == null || this.cats.length == 0) {
            vcsIdMap.put(Integer.valueOf("-1"), Integer.valueOf("-1"));
            return vcsIdMap;
        }
        for (int i = 0; i < this.cats.length; ++i) {
            CategoryType cat = this.cats[i];
            CharacteristicsSetType[] sets = cat.getCharacteristicsSets();
            if (sets == null || sets.length <= 0) continue;
            vcsIdMap.put(Integer.valueOf(cat.getCategoryID()), sets);
        }
        return vcsIdMap;
    }

    private void writeObjectToDisk(Object obj) throws IOException {
        FileOutputStream f_out = new FileOutputStream(this.CATCS_FILE_NAME);
        ObjectOutputStream obj_out = new ObjectOutputStream(f_out);
        obj_out.writeObject(obj);
    }

    private Object readObjectFromDisk() throws IOException, ClassNotFoundException {
        FileInputStream f_in = new FileInputStream(this.CATCS_FILE_NAME);
        ObjectInputStream obj_in = new ObjectInputStream(f_in);
        return obj_in.readObject();
    }

    public GetCategory2CSResponseType downloadCategoryCS(ApiContext asn, String catId) throws ApiException, SdkException, Exception {
        this.apiContext = asn;
        GetCategory2CSCall api = new GetCategory2CSCall(asn);
        api.setDetailLevel(new DetailLevelCodeType[]{DetailLevelCodeType.RETURN_ALL});
        if (catId != null) {
            api.setCategoryID(catId);
        }
        this.cats = api.getCategory2CS();
        this.resp = api.getResponse();
        this.siteWideCharacteristicSets = this.resp.getSiteWideCharacteristicSets();
        return this.resp;
    }

    public SiteWideCharacteristicsType[] getSiteWideCharacteristics(String catId) throws ApiException, SdkException, Exception {
        if (!this.validate()) {
            this.init(catId);
        }
        ArrayList<SiteWideCharacteristicsType> swCharSetList = new ArrayList<SiteWideCharacteristicsType>();
        for (int i = 0; i < this.siteWideCharacteristicSets.length; ++i) {
            SiteWideCharacteristicsType swCharSet = this.siteWideCharacteristicSets[i];
            if (this.isExcludedCategoryID(catId, swCharSet)) continue;
            swCharSetList.add(swCharSet);
        }
        SiteWideCharacteristicsType[] retVal = new SiteWideCharacteristicsType[swCharSetList.size()];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = (SiteWideCharacteristicsType)swCharSetList.get(i);
        }
        return retVal;
    }

    public int[] getSiteWideCharSetsAttrIds(String catId) throws ApiException, SdkException, Exception {
        SiteWideCharacteristicsType[] swAttrSets = this.getSiteWideCharacteristics(catId);
        int[] ids = new int[swAttrSets.length];
        for (int i = 0; i < this.siteWideCharacteristicSets.length; ++i) {
            SiteWideCharacteristicsType swCharSet = this.siteWideCharacteristicSets[i];
            ids[i] = swCharSet.getCharacteristicsSet().getAttributeSetID();
        }
        return ids;
    }

    private boolean isExcludedCategoryID(String catId, SiteWideCharacteristicsType swCharSet) {
        boolean isExcluded = false;
        String[] excluded = swCharSet.getExcludeCategoryID();
        for (int i = 0; i < excluded.length; ++i) {
            if (!excluded[i].equals(catId)) continue;
            isExcluded = true;
            break;
        }
        return isExcluded;
    }

    public GetCategory2CSResponseType downloadCategoryCS(String catId) throws ApiException, SdkException, Exception {
        return this.downloadCategoryCS(this.apiContext, catId);
    }

    public GetCategory2CSResponseType downloadCategoryCS() throws ApiException, SdkException, Exception {
        return this.downloadCategoryCS(null);
    }

    public GetCategory2CSResponseType getResponse() throws ApiException, SdkException, Exception {
        return this.getResponse(null);
    }

    public GetCategory2CSResponseType getResponse(String catId) throws ApiException, SdkException, Exception {
        if (!this.validate()) {
            this.init(catId);
        }
        return this.resp;
    }
}

