/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.util.Base64;
import com.ebay.sdk.util.eBayUtil;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.GetAttributesXSLRequestType;
import com.ebay.soap.eBLBaseComponents.GetAttributesXSLResponseType;
import com.ebay.soap.eBLBaseComponents.XSLFileType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetAttributesXSLCall
extends ApiCall {
    private String fileName = null;
    private String fileVersion = null;
    private XSLFileType[] XSLFile = null;
    private GetAttributesXSLResponseType response;

    public GetAttributesXSLCall() {
    }

    public GetAttributesXSLCall(ApiContext apiContext) {
        super(apiContext);
    }

    public XSLFileType[] getAttributesXSL() throws ApiException, SdkException, Exception {
        GetAttributesXSLRequestType req = new GetAttributesXSLRequestType();
        req.setDetailLevel(this.getDetailLevel());
        if (this.fileName != null) {
            req.setFileName(this.fileName);
        }
        if (this.fileVersion != null) {
            req.setFileVersion(this.fileVersion);
        }
        GetAttributesXSLResponseType resp = (GetAttributesXSLResponseType)this.execute((AbstractRequestType)req);
        this.XSLFile = resp.getXSLFile();
        if (this.XSLFile != null) {
            GetAttributesXSLCall.decodeXSLData(this.XSLFile);
        }
        this.response = resp;
        return this.getXSLFile();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(String fileVersion) {
        this.fileVersion = fileVersion;
    }

    public static void decodeXSLData(XSLFileType[] files) throws Exception {
        String returnedContent = null;
        for (int i = 0; i < files.length; ++i) {
            returnedContent = files[i].getFileContent();
            if (returnedContent == null) continue;
            byte[] decodeOut = Base64.decode((char[])returnedContent.toCharArray());
            String xsl = eBayUtil.convertInputStreamToString((InputStream)new ByteArrayInputStream(decodeOut));
            files[i].setFileContent(xsl);
        }
    }

    public GetAttributesXSLResponseType getResponse() {
        return this.response;
    }

    public XSLFileType[] getXSLFile() {
        return this.XSLFile;
    }
}

