/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.TimeFilter;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.GetSellerEventsRequestType;
import com.ebay.soap.eBLBaseComponents.GetSellerEventsResponseType;
import com.ebay.soap.eBLBaseComponents.ItemType;
import java.util.Calendar;

public class GetSellerEventsCall
extends ApiCall {
    private String userID = null;
    private TimeFilter startTimeFilter = null;
    private TimeFilter endTimeFilter = null;
    private TimeFilter modTimeFilter = null;
    private boolean includeNewItem = false;
    private Boolean includeWatchCount = null;
    private Boolean includeVariationSpecifics = null;
    private Boolean hideVariations = null;
    private Calendar timeTo = null;
    private ItemType[] returnedSellerEvents = null;

    public GetSellerEventsCall() {
    }

    public GetSellerEventsCall(ApiContext apiContext) {
        super(apiContext);
    }

    public ItemType[] getSellerEvents() throws ApiException, SdkException, Exception {
        GetSellerEventsRequestType req = new GetSellerEventsRequestType();
        req.setDetailLevel(this.getDetailLevel());
        if (this.userID != null) {
            req.setUserID(this.userID);
        }
        if (this.startTimeFilter != null) {
            req.setStartTimeFrom(this.startTimeFilter.getTimeFrom());
            req.setStartTimeTo(this.startTimeFilter.getTimeTo());
        }
        if (this.endTimeFilter != null) {
            req.setEndTimeFrom(this.endTimeFilter.getTimeFrom());
            req.setEndTimeTo(this.endTimeFilter.getTimeTo());
        }
        if (this.modTimeFilter != null) {
            req.setModTimeFrom(this.modTimeFilter.getTimeFrom());
            req.setModTimeTo(this.modTimeFilter.getTimeTo());
        }
        if (this.includeNewItem) {
            req.setNewItemFilter(new Boolean(this.includeNewItem));
        }
        if (this.includeWatchCount != null) {
            req.setIncludeWatchCount(this.includeWatchCount);
        }
        if (this.includeVariationSpecifics != null) {
            req.setIncludeVariationSpecifics(this.includeVariationSpecifics);
        }
        if (this.hideVariations != null) {
            req.setHideVariations(this.hideVariations);
        }
        GetSellerEventsResponseType resp = (GetSellerEventsResponseType)this.execute((AbstractRequestType)req);
        this.timeTo = resp.getTimeTo();
        this.returnedSellerEvents = resp.getItemArray() == null ? null : resp.getItemArray().getItem();
        return this.getReturnedSellerEvents();
    }

    public TimeFilter getEndTimeFilter() {
        return this.endTimeFilter;
    }

    public void setEndTimeFilter(TimeFilter endTimeFilter) {
        this.endTimeFilter = endTimeFilter;
    }

    public Boolean getHideVariations() {
        return this.hideVariations;
    }

    public void setHideVariations(Boolean hideVariations) {
        this.hideVariations = hideVariations;
    }

    public boolean getIncludeNewItem() {
        return this.includeNewItem;
    }

    public void setIncludeNewItem(boolean includeNewItem) {
        this.includeNewItem = includeNewItem;
    }

    public Boolean getIncludeVariationSpecifics() {
        return this.includeVariationSpecifics;
    }

    public void setIncludeVariationSpecifics(Boolean includeVariationSpecifics) {
        this.includeVariationSpecifics = includeVariationSpecifics;
    }

    public Boolean getIncludeWatchCount() {
        return this.includeWatchCount;
    }

    public void setIncludeWatchCount(Boolean includeWatchCount) {
        this.includeWatchCount = includeWatchCount;
    }

    public TimeFilter getModTimeFilter() {
        return this.modTimeFilter;
    }

    public void setModTimeFilter(TimeFilter modTimeFilter) {
        this.modTimeFilter = modTimeFilter;
    }

    public TimeFilter getStartTimeFilter() {
        return this.startTimeFilter;
    }

    public void setStartTimeFilter(TimeFilter startTimeFilter) {
        this.startTimeFilter = startTimeFilter;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public ItemType[] getReturnedSellerEvents() {
        return this.returnedSellerEvents;
    }

    public Calendar getTimeTo() {
        return this.timeTo;
    }
}

