/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.sdk.call;

import com.ebay.sdk.ApiCall;
import com.ebay.sdk.ApiContext;
import com.ebay.sdk.ApiException;
import com.ebay.sdk.SdkException;
import com.ebay.sdk.TimeFilter;
import com.ebay.soap.eBLBaseComponents.AbstractRequestType;
import com.ebay.soap.eBLBaseComponents.GetSellerListRequestType;
import com.ebay.soap.eBLBaseComponents.GetSellerListResponseType;
import com.ebay.soap.eBLBaseComponents.GranularityLevelCodeType;
import com.ebay.soap.eBLBaseComponents.ItemType;
import com.ebay.soap.eBLBaseComponents.PaginationResultType;
import com.ebay.soap.eBLBaseComponents.PaginationType;
import com.ebay.soap.eBLBaseComponents.SKUArrayType;
import com.ebay.soap.eBLBaseComponents.UserIDArrayType;
import com.ebay.soap.eBLBaseComponents.UserType;
import java.util.ArrayList;

public class GetSellerListCall
extends ApiCall {
    private String userID = null;
    private UserIDArrayType motorsDealerUsers = null;
    private TimeFilter endTimeFilter = null;
    private int sort = 0;
    private TimeFilter startTimeFilter = null;
    private PaginationType pagination = null;
    private GranularityLevelCodeType granularityLevel = null;
    private SKUArrayType sKUArray = null;
    private Boolean includeWatchCount = null;
    private Boolean adminEndedItemsOnly = null;
    private Integer categoryID = null;
    private Boolean includeVariations = null;
    private GetSellerListRequestType request = null;
    private PaginationResultType paginationResult = null;
    private boolean hasMoreItems = false;
    private ItemType[] returnedItems = null;
    private Integer returnedItemsPerPage = null;
    private Integer returnedPageNumber = null;
    private int returnedItemCountActual = 0;
    private UserType seller = null;

    public GetSellerListCall() {
    }

    public GetSellerListCall(ApiContext apiContext) {
        super(apiContext);
    }

    public ItemType[] getSellerList() throws ApiException, SdkException, Exception {
        GetSellerListRequestType req;
        if (this.request != null) {
            req = this.request;
        } else {
            req = new GetSellerListRequestType();
            req.setDetailLevel(this.getDetailLevel());
            if (this.userID != null) {
                req.setUserID(this.userID);
            }
            if (this.motorsDealerUsers != null) {
                req.setMotorsDealerUsers(this.motorsDealerUsers);
            }
            if (this.endTimeFilter != null) {
                req.setEndTimeFrom(this.endTimeFilter.getTimeFrom());
                req.setEndTimeTo(this.endTimeFilter.getTimeTo());
            }
            if (this.sort != 0) {
                req.setSort(new Integer(this.sort));
            }
            if (this.startTimeFilter != null) {
                req.setStartTimeFrom(this.startTimeFilter.getTimeFrom());
                req.setStartTimeTo(this.startTimeFilter.getTimeTo());
            }
            if (this.pagination != null) {
                req.setPagination(this.pagination);
            }
            if (this.granularityLevel != null) {
                req.setGranularityLevel(this.granularityLevel);
            }
            if (this.sKUArray != null) {
                req.setSKUArray(this.sKUArray);
            }
            if (this.includeWatchCount != null) {
                req.setIncludeWatchCount(this.includeWatchCount);
            }
            if (this.adminEndedItemsOnly != null) {
                req.setAdminEndedItemsOnly(this.adminEndedItemsOnly);
            }
            if (this.categoryID != null) {
                req.setCategoryID(this.categoryID);
            }
            if (this.includeVariations != null) {
                req.setIncludeVariations(this.includeVariations);
            }
        }
        GetSellerListResponseType resp = (GetSellerListResponseType)this.execute((AbstractRequestType)req);
        this.paginationResult = resp.getPaginationResult();
        this.hasMoreItems = resp.isHasMoreItems() == null ? false : resp.isHasMoreItems();
        this.returnedItems = resp.getItemArray() == null ? null : resp.getItemArray().getItem();
        this.returnedItemsPerPage = resp.getItemsPerPage();
        this.returnedPageNumber = resp.getPageNumber();
        this.returnedItemCountActual = resp.getReturnedItemCountActual() == null ? 0 : resp.getReturnedItemCountActual();
        this.seller = resp.getSeller();
        return this.getReturnedItems();
    }

    public GetSellerListRequestType getRequest() {
        return this.request;
    }

    public void setRequest(GetSellerListRequestType request) {
        this.request = request;
    }

    public Boolean getAdminEndedItemsOnly() {
        return this.adminEndedItemsOnly;
    }

    public void setAdminEndedItemsOnly(Boolean adminEndedItemsOnly) {
        this.adminEndedItemsOnly = adminEndedItemsOnly;
    }

    public Integer getCategoryID() {
        return this.categoryID;
    }

    public void setCategoryID(Integer categoryID) {
        this.categoryID = categoryID;
    }

    public TimeFilter getEndTimeFilter() {
        return this.endTimeFilter;
    }

    public void setEndTimeFilter(TimeFilter endTimeFilter) {
        this.endTimeFilter = endTimeFilter;
    }

    public GranularityLevelCodeType getGranularityLevel() {
        return this.granularityLevel;
    }

    public void setGranularityLevel(GranularityLevelCodeType granularityLevel) {
        this.granularityLevel = granularityLevel;
    }

    public Boolean getIncludeVariations() {
        return this.includeVariations;
    }

    public void setIncludeVariations(Boolean includeVariations) {
        this.includeVariations = includeVariations;
    }

    public Boolean getIncludeWatchCount() {
        return this.includeWatchCount;
    }

    public void setIncludeWatchCount(Boolean includeWatchCount) {
        this.includeWatchCount = includeWatchCount;
    }

    public UserIDArrayType getMotorsDealerUsers() {
        return this.motorsDealerUsers;
    }

    public void setMotorsDealerUsers(UserIDArrayType motorsDealerUsers) {
        this.motorsDealerUsers = motorsDealerUsers;
    }

    public PaginationType getPagination() {
        return this.pagination;
    }

    public void setPagination(PaginationType pagination) {
        this.pagination = pagination;
    }

    public SKUArrayType getSKUArray() {
        return this.sKUArray;
    }

    public void setSKUArray(SKUArrayType sKUArray) {
        this.sKUArray = sKUArray;
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public TimeFilter getStartTimeFilter() {
        return this.startTimeFilter;
    }

    public void setStartTimeFilter(TimeFilter startTimeFilter) {
        this.startTimeFilter = startTimeFilter;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public ItemType[] getEntireSellerList() throws ApiException, SdkException, Exception {
        GetSellerListRequestType req = new GetSellerListRequestType();
        this.setRequest(req);
        req.setDetailLevel(this.getDetailLevel());
        if (this.userID != null) {
            req.setUserID(this.userID);
        }
        if (this.endTimeFilter != null) {
            req.setEndTimeFrom(this.endTimeFilter.getTimeFrom());
            req.setEndTimeTo(this.endTimeFilter.getTimeTo());
        }
        if (this.sort != 0) {
            req.setSort(new Integer(this.sort));
        }
        if (this.startTimeFilter != null) {
            req.setStartTimeFrom(this.startTimeFilter.getTimeFrom());
            req.setStartTimeTo(this.startTimeFilter.getTimeTo());
        }
        if (this.granularityLevel != null) {
            req.setGranularityLevel(this.granularityLevel);
        }
        if (this.sKUArray != null) {
            req.setSKUArray(this.sKUArray);
        }
        if (this.includeWatchCount != null) {
            req.setIncludeWatchCount(this.includeWatchCount);
        }
        int pageNum = 1;
        PaginationType pgn = new PaginationType();
        pgn.setEntriesPerPage(new Integer(100));
        pgn.setPageNumber(new Integer(pageNum++));
        req.setPagination(pgn);
        ArrayList<ItemType> items = new ArrayList<ItemType>();
        while (true) {
            GetSellerListResponseType resp;
            ItemType[] tm;
            if ((tm = (resp = (GetSellerListResponseType)this.execute((AbstractRequestType)req)).getItemArray().getItem()) != null) {
                for (int i = 0; i < tm.length; ++i) {
                    items.add(tm[i]);
                }
            }
            if (resp.isHasMoreItems() == null || !resp.isHasMoreItems().booleanValue()) break;
            this.seller = resp.getSeller();
            this.returnedItemCountActual = resp.getReturnedItemCountActual() != null ? resp.getReturnedItemCountActual() : 0;
            pgn.setPageNumber(new Integer(pageNum++));
        }
        this.returnedItems = new ItemType[items.size()];
        for (int i = 0; i < this.returnedItems.length; ++i) {
            this.returnedItems[i] = (ItemType)items.get(i);
        }
        return this.returnedItems;
    }

    public boolean getHasMoreItems() {
        return this.hasMoreItems;
    }

    public PaginationResultType getPaginationResult() {
        return this.paginationResult;
    }

    public int getReturnedItemCountActual() {
        return this.returnedItemCountActual;
    }

    public ItemType[] getReturnedItems() {
        return this.returnedItems;
    }

    public Integer getReturnedItemsPerPage() {
        return this.returnedItemsPerPage;
    }

    public Integer getReturnedPageNumber() {
        return this.returnedPageNumber;
    }

    public UserType getSeller() {
        return this.seller;
    }
}

