/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.silentupdate;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;
import pnp.services.preferencemanager.Preferences;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.GenericFunctions;

public final class UpdateHandler {
    public static final String SILENT_UC_CODE_NAME = "org_netbeans_modules_autoupdate_silentupdate_update_center";
    public static final String SILENT_UC_CODE_NAME_BETA = "org_netbeans_modules_autoupdate_silentupdate_update_center_beta";

    public static boolean timeToCheck() {
        return true;
    }

    public static void checkAndHandleUpdates(boolean installUpdates, boolean restartNow) {
        OperationContainer<InstallSupport> containerForUpdate;
        UpdateHandler.refreshSilentUpdateProvider();
        Collection<UpdateElement> updates = UpdateHandler.findUpdates();
        Collection<Object> available = Collections.emptySet();
        if (UpdateHandler.installNewModules()) {
            available = UpdateHandler.findNewModules();
        }
        if (updates.isEmpty() && available.isEmpty()) {
            ErrorsUtil.getInstance().writeLog("None for install");
            if (installUpdates) {
                JOptionPane.showMessageDialog(null, "No Updates Available.");
            }
            return;
        }
        OperationContainer<InstallSupport> containerForInstall = UpdateHandler.feedContainer(available, false);
        if (containerForInstall != null) {
            try {
                UpdateHandler.handleInstall(containerForInstall, restartNow);
                ErrorsUtil.getInstance().writeLog("Install new modules done.");
            }
            catch (UpdateHandlerException ex) {
                ErrorsUtil.getInstance().writeLog(ex.getLocalizedMessage() + "\r\n" + ex.getCause());
                return;
            }
        }
        if ((containerForUpdate = UpdateHandler.feedContainer(updates, true)) != null) {
            try {
                UpdateHandler.handleInstall(containerForUpdate, restartNow);
                ErrorsUtil.getInstance().writeLog("Update done.");
            }
            catch (UpdateHandlerException ex) {
                ErrorsUtil.getInstance().writeLog(ex.getLocalizedMessage() + "\r\n" + ex.getCause());
                return;
            }
        }
        if (installUpdates) {
            UpdateHandler.checkAndHandleUpdates(false, restartNow);
        }
    }

    public static boolean isLicenseApproved(String license) {
        return true;
    }

    static Collection<UpdateElement> findUpdates() {
        HashSet<UpdateElement> elements4update = new HashSet<UpdateElement>();
        List updateUnits = UpdateManager.getDefault().getUpdateUnits();
        for (UpdateUnit unit : updateUnits) {
            if (unit.getInstalled() == null || unit.getAvailableUpdates().isEmpty()) continue;
            elements4update.add((UpdateElement)unit.getAvailableUpdates().get(0));
        }
        return elements4update;
    }

    static void handleInstall(OperationContainer<InstallSupport> container, boolean restartNow) throws UpdateHandlerException {
        if (!UpdateHandler.allLicensesApproved(container)) {
            throw new UpdateHandlerException("Cannot continue because license approval is missing for some updates.");
        }
        InstallSupport support = (InstallSupport)container.getSupport();
        InstallSupport.Validator v = null;
        try {
            v = UpdateHandler.doDownload(support);
        }
        catch (OperationException ex) {
            throw new UpdateHandlerException("A problem caught while downloading, cause: ", ex);
        }
        if (v == null) {
            throw new UpdateHandlerException("Missing Update Validator => cannot continue.");
        }
        InstallSupport.Installer i = null;
        try {
            i = UpdateHandler.doVerify(support, v);
        }
        catch (OperationException ex) {
            throw new UpdateHandlerException("A problem caught while verification of updates, cause: ", ex);
        }
        if (i == null) {
            throw new UpdateHandlerException("Missing Update Installer => cannot continue.");
        }
        OperationSupport.Restarter r = null;
        try {
            r = UpdateHandler.doInstall(support, i);
        }
        catch (OperationException ex) {
            throw new UpdateHandlerException("A problem caught while installation of updates, cause: ", ex);
        }
        try {
            if (restartNow) {
                if (GenericFunctions.getInstance().createAcceptDialog("Restart Gamut?", "Restarting is required to complete the install.\nRestart Now? (All unsaved changes will be lost)")) {
                    support.doRestart(r, ProgressHandleFactory.createHandle((String)"Restarting Gamut..."));
                } else {
                    restartNow = false;
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
            restartNow = false;
        }
        if (!restartNow) {
            support.doRestartLater(r);
        }
    }

    static Collection<UpdateElement> findNewModules() {
        HashSet<UpdateElement> elements4install = new HashSet<UpdateElement>();
        List updateUnits = UpdateManager.getDefault().getUpdateUnits();
        for (UpdateUnit unit : updateUnits) {
            if (unit.getInstalled() != null || unit.getAvailableUpdates().isEmpty()) continue;
            elements4install.add((UpdateElement)unit.getAvailableUpdates().get(0));
        }
        return elements4install;
    }

    static void refreshSilentUpdateProvider() {
        UpdateUnitProvider silentUpdateProvider = UpdateHandler.getSilentUpdateProvider();
        if (silentUpdateProvider == null) {
            ErrorsUtil.getInstance().writeLog("Missing Silent Update Provider => cannot continue.");
            return;
        }
        try {
            silentUpdateProvider.refresh(ProgressHandleFactory.createHandle((String)"Updating Gamut..."), true);
        }
        catch (IOException ex) {
            ErrorsUtil.getInstance().writeLog("A problem caught while refreshing Update Centers, cause: \r\n" + ex.getLocalizedMessage() + "\r\n" + ex.getCause());
        }
    }

    static UpdateUnitProvider getSilentUpdateProvider() {
        List providers = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true);
        for (UpdateUnitProvider p : providers) {
            if (Preferences.getInstance().getAccountPreferences().isGenBetaUpdates() && SILENT_UC_CODE_NAME_BETA.equals(p.getName())) {
                try {
                    p.refresh(ProgressHandleFactory.createHandle((String)"Updating Gamut (Beta)..."), true);
                }
                catch (IOException ex) {
                    ErrorsUtil.getInstance().writeLog("A problem caught while refreshing Update Centers, cause: \r\n" + ex.getLocalizedMessage() + "\r\n" + ex.getCause());
                }
                return p;
            }
            if (Preferences.getInstance().getAccountPreferences().isGenBetaUpdates() || !SILENT_UC_CODE_NAME.equals(p.getName())) continue;
            try {
                p.refresh(ProgressHandleFactory.createHandle((String)"Updating Gamut..."), true);
            }
            catch (IOException ex) {
                ErrorsUtil.getInstance().writeLog("A problem caught while refreshing Update Centers, cause: \r\n" + ex.getLocalizedMessage() + "\r\n" + ex.getCause());
            }
            return p;
        }
        return null;
    }

    static OperationContainer<InstallSupport> feedContainer(Collection<UpdateElement> updates, boolean update) {
        if (updates == null || updates.isEmpty()) {
            return null;
        }
        OperationContainer container = update ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
        for (UpdateElement ue : updates) {
            if (!container.canBeAdded(ue.getUpdateUnit(), ue)) continue;
            ErrorsUtil.getInstance().writeLog("Update found: " + ue);
            OperationContainer.OperationInfo operationInfo = container.add(ue);
            if (operationInfo == null) continue;
            container.add((Collection)operationInfo.getRequiredElements());
            if (operationInfo.getBrokenDependencies().isEmpty()) continue;
            ErrorsUtil.getInstance().writeLog("There are broken dependencies => cannot continue, broken deps: " + operationInfo.getBrokenDependencies());
            return null;
        }
        return container;
    }

    static boolean allLicensesApproved(OperationContainer<InstallSupport> container) {
        if (!container.listInvalid().isEmpty()) {
            return false;
        }
        for (OperationContainer.OperationInfo info : container.listAll()) {
            String license = info.getUpdateElement().getLicence();
            if (UpdateHandler.isLicenseApproved(license)) continue;
            return false;
        }
        return true;
    }

    static InstallSupport.Validator doDownload(InstallSupport support) throws OperationException {
        ProgressHandle downloadHandle = ProgressHandleFactory.createHandle((String)"Downloading Gamut Updates..");
        return support.doDownload(downloadHandle, true);
    }

    static InstallSupport.Installer doVerify(InstallSupport support, InstallSupport.Validator validator) throws OperationException {
        ProgressHandle validateHandle = ProgressHandleFactory.createHandle((String)"Verifying Gamut Install..");
        InstallSupport.Installer installer = support.doValidate(validator, validateHandle);
        return installer;
    }

    static OperationSupport.Restarter doInstall(InstallSupport support, InstallSupport.Installer installer) throws OperationException {
        ProgressHandle installHandle = ProgressHandleFactory.createHandle((String)"Installing Gamut Updates..");
        return support.doInstall(installer, installHandle);
    }

    private static boolean installNewModules() {
        String s = NbBundle.getBundle((String)"org.netbeans.modules.autoupdate.silentupdate.resources.Bundle").getString("UpdateHandler.NewModules");
        return Boolean.parseBoolean(s);
    }

    public static class UpdateHandlerException
    extends Exception {
        public UpdateHandlerException(String msg) {
            super(msg);
        }

        public UpdateHandlerException(String msg, Throwable th) {
            super(msg, th);
        }
    }
}

