/*
 * Decompiled with CFR 0.152.
 */
package pnp.invoicegenerator;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.jasper.builder.export.Exporters;
import net.sf.dynamicreports.report.builder.DynamicReports;
import pnp.invoicegenerator.invoices.InvoiceDesign;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.util.ErrorsUtil;

public class InvoiceGenerator {
    private static InvoiceGenerator _instance;
    private static float _progress;
    private static boolean _updatePending;

    private InvoiceGenerator() {
        _updatePending = false;
        _progress = 0.0f;
    }

    public static InvoiceGenerator getInstance() {
        if (null == _instance) {
            _instance = new InvoiceGenerator();
        }
        return _instance;
    }

    public void build(ArrayList<CompleteOrder> orders, String filename) {
        _progress = 0.0f;
        if (orders != null && !orders.isEmpty() && filename != null && !filename.isEmpty()) {
            try {
                int position = 0;
                ArrayList<JasperReportBuilder> invoices = new ArrayList<JasperReportBuilder>();
                Iterator<CompleteOrder> iter = orders.iterator();
                while (iter.hasNext()) {
                    _progress = (float)(++position) / (float)orders.size() * 100.0f;
                    ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVOICE_PROGRESS_LISTENER);
                    CompleteOrder order = iter.next();
                    JasperReportBuilder report = this.generateInvoice(order);
                    if (report == null) {
                        JOptionPane.showMessageDialog(null, "Could not create invoice for order number: " + order.getOrder().getOrderID());
                    }
                    invoices.add(report);
                }
                DynamicReports.concatenatedReport().concatenate(invoices.toArray(new JasperReportBuilder[0])).toPdf(Exporters.pdfExporter((String)filename));
                ListenerManager.getInstance().notify((GenericListener)ListenerManager.INVOICE_PROGRESS_LISTENER);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Something entirely unexpected happened.\nPlease keep a record of the orders invoice attempted to create and save a copy of your current database.");
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        _progress = 100.0f;
        _updatePending = false;
    }

    private JasperReportBuilder generateInvoice(CompleteOrder order) {
        return new InvoiceDesign().build(order);
    }

    public float getUpdatePercentage() {
        return _progress;
    }

    public void setUpdatePending(boolean updatePending) {
        _updatePending = updatePending;
    }

    public boolean isUpdatePending() {
        return _updatePending;
    }
}

