/*
 * Decompiled with CFR 0.152.
 */
package pnp.invoicegenerator.invoices;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.HorizontalListCellBuilder;
import net.sf.dynamicreports.report.builder.component.VerticalListBuilder;
import net.sf.dynamicreports.report.builder.grid.ColumnGridComponentBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.builder.subtotal.AggregationSubtotalBuilder;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.definition.expression.DRIValueFormatter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import pnp.invoicegenerator.datatypes.ItemLine;
import pnp.services.datatypes.CompleteOrder;
import pnp.services.datatypes.Customer;
import pnp.services.datatypes.OrderDetails;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;

public class InvoiceDesign {
    private AggregationSubtotalBuilder<BigDecimal> totalSum;
    private StyleBuilder bold14Style;
    private CompleteOrder order;

    public JasperReportBuilder build(CompleteOrder order) {
        JasperReportBuilder report = null;
        try {
            this.order = order;
            report = DynamicReports.report();
            HashMap<String, ItemLine> orderDetailsMap = new HashMap<String, ItemLine>();
            ArrayList<ItemLine> itemDataSource = new ArrayList<ItemLine>();
            for (OrderDetails orderDetail : order.getOrderDetails()) {
                ItemLine item;
                if (orderDetailsMap.containsKey(orderDetail.getItemID())) {
                    item = (ItemLine)orderDetailsMap.get(orderDetail.getItemID());
                    item.setQuantity(item.getQuantity() + 1);
                    orderDetailsMap.put(orderDetail.getItemID(), item);
                    continue;
                }
                item = new ItemLine();
                item.setItemID(orderDetail.getItemID());
                item.setOrderDescription(orderDetail.getOrderDescription());
                item.setOrderNumber(orderDetail.getOrderNumber());
                item.setQuantity(1);
                item.setSalesPrice(BigDecimal.valueOf(orderDetail.getSalesPrice()));
                orderDetailsMap.put(orderDetail.getItemID(), item);
            }
            ItemLine[] items = orderDetailsMap.values().toArray(new ItemLine[0]);
            for (int i = 0; i < items.length; ++i) {
                itemDataSource.add(items[i]);
            }
            this.bold14Style = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)Templates.boldStyle).setFontSize(Integer.valueOf(14));
            StyleBuilder columnStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)pnp.invoicegenerator.template.Templates.columnStyle).setBorder(DynamicReports.stl.pen1Point());
            StyleBuilder subtotalStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)pnp.invoicegenerator.template.Templates.boldStyle).setHorizontalAlignment(HorizontalAlignment.RIGHT);
            StyleBuilder shippingStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)pnp.invoicegenerator.template.Templates.boldStyle).setHorizontalAlignment(HorizontalAlignment.RIGHT);
            TextColumnBuilder rowNumberColumn = (TextColumnBuilder)((TextColumnBuilder)DynamicReports.col.reportRowNumberColumn().setFixedColumns(Integer.valueOf(2))).setHorizontalAlignment(HorizontalAlignment.CENTER);
            TextColumnBuilder refColumn = (TextColumnBuilder)DynamicReports.col.column("Ref. Number", "orderNumber", (DRIDataType)DynamicReports.type.stringType()).setFixedWidth(Integer.valueOf(75));
            TextColumnBuilder skuColumn = (TextColumnBuilder)DynamicReports.col.column("Product SKU", "itemID", (DRIDataType)DynamicReports.type.stringType()).setFixedWidth(Integer.valueOf(100));
            TextColumnBuilder descriptionColumn = (TextColumnBuilder)DynamicReports.col.column("Description", "orderDescription", (DRIDataType)DynamicReports.type.stringType()).setFixedWidth(Integer.valueOf(225));
            TextColumnBuilder quantityColumn = (TextColumnBuilder)DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType()).setHorizontalAlignment(HorizontalAlignment.CENTER);
            TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit Price", "salesPrice", (DRIDataType)pnp.invoicegenerator.template.Templates.currencyType);
            TextColumnBuilder totalPriceColumn = (TextColumnBuilder)((TextColumnBuilder)unitPriceColumn.multiply(quantityColumn).setTitle("Total Price")).setDataType((DRIDataType)pnp.invoicegenerator.template.Templates.currencyType);
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)report.setSubtotalStyle((ReportStyleBuilder)subtotalStyle)).setTemplate(pnp.invoicegenerator.template.Templates.reportTemplate)).setColumnStyle((ReportStyleBuilder)columnStyle)).columns(new ColumnBuilder[]{rowNumberColumn, refColumn, skuColumn, descriptionColumn, quantityColumn, unitPriceColumn, totalPriceColumn})).columnGrid(new ColumnGridComponentBuilder[]{rowNumberColumn, refColumn, skuColumn, descriptionColumn, quantityColumn, unitPriceColumn, totalPriceColumn})).title(new ComponentBuilder[]{pnp.invoicegenerator.template.Templates.createTitleComponent("Invoice No.: " + order.getOrder().getOrderID()), DynamicReports.cmp.horizontalList().setStyle((ReportStyleBuilder)DynamicReports.stl.style(Integer.valueOf(10))).setGap(Integer.valueOf(50)).add(new HorizontalListCellBuilder[]{DynamicReports.cmp.hListCell(this.createCustomerComponent("Ship To", order.getOrder().getCustomer())).heightFixedOnTop()}), DynamicReports.cmp.verticalGap(10)})).pageFooter(new ComponentBuilder[]{pnp.invoicegenerator.template.Templates.footerComponent})).summary(new ComponentBuilder[]{DynamicReports.cmp.verticalGap(10), DynamicReports.cmp.text((Number)Float.valueOf(order.getOrder().getOrderTotal())).setValueFormatter((DRIValueFormatter)pnp.invoicegenerator.template.Templates.createCurrencyValueFormatter("Sub Total:")).setStyle((ReportStyleBuilder)shippingStyle), DynamicReports.cmp.text((Number)Float.valueOf(order.getOrder().getShippingPaid())).setValueFormatter((DRIValueFormatter)pnp.invoicegenerator.template.Templates.createCurrencyValueFormatter("Shipping Cost:")).setStyle((ReportStyleBuilder)shippingStyle), DynamicReports.cmp.text((DRIExpression)new TotalPaymentExpression()).setStyle((ReportStyleBuilder)shippingStyle), DynamicReports.cmp.verticalGap(30), DynamicReports.cmp.text(LookupServicesUtil.getDBServices().getAccountPreferences().getGenInvoiceComments()).setStyle((ReportStyleBuilder)pnp.invoicegenerator.template.Templates.bold12CenteredStyle)})).setDataSource((JRDataSource)new JRBeanCollectionDataSource(itemDataSource));
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return report;
    }

    private ComponentBuilder<?, ?> createCustomerComponent(String label, Customer customer) {
        VerticalListBuilder content = DynamicReports.cmp.verticalList(new ComponentBuilder[]{DynamicReports.cmp.text(customer.getCustomerName()), DynamicReports.cmp.text(customer.getCustomerAddress()), DynamicReports.cmp.text(customer.getCustomerCity() + ", " + customer.getCustomerState() + " " + customer.getCustomerZipcode())});
        return this.createCellComponent(label, (ComponentBuilder<?, ?>)content);
    }

    private ComponentBuilder<?, ?> createCellComponent(String label, ComponentBuilder<?, ?> content) {
        VerticalListBuilder cell = DynamicReports.cmp.verticalList(new ComponentBuilder[]{DynamicReports.cmp.text(label).setStyle((ReportStyleBuilder)this.bold14Style), DynamicReports.cmp.horizontalList(new ComponentBuilder[]{DynamicReports.cmp.horizontalGap(20), content, DynamicReports.cmp.horizontalGap(5)})});
        cell.setStyle((ReportStyleBuilder)DynamicReports.stl.style(DynamicReports.stl.pen2Point()));
        return cell;
    }

    private class TotalPaymentExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private TotalPaymentExpression() {
        }

        public String evaluate(ReportParameters reportParameters) {
            BigDecimal total = BigDecimal.valueOf(InvoiceDesign.this.order.getOrder().getOrderTotal());
            BigDecimal shipping = total.add(BigDecimal.valueOf(InvoiceDesign.this.order.getOrder().getShippingPaid()));
            return "Total: " + pnp.invoicegenerator.template.Templates.currencyType.valueToString(shipping, reportParameters.getLocale());
        }
    }
}

