/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.samples;

import com.amazonaws.mws.MarketplaceWebService;
import com.amazonaws.mws.MarketplaceWebServiceClient;
import com.amazonaws.mws.MarketplaceWebServiceConfig;
import com.amazonaws.mws.MarketplaceWebServiceException;
import com.amazonaws.mws.model.GetReportCountRequest;
import com.amazonaws.mws.model.GetReportCountResponse;
import com.amazonaws.mws.model.GetReportCountResult;
import com.amazonaws.mws.model.ResponseMetadata;

public class GetReportCountSample {
    public static void main(String ... args) {
        String accessKeyId = "<Your Access Key ID>";
        String secretAccessKey = "<Your Secret Access Key>";
        String appName = "<Your Application or Company Name>";
        String appVersion = "<Your Application Version or Build Number or Release Date>";
        MarketplaceWebServiceConfig config = new MarketplaceWebServiceConfig();
        config.setMaxAsyncThreads(35);
        MarketplaceWebServiceClient service = new MarketplaceWebServiceClient("<Your Access Key ID>", "<Your Secret Access Key>", "<Your Application or Company Name>", "<Your Application Version or Build Number or Release Date>", config);
        String merchantId = "<Your Merchant ID>";
        String sellerDevAuthToken = "<Merchant Developer MWS Auth Token>";
        GetReportCountRequest request = new GetReportCountRequest();
        request.setMerchant("<Your Merchant ID>");
    }

    public static void invokeGetReportCount(MarketplaceWebService service, GetReportCountRequest request) {
        try {
            GetReportCountResponse response = service.getReportCount(request);
            System.out.println("GetReportCount Action Response");
            System.out.println("=============================================================================");
            System.out.println();
            System.out.print("    GetReportCountResponse");
            System.out.println();
            if (response.isSetGetReportCountResult()) {
                System.out.print("        GetReportCountResult");
                System.out.println();
                GetReportCountResult getReportCountResult = response.getGetReportCountResult();
                if (getReportCountResult.isSetCount()) {
                    System.out.print("            Count");
                    System.out.println();
                    System.out.print("                " + getReportCountResult.getCount());
                    System.out.println();
                }
            }
            if (response.isSetResponseMetadata()) {
                System.out.print("        ResponseMetadata");
                System.out.println();
                ResponseMetadata responseMetadata = response.getResponseMetadata();
                if (responseMetadata.isSetRequestId()) {
                    System.out.print("            RequestId");
                    System.out.println();
                    System.out.print("                " + responseMetadata.getRequestId());
                    System.out.println();
                }
            }
            System.out.println();
            System.out.println(response.getResponseHeaderMetadata());
            System.out.println();
        }
        catch (MarketplaceWebServiceException ex) {
            System.out.println("Caught Exception: " + ex.getMessage());
            System.out.println("Response Status Code: " + ex.getStatusCode());
            System.out.println("Error Code: " + ex.getErrorCode());
            System.out.println("Error Type: " + ex.getErrorType());
            System.out.println("Request ID: " + ex.getRequestId());
            System.out.print("XML: " + ex.getXML());
            System.out.println("ResponseHeaderMetadata: " + ex.getResponseHeaderMetadata());
        }
    }
}

