/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.samples;

import com.amazonaws.mws.MarketplaceWebService;
import com.amazonaws.mws.MarketplaceWebServiceClient;
import com.amazonaws.mws.MarketplaceWebServiceConfig;
import com.amazonaws.mws.MarketplaceWebServiceException;
import com.amazonaws.mws.model.GetReportRequest;
import com.amazonaws.mws.model.GetReportResponse;
import com.amazonaws.mws.model.ResponseMetadata;

public class GetReportSample {
    public static void main(String ... args) {
        String accessKeyId = "<Your Access Key ID>";
        String secretAccessKey = "<Your Secret Access Key>";
        String appName = "<Your Application or Company Name>";
        String appVersion = "<Your Application Version or Build Number or Release Date>";
        MarketplaceWebServiceConfig config = new MarketplaceWebServiceConfig();
        MarketplaceWebServiceClient service = new MarketplaceWebServiceClient("<Your Access Key ID>", "<Your Secret Access Key>", "<Your Application or Company Name>", "<Your Application Version or Build Number or Release Date>", config);
        String merchantId = "<Your Merchant ID>";
        String sellerDevAuthToken = "<Merchant Developer MWS Auth Token>";
        GetReportRequest request = new GetReportRequest();
        request.setMerchant("<Your Merchant ID>");
        request.setReportId("<Report ID>");
    }

    public static void invokeGetReport(MarketplaceWebService service, GetReportRequest request) {
        try {
            GetReportResponse response = service.getReport(request);
            System.out.println("GetReport Action Response");
            System.out.println("=============================================================================");
            System.out.println();
            System.out.print("    GetReportResponse");
            System.out.println();
            System.out.print("    GetReportResult");
            System.out.println();
            System.out.print("            MD5Checksum");
            System.out.println();
            System.out.print("                " + response.getGetReportResult().getMD5Checksum());
            System.out.println();
            if (response.isSetResponseMetadata()) {
                System.out.print("        ResponseMetadata");
                System.out.println();
                ResponseMetadata responseMetadata = response.getResponseMetadata();
                if (responseMetadata.isSetRequestId()) {
                    System.out.print("            RequestId");
                    System.out.println();
                    System.out.print("                " + responseMetadata.getRequestId());
                    System.out.println();
                }
            }
            System.out.println();
            System.out.println("Report");
            System.out.println("=============================================================================");
            System.out.println();
            System.out.println(request.getReportOutputStream().toString());
            System.out.println();
            System.out.println(response.getResponseHeaderMetadata());
            System.out.println();
        }
        catch (MarketplaceWebServiceException ex) {
            System.out.println("Caught Exception: " + ex.getMessage());
            System.out.println("Response Status Code: " + ex.getStatusCode());
            System.out.println("Error Code: " + ex.getErrorCode());
            System.out.println("Error Type: " + ex.getErrorType());
            System.out.println("Request ID: " + ex.getRequestId());
            System.out.print("XML: " + ex.getXML());
            System.out.println("ResponseHeaderMetadata: " + ex.getResponseHeaderMetadata());
        }
    }
}

