/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.samples;

import com.amazonaws.mws.MarketplaceWebService;
import com.amazonaws.mws.MarketplaceWebServiceClient;
import com.amazonaws.mws.MarketplaceWebServiceConfig;
import com.amazonaws.mws.MarketplaceWebServiceException;
import com.amazonaws.mws.model.GetReportScheduleCountRequest;
import com.amazonaws.mws.model.GetReportScheduleCountResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetReportScheduleCountAsyncSample {
    public static void main(String ... args) {
        String accessKeyId = "<Your Access Key ID>";
        String secretAccessKey = "<Your Secret Access Key>";
        String appName = "<Your Application or Company Name>";
        String appVersion = "<Your Application Version or Build Number or Release Date>";
        MarketplaceWebServiceConfig config = new MarketplaceWebServiceConfig();
        config.setMaxAsyncThreads(35);
        MarketplaceWebServiceClient service = new MarketplaceWebServiceClient("<Your Access Key ID>", "<Your Secret Access Key>", "<Your Application or Company Name>", "<Your Application Version or Build Number or Release Date>", config);
        String merchantId = "<Your Merchant ID>";
        String sellerDevAuthToken = "<Merchant Developer MWS Auth Token>";
        GetReportScheduleCountRequest requestOne = new GetReportScheduleCountRequest();
        requestOne.setMerchant("<Your Merchant ID>");
        GetReportScheduleCountRequest requestTwo = new GetReportScheduleCountRequest();
        requestTwo.setMerchant("<Your Merchant ID>");
        ArrayList<GetReportScheduleCountRequest> requests = new ArrayList<GetReportScheduleCountRequest>();
        requests.add(requestOne);
        requests.add(requestTwo);
    }

    public static void invokeGetReportScheduleCount(MarketplaceWebService service, List<GetReportScheduleCountRequest> requests) {
        ArrayList<Future<GetReportScheduleCountResponse>> responses = new ArrayList<Future<GetReportScheduleCountResponse>>();
        for (GetReportScheduleCountRequest getReportScheduleCountRequest : requests) {
            responses.add(service.getReportScheduleCountAsync(getReportScheduleCountRequest));
        }
        for (Future future : responses) {
            while (!future.isDone()) {
                Thread.yield();
            }
            try {
                GetReportScheduleCountResponse response = (GetReportScheduleCountResponse)future.get();
                GetReportScheduleCountRequest originalRequest = requests.get(responses.indexOf(future));
                System.out.println("Response request id: " + response.getResponseMetadata().getRequestId());
                System.out.println(response.getResponseHeaderMetadata());
                System.out.println();
            }
            catch (Exception e) {
                if (e.getCause() instanceof MarketplaceWebServiceException) {
                    MarketplaceWebServiceException exception = (MarketplaceWebServiceException)MarketplaceWebServiceException.class.cast(e.getCause());
                    System.out.println("Caught Exception: " + exception.getMessage());
                    System.out.println("Response Status Code: " + exception.getStatusCode());
                    System.out.println("Error Code: " + exception.getErrorCode());
                    System.out.println("Error Type: " + exception.getErrorType());
                    System.out.println("Request ID: " + exception.getRequestId());
                    System.out.print("XML: " + exception.getXML());
                    System.out.println("ResponseHeaderMetadata: " + exception.getResponseHeaderMetadata());
                    continue;
                }
                e.printStackTrace();
            }
        }
    }
}

