/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.samples;

import com.amazonaws.mws.MarketplaceWebService;
import com.amazonaws.mws.MarketplaceWebServiceClient;
import com.amazonaws.mws.MarketplaceWebServiceConfig;
import com.amazonaws.mws.MarketplaceWebServiceException;
import com.amazonaws.mws.model.GetReportScheduleListByNextTokenRequest;
import com.amazonaws.mws.model.GetReportScheduleListByNextTokenResponse;
import com.amazonaws.mws.model.GetReportScheduleListByNextTokenResult;
import com.amazonaws.mws.model.ReportSchedule;
import com.amazonaws.mws.model.ResponseMetadata;
import java.util.List;

public class GetReportScheduleListByNextTokenSample {
    public static void main(String ... args) {
        String accessKeyId = "<Your Access Key ID>";
        String secretAccessKey = "<Your Secret Access Key>";
        String appName = "<Your Application or Company Name>";
        String appVersion = "<Your Application Version or Build Number or Release Date>";
        MarketplaceWebServiceConfig config = new MarketplaceWebServiceConfig();
        MarketplaceWebServiceClient service = new MarketplaceWebServiceClient("<Your Access Key ID>", "<Your Secret Access Key>", "<Your Application or Company Name>", "<Your Application Version or Build Number or Release Date>", config);
        String merchantId = "<Your Merchant ID>";
        String sellerDevAuthToken = "<Merchant Developer MWS Auth Token>";
        GetReportScheduleListByNextTokenRequest request = new GetReportScheduleListByNextTokenRequest();
        request.setMerchant("<Your Merchant ID>");
    }

    public static void invokeGetReportScheduleListByNextToken(MarketplaceWebService service, GetReportScheduleListByNextTokenRequest request) {
        try {
            GetReportScheduleListByNextTokenResponse response = service.getReportScheduleListByNextToken(request);
            System.out.println("GetReportScheduleListByNextToken Action Response");
            System.out.println("=============================================================================");
            System.out.println();
            System.out.print("    GetReportScheduleListByNextTokenResponse");
            System.out.println();
            if (response.isSetGetReportScheduleListByNextTokenResult()) {
                System.out.print("        GetReportScheduleListByNextTokenResult");
                System.out.println();
                GetReportScheduleListByNextTokenResult getReportScheduleListByNextTokenResult = response.getGetReportScheduleListByNextTokenResult();
                if (getReportScheduleListByNextTokenResult.isSetNextToken()) {
                    System.out.print("            NextToken");
                    System.out.println();
                    System.out.print("                " + getReportScheduleListByNextTokenResult.getNextToken());
                    System.out.println();
                }
                if (getReportScheduleListByNextTokenResult.isSetHasNext()) {
                    System.out.print("            HasNext");
                    System.out.println();
                    System.out.print("                " + getReportScheduleListByNextTokenResult.isHasNext());
                    System.out.println();
                }
                List<ReportSchedule> reportScheduleList = getReportScheduleListByNextTokenResult.getReportScheduleList();
                for (ReportSchedule reportSchedule : reportScheduleList) {
                    System.out.print("            ReportSchedule");
                    System.out.println();
                    if (reportSchedule.isSetReportType()) {
                        System.out.print("                ReportType");
                        System.out.println();
                        System.out.print("                    " + reportSchedule.getReportType());
                        System.out.println();
                    }
                    if (reportSchedule.isSetSchedule()) {
                        System.out.print("                Schedule");
                        System.out.println();
                        System.out.print("                    " + reportSchedule.getSchedule());
                        System.out.println();
                    }
                    if (!reportSchedule.isSetScheduledDate()) continue;
                    System.out.print("                ScheduledDate");
                    System.out.println();
                    System.out.print("                    " + reportSchedule.getScheduledDate());
                    System.out.println();
                }
            }
            if (response.isSetResponseMetadata()) {
                System.out.print("        ResponseMetadata");
                System.out.println();
                ResponseMetadata responseMetadata = response.getResponseMetadata();
                if (responseMetadata.isSetRequestId()) {
                    System.out.print("            RequestId");
                    System.out.println();
                    System.out.print("                " + responseMetadata.getRequestId());
                    System.out.println();
                }
            }
            System.out.println();
            System.out.println(response.getResponseHeaderMetadata());
            System.out.println();
        }
        catch (MarketplaceWebServiceException ex) {
            System.out.println("Caught Exception: " + ex.getMessage());
            System.out.println("Response Status Code: " + ex.getStatusCode());
            System.out.println("Error Code: " + ex.getErrorCode());
            System.out.println("Error Type: " + ex.getErrorType());
            System.out.println("Request ID: " + ex.getRequestId());
            System.out.print("XML: " + ex.getXML());
            System.out.println("ResponseHeaderMetadata: " + ex.getResponseHeaderMetadata());
        }
    }
}

