/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mws.samples;

import com.amazonaws.mws.MarketplaceWebService;
import com.amazonaws.mws.MarketplaceWebServiceClient;
import com.amazonaws.mws.MarketplaceWebServiceConfig;
import com.amazonaws.mws.MarketplaceWebServiceException;
import com.amazonaws.mws.model.RequestReportRequest;
import com.amazonaws.mws.model.RequestReportResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestReportAsyncSample {
    public static void main(String ... args) {
        String accessKeyId = "<Your Access Key ID>";
        String secretAccessKey = "<Your Secret Access Key>";
        String appName = "<Your Application or Company Name>";
        String appVersion = "<Your Application Version or Build Number or Release Date>";
        MarketplaceWebServiceConfig config = new MarketplaceWebServiceConfig();
        config.setMaxAsyncThreads(35);
        MarketplaceWebServiceClient service = new MarketplaceWebServiceClient("<Your Access Key ID>", "<Your Secret Access Key>", "<Your Application or Company Name>", "<Your Application Version or Build Number or Release Date>", config);
        String marketplaceId = "<Your Marketplace ID>";
        String merchantId = "<Your Merchant ID>";
        String sellerDevAuthToken = "<Merchant Developer MWS Auth Token>";
        RequestReportRequest requestOne = new RequestReportRequest();
        requestOne.setMerchant("<Your Merchant ID>");
        RequestReportRequest requestTwo = new RequestReportRequest();
        requestTwo.setMerchant("<Your Merchant ID>");
        ArrayList<RequestReportRequest> requests = new ArrayList<RequestReportRequest>();
        requests.add(requestOne);
        requests.add(requestTwo);
    }

    public static void invokeRequestReport(MarketplaceWebService service, List<RequestReportRequest> requests) {
        ArrayList<Future<RequestReportResponse>> responses = new ArrayList<Future<RequestReportResponse>>();
        for (RequestReportRequest requestReportRequest : requests) {
            responses.add(service.requestReportAsync(requestReportRequest));
        }
        for (Future future : responses) {
            while (!future.isDone()) {
                Thread.yield();
            }
            try {
                RequestReportResponse response = (RequestReportResponse)future.get();
                RequestReportRequest originalRequest = requests.get(responses.indexOf(future));
                System.out.println("Response request id: " + response.getResponseMetadata().getRequestId());
                System.out.println(response.getResponseHeaderMetadata());
                System.out.println();
            }
            catch (Exception e) {
                if (e.getCause() instanceof MarketplaceWebServiceException) {
                    MarketplaceWebServiceException exception = (MarketplaceWebServiceException)MarketplaceWebServiceException.class.cast(e.getCause());
                    System.out.println("Caught Exception: " + exception.getMessage());
                    System.out.println("Response Status Code: " + exception.getStatusCode());
                    System.out.println("Error Code: " + exception.getErrorCode());
                    System.out.println("Error Type: " + exception.getErrorType());
                    System.out.println("Request ID: " + exception.getRequestId());
                    System.out.print("XML: " + exception.getXML());
                    System.out.println("ResponseHeaderMetadata: " + exception.getResponseHeaderMetadata());
                    continue;
                }
                e.printStackTrace();
            }
        }
    }
}

