/*
 * Decompiled with CFR 0.152.
 */
package pnp.paypal.api;

import com.paypal.svcs.services.PermissionsService;
import com.paypal.svcs.types.common.RequestEnvelope;
import com.paypal.svcs.types.perm.GetAccessTokenRequest;
import com.paypal.svcs.types.perm.GetAccessTokenResponse;
import com.paypal.svcs.types.perm.RequestPermissionsRequest;
import com.paypal.svcs.types.perm.RequestPermissionsResponse;
import java.awt.Desktop;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.JOptionPane;
import pnp.services.authenticationmanager.SubscriptionManager;
import pnp.services.datatypes.PaypalDetails;
import pnp.services.datatypes.webservices.PaypalAccountTemp;
import pnp.services.listener.GenericListener;
import pnp.services.listenermanager.ListenerManager;
import pnp.services.preferencemanager.Preferences;
import pnp.services.util.ErrorsUtil;
import pnp.services.util.LookupServicesUtil;
import urn.ebay.api.PayPalAPI.GetTransactionDetailsReq;
import urn.ebay.api.PayPalAPI.GetTransactionDetailsRequestType;
import urn.ebay.api.PayPalAPI.GetTransactionDetailsResponseType;
import urn.ebay.api.PayPalAPI.PayPalAPIInterfaceServiceService;
import urn.ebay.api.PayPalAPI.TransactionSearchReq;
import urn.ebay.api.PayPalAPI.TransactionSearchRequestType;
import urn.ebay.api.PayPalAPI.TransactionSearchResponseType;
import urn.ebay.apis.eBLBaseComponents.AckCodeType;
import urn.ebay.apis.eBLBaseComponents.PaymentTransactionSearchResultType;

public class PaypalConnectionManager {
    private Properties keys;
    private static PaypalConnectionManager _instance;
    private String requestToken;
    private String callbackURL;
    private String redirectURL;
    private List<String> scope;
    private RequestEnvelope env;
    private ArrayList<PaypalDetails> paypalTransactions;
    private int itemNumber;
    private int projectedItems;
    PayPalAPIInterfaceServiceService APIservice;
    PermissionsService permissionService;
    private boolean updatePending = false;
    private Set<Date> datesLost = new HashSet<Date>();

    private PaypalConnectionManager() {
        this.keys = new Properties();
        this.createPropertiesFile();
        this.scope = new ArrayList<String>();
        this.itemNumber = 0;
        this.projectedItems = 0;
        this.requestToken = "";
        this.callbackURL = "http://www.handsupsolutions.com/gamut/paypal";
        this.redirectURL = "https://www.paypal.com/webscr&cmd=_grant-permission&request_token=";
        this.scope.add("TRANSACTION_SEARCH");
        this.scope.add("TRANSACTION_DETAILS");
        this.env = new RequestEnvelope();
        this.env.setErrorLanguage("en_US");
        this.paypalTransactions = new ArrayList();
    }

    public static PaypalConnectionManager getInstance() {
        if (null == _instance) {
            _instance = new PaypalConnectionManager();
        }
        return _instance;
    }

    private void createPropertiesFile() {
        this.keys.setProperty("acct1.UserName", "handsupsolutions_api1.gmail.com");
        this.keys.setProperty("acct1.Password", "YT7C4Z55453U26KT");
        this.keys.setProperty("acct1.Signature", "AB-Ut1riTOmjiwuWaFPEOW3oY2huAcwKoYuhUJkyv4vNC97E8ro0dqnc");
        this.keys.setProperty("acct1.AppId", "APP-5AP05869HM406391H");
        this.keys.setProperty("http.ConnectionTimeOut", "5000");
        this.keys.setProperty("http.Retry", "2");
        this.keys.setProperty("http.ReadTimeOut", "30000");
        this.keys.setProperty("http.MaxConnection", "100");
        this.keys.setProperty("http.IPAddress", "127.0.0.7");
        this.keys.setProperty("http.UseProxy", "false");
        this.keys.setProperty("http.ProxyPort", "8080");
        this.keys.setProperty("http.ProxyHost", "127.0.0.1");
        this.keys.setProperty("http.ProxyUserName", "null");
        this.keys.setProperty("http.ProxyPassword", "null");
        this.keys.setProperty("http.GoogleAppEngine", "false");
        this.keys.setProperty("mode", "live");
        this.keys.setProperty("service.RedirectURL", "https://www.paypal.com/webscr&cmd=");
        this.keys.setProperty("service.DevCentralURL", "https://developer.paypal.com");
    }

    public void getRequestToken() {
        try {
            RequestPermissionsRequest permRequest = new RequestPermissionsRequest(this.scope, this.callbackURL);
            permRequest.setRequestEnvelope(this.env);
            this.permissionService = new PermissionsService(this.keys);
            RequestPermissionsResponse resp = this.permissionService.requestPermissions(permRequest);
            if (resp != null && resp.getResponseEnvelope().getAck().toString().equalsIgnoreCase("SUCCESS")) {
                this.requestToken = resp.getToken();
                LookupServicesUtil.getAuthenticationManagerServices().communicate("addAccessID", this.requestToken, null, null);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public String getVerificationToken() {
        String verification = "";
        try {
            URI uri = new URI(this.redirectURL + this.requestToken);
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(uri);
            JOptionPane.showMessageDialog(null, "Please grant us access to your account, press 'OK' when finished!");
            for (int i = 0; i < 3 && (null == verification || verification.isEmpty()); ++i) {
                String title;
                String message;
                int reply;
                Thread.sleep(5000L);
                Object verificationArray = LookupServicesUtil.getAuthenticationManagerServices().communicate("getSecret", null, null, null);
                verification = (String)((ArrayList)verificationArray).get(1);
                if (2 != i || null != verification && !verification.isEmpty() || (reply = JOptionPane.showConfirmDialog(null, message = "Verification is taking longer than expect or has failed. To wait another 15 seconds press Yes. To abort, press No.", title = "Verification Failure", 0)) != 0) continue;
                i = 0;
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return verification;
    }

    public void getAccessToken(String accountID) {
        try {
            GetAccessTokenRequest request = new GetAccessTokenRequest();
            request.setRequestEnvelope(this.env);
            request.setToken(this.requestToken);
            request.setVerifier(this.getVerificationToken());
            if (null != request.getVerifier() && !request.getVerifier().isEmpty()) {
                GetAccessTokenResponse response = this.permissionService.getAccessToken(request);
                String accessToken = response.getToken();
                String tokenSecret = response.getTokenSecret();
                LookupServicesUtil.getAuthenticationManagerServices().communicate("addSecret", null, null, null);
                PaypalAccountTemp account = new PaypalAccountTemp(accessToken, tokenSecret, accountID);
                if (SubscriptionManager.getInstance().createPaypalAccount(account)) {
                    LookupServicesUtil.getAuthenticationManagerServices().communicate("createPaypalAccount", accountID, accessToken, tokenSecret);
                    JOptionPane.showMessageDialog(null, "Account creation successful");
                }
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public boolean getPermissions(String accountID) {
        if (!this.doAdministrator(accountID)) {
            if (SubscriptionManager.getInstance().getPaypalAccounts().isEmpty() || SubscriptionManager.getInstance().isMultiActive()) {
                this.getRequestToken();
                this.getAccessToken(accountID);
            } else {
                JOptionPane.showMessageDialog(null, "You are already linked to a paypal account.\nYou may either delete that account or purchase Multi User status to have multiple accounts.");
                return false;
            }
        }
        return true;
    }

    private boolean doAdministrator(String accountID) {
        if (SubscriptionManager.getInstance().getUserName().equals("admin") && accountID != null && accountID.equalsIgnoreCase("HandsUpSolutions")) {
            PaypalAccountTemp account = new PaypalAccountTemp("", "", accountID);
            if (SubscriptionManager.getInstance().createPaypalAccount(account)) {
                LookupServicesUtil.getAuthenticationManagerServices().communicate("createPaypalAccount", accountID, "", "");
                JOptionPane.showMessageDialog(null, "Account creation successful");
                return true;
            }
        }
        return false;
    }

    public void showDatesLost() {
        boolean showMessage = false;
        String message = "Some transactions have failed to pull in, below are the times of suspected losses:\n";
        for (Date date : this.datesLost) {
            showMessage = true;
            message = message + "[" + date.toString() + "] TO [";
            date.setMinutes(date.getMinutes() - 30);
            message = message + date.toString() + "]\n";
        }
        if (showMessage) {
            JOptionPane.showMessageDialog(null, message);
        }
        this.datesLost.clear();
    }

    public void addDetails() {
        for (PaypalDetails newDetails : this.paypalTransactions) {
            try {
                if (newDetails.getPaypalTransactionID().isEmpty()) continue;
                LookupServicesUtil.getDBServices().setPaypalDetails(newDetails);
            }
            catch (Exception ex) {
                ErrorsUtil.getInstance().logError(ex);
            }
        }
        this.showDatesLost();
    }

    public String reconvertDate(String date, String originalStartDate) {
        Date dateToParse = null;
        Date originDate = null;
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat hourFormat = new SimpleDateFormat("HH:mm:ss");
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-ddHH:mm:ss");
            date = date.replace("T", "").replace("Z", "");
            String originDateString = originalStartDate.replace("T", "").replace("Z", "");
            dateToParse = format.parse(date);
            this.datesLost.add(dateToParse);
            dateToParse.setMinutes(dateToParse.getMinutes() - 30);
            originDate = format.parse(originDateString);
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        if (originDate == null) {
            JOptionPane.showMessageDialog(null, "The update failed unexpectedly. Please try again.");
            return originalStartDate;
        }
        if (dateToParse == null || dateToParse.before(originDate)) {
            dateToParse = originDate;
        }
        return dayFormat.format(dateToParse) + "T" + hourFormat.format(dateToParse) + "Z";
    }

    public void transactionSearch(final String startDate, final String endDate) {
        this.datesLost.clear();
        this.paypalTransactions.clear();
        if (!SubscriptionManager.getInstance().getPaypalAccounts().isEmpty()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean doLastUpdate = true;
                    for (PaypalAccountTemp account : SubscriptionManager.getInstance().getPaypalAccounts()) {
                        String newStartDate = startDate;
                        String newEndDate = endDate;
                        PaypalConnectionManager.this.updatePending = true;
                        PaypalConnectionManager.this.projectedItems = 0;
                        PaypalConnectionManager.this.itemNumber = 0;
                        PaypalConnectionManager.this.APIservice = new PayPalAPIInterfaceServiceService(PaypalConnectionManager.this.keys);
                        PaypalConnectionManager.this.APIservice.setAccessToken(account.getAccessToken());
                        PaypalConnectionManager.this.APIservice.setTokenSecret(account.getTokenSecret());
                        try {
                            do {
                                boolean success = PaypalConnectionManager.this.allTransactions(newStartDate, newEndDate, account.getAccountID());
                                if (!PaypalConnectionManager.this.paypalTransactions.isEmpty()) {
                                    String newDate = "";
                                    for (int i = PaypalConnectionManager.this.paypalTransactions.size() - 1; i >= 0 && newDate.isEmpty(); --i) {
                                        newDate = ((PaypalDetails)PaypalConnectionManager.this.paypalTransactions.get(i)).getPaymentDate();
                                    }
                                    if (!newDate.isEmpty()) {
                                        if (newEndDate.equals(newDate)) {
                                            if (success) {
                                                newEndDate = newStartDate;
                                                continue;
                                            }
                                            if (newEndDate.equals(newStartDate)) continue;
                                            newEndDate = PaypalConnectionManager.this.reconvertDate(newDate, newStartDate);
                                            continue;
                                        }
                                        newEndDate = newDate;
                                        continue;
                                    }
                                    newEndDate = newStartDate;
                                    doLastUpdate = false;
                                    continue;
                                }
                                newEndDate = newStartDate;
                            } while (!newEndDate.equals(newStartDate));
                        }
                        catch (Exception ex) {
                            ErrorsUtil.getInstance().logError(ex);
                        }
                    }
                    PaypalConnectionManager.this.addDetails();
                    if (doLastUpdate) {
                        Calendar endTime = Calendar.getInstance();
                        endTime.setTimeInMillis(System.currentTimeMillis());
                        Preferences.getInstance().getAccountPreferences().setPaypalLastUpdate(endTime.getTimeInMillis() - 60000L);
                        Preferences.getInstance().updateAccountPreferences();
                    } else {
                        JOptionPane.showMessageDialog(null, "PayPal did not retrieve transactions correctly - Last update will not be moved forward.");
                    }
                    PaypalConnectionManager.this.paypalTransactions.clear();
                    PaypalConnectionManager.this.updatePending = false;
                    ListenerManager.getInstance().notify((GenericListener)ListenerManager.PAYPAL_PROGRESS_LISTENER);
                }
            }).start();
        } else {
            this.updatePending = false;
            ListenerManager.getInstance().notify((GenericListener)ListenerManager.PAYPAL_PROGRESS_LISTENER);
            Preferences.getInstance().openTab(Preferences.Index.Paypal);
        }
    }

    public boolean allTransactions(String startDate, String endDate, String accountName) {
        try {
            TransactionSearchReq newRequest = new TransactionSearchReq();
            TransactionSearchRequestType requestType = new TransactionSearchRequestType();
            requestType.setStartDate(startDate);
            requestType.setEndDate(endDate);
            newRequest.setTransactionSearchRequest(requestType);
            TransactionSearchResponseType newResponse = this.APIservice.transactionSearch(newRequest);
            if (newResponse != null) {
                if (newResponse.getPaymentTransactions().size() > 0) {
                    Iterator iterator = newResponse.getPaymentTransactions().iterator();
                    this.projectedItems += newResponse.getPaymentTransactions().size();
                    while (iterator.hasNext()) {
                        PaymentTransactionSearchResultType result = (PaymentTransactionSearchResultType)iterator.next();
                        ++this.itemNumber;
                        this.transactionDetailsLookup(result.getTransactionID(), accountName);
                    }
                }
                return !newResponse.getAck().equals((Object)AckCodeType.FAILURE) && !newResponse.getAck().equals((Object)AckCodeType.FAILUREWITHWARNING);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
        return false;
    }

    public void transactionDetailsLookup(String transactionID, String accountName) {
        try {
            GetTransactionDetailsReq req = new GetTransactionDetailsReq();
            GetTransactionDetailsRequestType reqType = new GetTransactionDetailsRequestType();
            reqType.setTransactionID(transactionID);
            req.setGetTransactionDetailsRequest(reqType);
            GetTransactionDetailsResponseType resp = this.APIservice.getTransactionDetails(req);
            if (resp != null && resp.getPaymentTransactionDetails() != null && resp.getPaymentTransactionDetails().getPayerInfo() != null && resp.getPaymentTransactionDetails().getPaymentInfo() != null && resp.getPaymentTransactionDetails().getPaymentItemInfo() != null) {
                PaypalDetails newDetails = new PaypalDetails(resp.getPaymentTransactionDetails().getPayerInfo(), resp.getPaymentTransactionDetails().getPaymentInfo(), resp.getPaymentTransactionDetails().getPaymentItemInfo(), accountName);
                this.paypalTransactions.add(newDetails);
                ListenerManager.getInstance().notify((GenericListener)ListenerManager.PAYPAL_PROGRESS_LISTENER);
            }
        }
        catch (Exception ex) {
            ErrorsUtil.getInstance().logError(ex);
        }
    }

    public void findSpecificTransaction(String transactionID, String accountName) {
        for (PaypalAccountTemp account : SubscriptionManager.getInstance().getPaypalAccounts()) {
            this.APIservice = new PayPalAPIInterfaceServiceService(this.keys);
            this.APIservice.setAccessToken(account.getAccessToken());
            this.APIservice.setTokenSecret(account.getTokenSecret());
            this.transactionDetailsLookup(transactionID, accountName);
        }
    }

    public int getItemNumber() {
        return this.itemNumber;
    }

    public int getProjectedItems() {
        return this.projectedItems;
    }

    public int[] getItemsProjected() {
        int[] projection = new int[]{this.getItemNumber(), this.getProjectedItems()};
        return projection;
    }

    public boolean isUpdatePending() {
        return this.updatePending;
    }
}

