/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import com.paypal.sdk.util.ResourceLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigManager {
    private static ConfigManager conf;
    private Properties properties;
    private boolean propertyLoaded = false;
    private Map<String, String> mapView = null;
    private static Map<String, String> defaultMapView;
    private static final Properties DEFAULT_PROPERTIES;

    private ConfigManager() {
        ResourceLoader resourceLoader = new ResourceLoader("sdk_config.properties");
        try {
            InputStream inputStream = resourceLoader.getInputStream();
            this.properties = new Properties();
            this.properties.load(inputStream);
            this.setPropertyLoaded(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigManager getInstance() {
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (conf == null) {
                conf = new ConfigManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return conf;
        }
    }

    public static Properties getDefaultProperties() {
        return DEFAULT_PROPERTIES;
    }

    public static Map<String, String> getDefaultSDKMap() {
        return new HashMap<String, String>(defaultMapView);
    }

    public static Properties combineDefaultProperties(Properties receivedProperties) {
        Properties combinedProperties = new Properties(ConfigManager.getDefaultProperties());
        if (receivedProperties != null && receivedProperties.size() > 0) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            try {
                receivedProperties.store(bos, null);
                combinedProperties.load(new ByteArrayInputStream(bos.toByteArray()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return combinedProperties;
    }

    public void load(InputStream is) throws IOException {
        this.properties = new Properties();
        this.properties.load(is);
        if (!this.propertyLoaded) {
            this.setPropertyLoaded(true);
        }
    }

    public void load(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Initialization properties cannot be null");
        }
        this.properties = properties;
        if (!this.propertyLoaded) {
            this.setPropertyLoaded(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getConfigurationMap() {
        if (this.mapView == null) {
            Properties properties = DEFAULT_PROPERTIES;
            synchronized (properties) {
                this.mapView = new HashMap<String, String>();
                if (this.properties != null) {
                    for (Object object : this.properties.keySet()) {
                        this.mapView.put(object.toString().trim(), this.properties.getProperty(object.toString()).trim());
                    }
                }
            }
        }
        return new HashMap<String, String>(this.mapView);
    }

    public String getValue(String key) {
        return this.properties.getProperty(key);
    }

    public String getValueWithDefault(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public Map<String, String> getValuesByCategory(String category) {
        String key = "";
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object obj : this.properties.keySet()) {
            key = (String)obj;
            if (!key.contains(category)) continue;
            map.put(key, this.properties.getProperty(key));
        }
        return map;
    }

    public Set<String> getNumOfAcct() {
        String key = "";
        HashSet<String> set = new HashSet<String>();
        for (Object obj : this.properties.keySet()) {
            key = (String)obj;
            if (!key.contains("acct")) continue;
            int pos = key.indexOf(46);
            String acct = key.substring(0, pos);
            set.add(acct);
        }
        return set;
    }

    public boolean isPropertyLoaded() {
        return this.propertyLoaded;
    }

    private void setPropertyLoaded(boolean propertyLoaded) {
        this.propertyLoaded = propertyLoaded;
    }

    static {
        defaultMapView = null;
        DEFAULT_PROPERTIES = new Properties();
        DEFAULT_PROPERTIES.put("http.ConnectionTimeOut", "5000");
        DEFAULT_PROPERTIES.put("http.Retry", "2");
        DEFAULT_PROPERTIES.put("http.ReadTimeOut", "30000");
        DEFAULT_PROPERTIES.put("http.MaxConnection", "100");
        DEFAULT_PROPERTIES.put("http.IPAddress", "127.0.0.1");
        DEFAULT_PROPERTIES.put("http.GoogleAppEngine", "false");
        defaultMapView = new HashMap<String, String>();
        for (Object object : DEFAULT_PROPERTIES.keySet()) {
            defaultMapView.put(object.toString().trim(), DEFAULT_PROPERTIES.getProperty(object.toString()).trim());
        }
    }
}

