/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import com.paypal.core.APICallPreHandler;
import com.paypal.core.credential.ICredential;
import com.paypal.exception.ClientActionRequiredException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSOAPAPICallHandler
implements APICallPreHandler {
    private static final String SOAP_ENV_START = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" {0}>";
    private static final String SOAP_ENV_END = "</soapenv:Envelope>";
    private static final String SOAP_HEAD_START = "<soapenv:Header>{1}";
    private static final String SOAP_HEAD_END = "</soapenv:Header>";
    private static final String SOAP_BODY_START = "<soapenv:Body>{2}";
    private static final String SOAP_BODY_END = "</soapenv:Body>";
    private String rawPayLoad;
    private String headerString;
    private String namespaces;
    private Map<String, String> configurationMap = null;

    public String getHeaderString() {
        return this.headerString;
    }

    public void setHeaderString(String headerString) {
        this.headerString = headerString;
    }

    public String getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(String namespaces) {
        this.namespaces = namespaces;
    }

    public DefaultSOAPAPICallHandler(String rawPayLoad, String namespaces, String headerString) {
        this.rawPayLoad = rawPayLoad;
        this.namespaces = namespaces;
        this.headerString = headerString;
    }

    public DefaultSOAPAPICallHandler(String rawPayLoad, String namespaces, String headerString, Map<String, String> configurationMap) {
        this.rawPayLoad = rawPayLoad;
        this.namespaces = namespaces;
        this.headerString = headerString;
        this.configurationMap = configurationMap;
    }

    @Override
    public Map<String, String> getHeaderMap() {
        return new HashMap<String, String>();
    }

    @Override
    public String getPayLoad() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getSoapEnvelopeStart());
        stringBuilder.append(this.getSoapHeaderStart());
        stringBuilder.append(this.getSoapHeaderEnd());
        stringBuilder.append(this.getSoapBodyStart());
        stringBuilder.append(this.getSoapBodyEnd());
        stringBuilder.append(this.getSoapEnvelopeEnd());
        return stringBuilder.toString();
    }

    @Override
    public String getEndPoint() {
        return this.configurationMap.get("service.EndPoint");
    }

    @Override
    public ICredential getCredential() {
        return null;
    }

    @Override
    public void validate() throws ClientActionRequiredException {
    }

    private String getSoapEnvelopeStart() {
        String envelope = null;
        envelope = this.namespaces != null ? MessageFormat.format(SOAP_ENV_START, this.namespaces) : SOAP_ENV_START;
        return envelope;
    }

    private String getSoapEnvelopeEnd() {
        return SOAP_ENV_END;
    }

    private String getSoapHeaderStart() {
        String header = null;
        header = this.headerString != null ? MessageFormat.format(SOAP_HEAD_START, null, this.headerString) : SOAP_HEAD_START;
        return header;
    }

    private String getSoapHeaderEnd() {
        return SOAP_HEAD_END;
    }

    private String getSoapBodyStart() {
        String body = null;
        body = this.rawPayLoad != null ? MessageFormat.format(SOAP_BODY_START, null, null, this.rawPayLoad) : SOAP_BODY_START;
        return body;
    }

    private String getSoapBodyEnd() {
        return SOAP_BODY_END;
    }
}

