/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.rest;

import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIContext {
    private String accessToken;
    private String requestId;
    private Map<String, String> configurationMap;

    public APIContext() {
    }

    public APIContext(String accessToken) {
        if (accessToken == null || accessToken.length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null");
        }
        this.accessToken = accessToken;
    }

    public APIContext(String accessToken, String requestId) {
        this(accessToken);
        if (requestId == null || requestId.length() <= 0) {
            throw new IllegalArgumentException("RequestId cannot be null");
        }
        this.requestId = requestId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRequestId() {
        if (this.requestId == null || this.requestId.length() <= 0) {
            this.requestId = UUID.randomUUID().toString();
        }
        return this.requestId;
    }

    public Map<String, String> getConfigurationMap() {
        return this.configurationMap;
    }

    public void setConfigurationMap(Map<String, String> configurationMap) {
        this.configurationMap = configurationMap;
    }
}

