/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.paypal.core.ConfigManager;
import com.paypal.core.ConnectionManager;
import com.paypal.core.HttpConfiguration;
import com.paypal.core.HttpConnection;
import com.paypal.core.SDKUtil;
import com.paypal.core.credential.ICredential;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.RESTConfiguration;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OAuthTokenCredential
implements ICredential {
    private static final String OAUTH_TOKEN_PATH = "/v1/oauth2/token";
    private String clientID;
    private String clientSecret;
    private String accessToken;
    private Map<String, String> configurationMap;

    public OAuthTokenCredential(String clientID, String clientSecret) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.configurationMap = SDKUtil.combineDefaultMap(ConfigManager.getInstance().getConfigurationMap());
    }

    public OAuthTokenCredential(String clientID, String clientSecret, Map<String, String> configurationMap) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.configurationMap = SDKUtil.combineDefaultMap(configurationMap);
    }

    public String getAccessToken() throws PayPalRESTException {
        if (this.accessToken == null) {
            this.accessToken = this.generateAccessToken();
        }
        return this.accessToken;
    }

    private String generateAccessToken() throws PayPalRESTException {
        String generatedToken = null;
        String base64ClientID = this.generateBase64String(this.clientID + ":" + this.clientSecret);
        generatedToken = this.generateOAuthToken(base64ClientID);
        return generatedToken;
    }

    private String generateBase64String(String clientID) throws PayPalRESTException {
        String base64ClientID = null;
        byte[] encoded = null;
        try {
            encoded = Base64.encodeBase64((byte[])clientID.getBytes("UTF-8"));
            base64ClientID = new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return base64ClientID;
    }

    private String generateOAuthToken(String base64ClientID) throws PayPalRESTException {
        HttpConnection connection = null;
        HttpConfiguration httpConfiguration = null;
        String generatedToken = null;
        try {
            connection = ConnectionManager.getInstance().getConnection();
            httpConfiguration = this.getOAuthHttpConfiguration();
            connection.createAndconfigureHttpConnection(httpConfiguration);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + base64ClientID);
            headers.put("Accept", "*/*");
            headers.put("User-Agent", RESTConfiguration.formUserAgentHeader());
            String postRequest = "grant_type=client_credentials";
            String jsonResponse = connection.execute("", postRequest, headers);
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse(jsonResponse);
            generatedToken = jsonElement.getAsJsonObject().get("token_type").getAsString() + " " + jsonElement.getAsJsonObject().get("access_token").getAsString();
        }
        catch (Exception e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return generatedToken;
    }

    private HttpConfiguration getOAuthHttpConfiguration() {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setHttpMethod("POST");
        String endPointUrl = this.configurationMap.get("service.EndPoint");
        if (endPointUrl == null || endPointUrl.trim().length() <= 0) {
            String mode = this.configurationMap.get("mode");
            if ("sandbox".equalsIgnoreCase(mode)) {
                endPointUrl = "https://api.sandbox.paypal.com/";
            } else if ("live".equalsIgnoreCase(mode)) {
                endPointUrl = "https://api.paypal.com/";
            }
        }
        endPointUrl = endPointUrl.endsWith("/") ? endPointUrl.substring(0, endPointUrl.length() - 1) : endPointUrl;
        endPointUrl = endPointUrl + OAUTH_TOKEN_PATH;
        httpConfiguration.setEndPointUrl(endPointUrl);
        httpConfiguration.setGoogleAppEngine(Boolean.parseBoolean(this.configurationMap.get("http.GoogleAppEngine")));
        return httpConfiguration;
    }
}

