/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.rest;

import com.paypal.core.ConfigManager;
import com.paypal.core.ConnectionManager;
import com.paypal.core.HttpConfiguration;
import com.paypal.core.HttpConnection;
import com.paypal.core.LoggingManager;
import com.paypal.core.SDKUtil;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.RESTConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PayPalResource {
    public static final String SDK_ID = "rest-sdk-java";
    public static final String SDK_VERSION = "0.6.0";
    private static Map<String, String> configurationMap;
    private static boolean configInitialized;
    private static final ThreadLocal<String> LASTREQUEST;
    private static final ThreadLocal<String> LASTRESPONSE;

    public static void initConfig(InputStream inputStream) throws PayPalRESTException {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            configurationMap = SDKUtil.constructMap(properties);
            configInitialized = true;
        }
        catch (IOException ioe) {
            LoggingManager.severe(PayPalResource.class, ioe.getMessage(), ioe);
            throw new PayPalRESTException(ioe.getMessage(), ioe);
        }
    }

    public static void initConfig(File file) throws PayPalRESTException {
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("File doesn't exist: " + file.getAbsolutePath());
            }
            FileInputStream fis = new FileInputStream(file);
            PayPalResource.initConfig(fis);
        }
        catch (IOException ioe) {
            LoggingManager.severe(PayPalResource.class, ioe.getMessage(), ioe);
            throw new PayPalRESTException(ioe.getMessage(), ioe);
        }
    }

    public static void initConfig(Properties properties) {
        configurationMap = SDKUtil.constructMap(properties);
        configInitialized = true;
    }

    private static void initializeToDefault() throws PayPalRESTException {
        configurationMap = SDKUtil.combineDefaultMap(ConfigManager.getInstance().getConfigurationMap());
    }

    public static String getLastRequest() {
        return LASTREQUEST.get();
    }

    public static String getLastResponse() {
        return LASTRESPONSE.get();
    }

    public static <T> T configureAndExecute(String accessToken, HttpMethod httpMethod, String resourcePath, String payLoad, Class<T> clazz) throws PayPalRESTException {
        return PayPalResource.configureAndExecute(null, accessToken, httpMethod, resourcePath, null, payLoad, null, clazz);
    }

    public static <T> T configureAndExecute(APIContext apiContext, HttpMethod httpMethod, String resourcePath, String payLoad, Class<T> clazz) throws PayPalRESTException {
        Map<String, String> cMap = null;
        String accessToken = null;
        String requestId = null;
        if (apiContext != null) {
            cMap = apiContext.getConfigurationMap();
            accessToken = apiContext.getAccessToken();
            requestId = apiContext.getRequestId();
        }
        return PayPalResource.configureAndExecute(cMap, accessToken, httpMethod, resourcePath, null, payLoad, requestId, clazz);
    }

    public static <T> T configureAndExecute(APIContext apiContext, HttpMethod httpMethod, String resourcePath, Map<String, String> headersMap, String payLoad, Class<T> clazz) throws PayPalRESTException {
        Map<String, String> cMap = null;
        if (apiContext != null) {
            cMap = apiContext.getConfigurationMap();
        }
        return PayPalResource.configureAndExecute(cMap, null, httpMethod, resourcePath, headersMap, payLoad, null, clazz);
    }

    private static <T> T configureAndExecute(Map<String, String> configurationMap, String accessToken, HttpMethod httpMethod, String resourcePath, Map<String, String> headersMap, String payLoad, String requestId, Class<T> clazz) throws PayPalRESTException {
        T t = null;
        Map<String, String> cMap = null;
        if (configurationMap != null) {
            cMap = SDKUtil.combineDefaultMap(configurationMap);
        } else {
            if (!configInitialized) {
                PayPalResource.initializeToDefault();
            }
            cMap = new HashMap<String, String>(PayPalResource.configurationMap);
        }
        RESTConfiguration restConfiguration = PayPalResource.createRESTConfiguration(cMap, httpMethod, resourcePath, headersMap, accessToken, requestId);
        t = PayPalResource.execute(restConfiguration, payLoad, resourcePath, clazz);
        return t;
    }

    private static RESTConfiguration createRESTConfiguration(Map<String, String> configurationMap, HttpMethod httpMethod, String resourcePath, Map<String, String> headersMap, String accessToken, String requestId) {
        RESTConfiguration restConfiguration = new RESTConfiguration(configurationMap, headersMap);
        restConfiguration.setHttpMethod(httpMethod);
        restConfiguration.setResourcePath(resourcePath);
        restConfiguration.setRequestId(requestId);
        restConfiguration.setAuthorizationToken(accessToken);
        return restConfiguration;
    }

    private static <T> T execute(RESTConfiguration restConfiguration, String payLoad, String resourcePath, Class<T> clazz) throws PayPalRESTException {
        T t = null;
        try {
            Map<String, String> headers = restConfiguration.getHeaders();
            HttpConfiguration httpConfig = restConfiguration.getHttpConfigurations();
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            HttpConnection httpConnection = connectionManager.getConnection(httpConfig);
            httpConnection.createAndconfigureHttpConnection(httpConfig);
            LASTREQUEST.set(payLoad);
            String responseString = httpConnection.execute(restConfiguration.getBaseURL().toURI().resolve(resourcePath).toString(), payLoad, headers);
            LASTRESPONSE.set(responseString);
            t = JSONFormatter.fromJSON(responseString, clazz);
        }
        catch (Exception e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return t;
    }

    static {
        configInitialized = false;
        LASTREQUEST = new ThreadLocal();
        LASTRESPONSE = new ThreadLocal();
    }
}

