/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.rest;

import com.paypal.core.HttpConfiguration;
import com.paypal.core.SDKUtil;
import com.paypal.core.rest.HttpMethod;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTConfiguration {
    private static final String JAVAHEADER;
    private static final String OSHEADER;
    private Map<String, String> configurationMap = null;
    private URL url;
    private String authorizationToken;
    private HttpMethod httpMethod;
    private String resourcePath;
    private String requestId;
    private Map<String, String> headersMap;

    public RESTConfiguration(Map<String, String> configurationMap) {
        this.configurationMap = SDKUtil.combineDefaultMap(configurationMap);
    }

    public RESTConfiguration(Map<String, String> configurationMap, Map<String, String> headersMap) {
        this(configurationMap);
        this.headersMap = headersMap == null ? Collections.emptyMap() : headersMap;
    }

    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public static String getJavaheader() {
        return JAVAHEADER;
    }

    public static String getOsheader() {
        return OSHEADER;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.authorizationToken != null && this.authorizationToken.trim().length() > 0) {
            headers.put("Authorization", this.authorizationToken);
        } else if (this.getClientID() != null && this.getClientID().trim().length() > 0 && this.getClientSecret() != null && this.getClientSecret().trim().length() > 0) {
            try {
                headers.put("Authorization", "Basic " + this.encodeToBase64(this.getClientID(), this.getClientSecret()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        headers.put("User-Agent", RESTConfiguration.formUserAgentHeader());
        if (this.requestId != null && this.requestId.length() > 0) {
            headers.put("PayPal-Request-Id", this.requestId);
        }
        return headers;
    }

    public HttpConfiguration getHttpConfigurations() throws MalformedURLException, URISyntaxException {
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setHttpMethod(this.httpMethod.toString());
        httpConfiguration.setEndPointUrl(this.getBaseURL().toURI().resolve(this.resourcePath).toString());
        httpConfiguration.setContentType(this.headersMap != null ? (this.headersMap.get("Content-Type") != null ? this.headersMap.get("Content-Type") : "application/json") : "application/json");
        httpConfiguration.setGoogleAppEngine(Boolean.parseBoolean(this.configurationMap.get("http.GoogleAppEngine")));
        if (Boolean.parseBoolean(this.configurationMap.get("http.UseProxy"))) {
            httpConfiguration.setProxyPort(Integer.parseInt(this.configurationMap.get("http.ProxyPort")));
            httpConfiguration.setProxyHost(this.configurationMap.get("http.ProxyHost"));
            httpConfiguration.setProxyUserName(this.configurationMap.get("http.ProxyUserName"));
            httpConfiguration.setProxyPassword(this.configurationMap.get("http.ProxyPassword"));
        }
        httpConfiguration.setConnectionTimeout(Integer.parseInt(this.configurationMap.get("http.ConnectionTimeOut")));
        httpConfiguration.setMaxRetry(Integer.parseInt(this.configurationMap.get("http.Retry")));
        httpConfiguration.setReadTimeout(Integer.parseInt(this.configurationMap.get("http.ReadTimeOut")));
        httpConfiguration.setMaxHttpConnection(Integer.parseInt(this.configurationMap.get("http.MaxConnection")));
        httpConfiguration.setIpAddress(this.configurationMap.get("http.IPAddress"));
        return httpConfiguration;
    }

    public URL getBaseURL() throws MalformedURLException {
        if (this.url == null) {
            String urlString = this.configurationMap.get("service.EndPoint");
            if (urlString == null || urlString.length() <= 0) {
                String mode = this.configurationMap.get("mode");
                if ("sandbox".equalsIgnoreCase(mode)) {
                    urlString = "https://api.sandbox.paypal.com/";
                } else if ("live".equalsIgnoreCase(mode)) {
                    urlString = "https://api.paypal.com/";
                } else {
                    throw new MalformedURLException("service.EndPoint not set (OR) mode not configured to sandbox/live ");
                }
            }
            if (!urlString.endsWith("/")) {
                urlString = urlString + "/";
            }
            this.url = new URL(urlString);
        }
        return this.url;
    }

    public void setUrl(String urlString) throws MalformedURLException {
        if (urlString != null && urlString.length() > 0) {
            String uString = urlString.endsWith("/") ? urlString : urlString + "/";
            this.url = new URL(uString);
        } else {
            this.url = this.getBaseURL();
        }
    }

    public static String formUserAgentHeader() {
        String header = null;
        StringBuilder stringBuilder = new StringBuilder("PayPalSDK/rest-sdk-java 0.6.0 ");
        stringBuilder.append("(").append(JAVAHEADER);
        String osVersion = OSHEADER;
        if (osVersion.length() > 0) {
            stringBuilder.append(";").append(osVersion);
        }
        stringBuilder.append(")");
        header = stringBuilder.toString();
        return header;
    }

    private String getClientID() {
        return this.configurationMap.get("clientId");
    }

    private String getClientSecret() {
        return this.configurationMap.get("clientSecret");
    }

    private String encodeToBase64(String clientID, String clientSecret) throws UnsupportedEncodingException {
        String base64ClientID = this.generateBase64String(clientID + ":" + clientSecret);
        return base64ClientID;
    }

    private String generateBase64String(String clientID) throws UnsupportedEncodingException {
        String base64ClientID = null;
        byte[] encoded = null;
        encoded = Base64.encodeBase64((byte[])clientID.getBytes("UTF-8"));
        base64ClientID = new String(encoded, "UTF-8");
        return base64ClientID;
    }

    static {
        StringBuilder javaVersion = new StringBuilder("lang=Java");
        if (System.getProperty("java.version") != null && System.getProperty("java.version").length() > 0) {
            javaVersion.append(";v=").append(System.getProperty("java.version"));
        }
        if (System.getProperty("java.vm.name") != null && System.getProperty("java.vm.name").length() > 0) {
            javaVersion.append(";bit=");
            if (System.getProperty("java.vm.name").contains("Client")) {
                javaVersion.append("32");
            } else {
                javaVersion.append("64");
            }
        }
        JAVAHEADER = javaVersion.toString();
        StringBuilder osVersion = new StringBuilder();
        if (System.getProperty("os.name") != null && System.getProperty("os.name").length() > 0) {
            osVersion.append("os=");
            osVersion.append(System.getProperty("os.name").replace(' ', '_'));
        } else {
            osVersion.append("os=");
        }
        if (System.getProperty("os.version") != null && System.getProperty("os.version").length() > 0) {
            osVersion.append(" " + System.getProperty("os.version").replace(' ', '_'));
        }
        OSHEADER = osVersion.toString();
    }
}

