/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.rest;

import com.paypal.core.rest.QueryParameters;
import com.paypal.sdk.openidconnect.CreateFromAuthorizationCodeParameters;
import com.paypal.sdk.openidconnect.CreateFromRefreshTokenParameters;
import com.paypal.sdk.openidconnect.UserinfoParameters;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RESTUtil {
    private RESTUtil() {
    }

    public static String formatURIPath(String pattern, Object[] parameters) {
        String formattedPath = null;
        Object[] finalParameters = null;
        if (pattern != null) {
            if (parameters != null && parameters.length == 1 && parameters[0] instanceof CreateFromAuthorizationCodeParameters) {
                finalParameters = RESTUtil.splitParameters(pattern, ((CreateFromAuthorizationCodeParameters)parameters[0]).getContainerMap());
            }
            if (parameters != null && parameters.length == 1 && parameters[0] instanceof CreateFromRefreshTokenParameters) {
                finalParameters = RESTUtil.splitParameters(pattern, ((CreateFromRefreshTokenParameters)parameters[0]).getContainerMap());
            }
            if (parameters != null && parameters.length == 1 && parameters[0] instanceof UserinfoParameters) {
                finalParameters = RESTUtil.splitParameters(pattern, ((UserinfoParameters)parameters[0]).getContainerMap());
            }
            finalParameters = parameters != null && parameters.length == 1 && parameters[0] instanceof QueryParameters ? RESTUtil.splitParameters(pattern, ((QueryParameters)parameters[0]).getContainerMap()) : (parameters != null && parameters.length == 1 && parameters[0] instanceof Map ? RESTUtil.splitParameters(pattern, (Map)parameters[0]) : parameters);
            String fString = MessageFormat.format(pattern, finalParameters);
            formattedPath = RESTUtil.removeNullsInQS(fString);
        }
        return formattedPath;
    }

    private static String removeNullsInQS(String fString) {
        String[] parts;
        String formattedString = fString;
        if (fString != null && fString.length() != 0 && (parts = fString.split("\\?")).length == 2) {
            String queryString = parts[1];
            String[] querys = queryString.split("&");
            if (querys.length > 0) {
                StringBuilder strBuilder = new StringBuilder();
                for (String query : querys) {
                    String[] valueSplit = query.split("=");
                    if (valueSplit.length == 2) {
                        if ("null".equalsIgnoreCase(valueSplit[1].trim()) || "".equals(valueSplit[1].trim())) continue;
                        strBuilder.append(query).append("&");
                        continue;
                    }
                    if (valueSplit.length >= 2) continue;
                }
                formattedString = !strBuilder.toString().endsWith("&") ? strBuilder.toString() : strBuilder.toString().substring(0, strBuilder.toString().length() - 1);
            }
            formattedString = parts[0].trim() + "?" + formattedString;
        }
        return formattedString;
    }

    private static Object[] splitParameters(String pattern, Map<?, ?> containerMap) {
        String[] queries;
        ArrayList objectList = new ArrayList();
        String[] query = pattern.split("\\?");
        if (query != null && query.length == 2 && query[1].contains("={") && (queries = query[1].split("&")) != null) {
            for (String q : queries) {
                String[] params = q.split("=");
                if (params == null || params.length != 2) continue;
                String key = params[0].trim();
                if (containerMap.containsKey(key)) {
                    Object object = containerMap.get(key);
                    objectList.add(object);
                    continue;
                }
                objectList.add(null);
            }
        }
        return objectList.toArray();
    }
}

