/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.openidconnect;

import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.PayPalResource;
import com.paypal.core.rest.RESTUtil;
import com.paypal.sdk.openidconnect.CreateFromAuthorizationCodeParameters;
import com.paypal.sdk.openidconnect.CreateFromRefreshTokenParameters;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Properties;

public class Tokeninfo {
    private String scope;
    private String accessToken;
    private String refreshToken;
    private String tokenType;
    private Integer expiresIn;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static void initConfig(InputStream is) throws PayPalRESTException {
        PayPalResource.initConfig(is);
    }

    public static void initConfig(File file) throws PayPalRESTException {
        PayPalResource.initConfig(file);
    }

    public static void initConfig(Properties properties) {
        PayPalResource.initConfig(properties);
    }

    public Tokeninfo() {
    }

    public Tokeninfo(String accessToken, String tokenType, Integer expiresIn) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public static Tokeninfo createFromAuthorizationCode(CreateFromAuthorizationCodeParameters createFromAuthorizationCodeParameters) throws PayPalRESTException {
        String pattern = "v1/identity/openidconnect/tokenservice ?grant_type={0}&code={1}&redirect_uri={2}";
        Object[] parameters = new Object[]{createFromAuthorizationCodeParameters};
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = resourcePath.substring(resourcePath.indexOf(63) + 1);
        resourcePath = resourcePath.substring(0, resourcePath.indexOf(63));
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("Content-Type", "application/x-www-form-urlencoded");
        return PayPalResource.configureAndExecute(null, HttpMethod.POST, resourcePath, headersMap, payLoad, Tokeninfo.class);
    }

    public static Tokeninfo createFromAuthorizationCode(APIContext apiContext, CreateFromAuthorizationCodeParameters createFromAuthorizationCodeParameters) throws PayPalRESTException {
        String pattern = "v1/identity/openidconnect/tokenservice ?grant_type={0}&code={1}&redirect_uri={2}";
        Object[] parameters = new Object[]{createFromAuthorizationCodeParameters};
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = resourcePath.substring(resourcePath.indexOf(63) + 1);
        resourcePath = resourcePath.substring(0, resourcePath.indexOf(63));
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("Content-Type", "application/x-www-form-urlencoded");
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, headersMap, payLoad, Tokeninfo.class);
    }

    public Tokeninfo createFromRefreshToken(CreateFromRefreshTokenParameters createFromRefreshTokenParameters) throws PayPalRESTException {
        String pattern = "v1/identity/openidconnect/tokenservice ?grant_type={0}&refresh_token={1}&scope={2}&client_id={3}&client_secret={4}";
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.putAll(createFromRefreshTokenParameters.getContainerMap());
        try {
            paramsMap.put("refresh_token", URLEncoder.encode(this.getRefreshToken(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        Object[] parameters = new Object[]{paramsMap};
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = resourcePath.substring(resourcePath.indexOf(63) + 1);
        resourcePath = resourcePath.substring(0, resourcePath.indexOf(63));
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("Content-Type", "application/x-www-form-urlencoded");
        return PayPalResource.configureAndExecute(null, HttpMethod.POST, resourcePath, headersMap, payLoad, Tokeninfo.class);
    }

    public Tokeninfo createFromRefreshToken(APIContext apiContext, CreateFromRefreshTokenParameters createFromRefreshTokenParameters) throws PayPalRESTException {
        String pattern = "v1/identity/openidconnect/tokenservice ?grant_type={0}&refresh_token={1}&scope={2}&client_id={3}&client_secret={4}";
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.putAll(createFromRefreshTokenParameters.getContainerMap());
        try {
            paramsMap.put("refresh_token", URLEncoder.encode(this.getRefreshToken(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        Object[] parameters = new Object[]{paramsMap};
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = resourcePath.substring(resourcePath.indexOf(63) + 1);
        resourcePath = resourcePath.substring(0, resourcePath.indexOf(63));
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("Content-Type", "application/x-www-form-urlencoded");
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, headersMap, payLoad, Tokeninfo.class);
    }

    public String toJSON() {
        return JSONFormatter.toJSON(this);
    }

    public String toString() {
        return this.toJSON();
    }
}

