/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples;

import java.awt.Color;
import java.util.Locale;
import net.sf.dynamicreports.report.base.expression.AbstractValueFormatter;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.HyperLinkBuilder;
import net.sf.dynamicreports.report.builder.ReportTemplateBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.datatype.BigDecimalType;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.builder.tableofcontents.TableOfContentsCustomizerBuilder;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.constant.VerticalAlignment;
import net.sf.dynamicreports.report.definition.ReportParameters;

public class Templates {
    public static final StyleBuilder rootStyle = (StyleBuilder)DynamicReports.stl.style().setPadding(Integer.valueOf(2));
    public static final StyleBuilder boldStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)rootStyle).bold();
    public static final StyleBuilder italicStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)rootStyle).italic();
    public static final StyleBuilder boldCenteredStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldStyle).setAlignment(HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE);
    public static final StyleBuilder bold12CenteredStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldCenteredStyle).setFontSize(Integer.valueOf(12));
    public static final StyleBuilder bold18CenteredStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldCenteredStyle).setFontSize(Integer.valueOf(18));
    public static final StyleBuilder bold22CenteredStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldCenteredStyle).setFontSize(Integer.valueOf(22));
    public static final StyleBuilder columnStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)rootStyle).setVerticalAlignment(VerticalAlignment.MIDDLE);
    public static final StyleBuilder columnTitleStyle = (StyleBuilder)((StyleBuilder)((StyleBuilder)((StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)columnStyle).setBorder(DynamicReports.stl.pen1Point())).setHorizontalAlignment(HorizontalAlignment.CENTER)).setBackgroundColor(Color.LIGHT_GRAY)).bold();
    public static final StyleBuilder groupStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldStyle).setHorizontalAlignment(HorizontalAlignment.LEFT);
    public static final StyleBuilder subtotalStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldStyle).setTopBorder(DynamicReports.stl.pen1Point());
    public static final ReportTemplateBuilder reportTemplate;
    public static final CurrencyType currencyType;
    public static final ComponentBuilder<?, ?> dynamicReportsComponent;
    public static final ComponentBuilder<?, ?> footerComponent;

    static {
        StyleBuilder crosstabGroupStyle = DynamicReports.stl.style((ReportStyleBuilder)columnTitleStyle);
        StyleBuilder crosstabGroupTotalStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)columnTitleStyle).setBackgroundColor(new Color(170, 170, 170));
        StyleBuilder crosstabGrandTotalStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)columnTitleStyle).setBackgroundColor(new Color(140, 140, 140));
        StyleBuilder crosstabCellStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)columnStyle).setBorder(DynamicReports.stl.pen1Point());
        TableOfContentsCustomizerBuilder tableOfContentsCustomizer = DynamicReports.tableOfContentsCustomizer().setHeadingStyle(0, (ReportStyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)rootStyle).bold());
        reportTemplate = DynamicReports.template().setLocale(Locale.ENGLISH).setColumnStyle((ReportStyleBuilder)columnStyle).setColumnTitleStyle((ReportStyleBuilder)columnTitleStyle).setGroupStyle((ReportStyleBuilder)groupStyle).setGroupTitleStyle((ReportStyleBuilder)groupStyle).setSubtotalStyle((ReportStyleBuilder)subtotalStyle).highlightDetailEvenRows().crosstabHighlightEvenRows().setCrosstabGroupStyle((ReportStyleBuilder)crosstabGroupStyle).setCrosstabGroupTotalStyle((ReportStyleBuilder)crosstabGroupTotalStyle).setCrosstabGrandTotalStyle((ReportStyleBuilder)crosstabGrandTotalStyle).setCrosstabCellStyle((ReportStyleBuilder)crosstabCellStyle).setTableOfContentsCustomizer(tableOfContentsCustomizer);
        currencyType = new CurrencyType();
        HyperLinkBuilder link = DynamicReports.hyperLink((String)"http://www.dynamicreports.org");
        dynamicReportsComponent = DynamicReports.cmp.horizontalList(new ComponentBuilder[]{DynamicReports.cmp.image(Templates.class.getResource("images/dynamicreports.png")).setFixedDimension(Integer.valueOf(60), Integer.valueOf(60)), DynamicReports.cmp.verticalList(new ComponentBuilder[]{((TextFieldBuilder)DynamicReports.cmp.text("DynamicReports").setStyle((ReportStyleBuilder)bold22CenteredStyle)).setHorizontalAlignment(HorizontalAlignment.LEFT), ((TextFieldBuilder)DynamicReports.cmp.text("http://www.dynamicreports.org").setStyle((ReportStyleBuilder)italicStyle)).setHyperLink(link)})}).setFixedWidth(Integer.valueOf(300));
        footerComponent = DynamicReports.cmp.pageXofY().setStyle((ReportStyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)boldCenteredStyle).setTopBorder(DynamicReports.stl.pen1Point()));
    }

    public static ComponentBuilder<?, ?> createTitleComponent(String label) {
        return DynamicReports.cmp.horizontalList().add(new ComponentBuilder[]{dynamicReportsComponent, ((TextFieldBuilder)DynamicReports.cmp.text(label).setStyle((ReportStyleBuilder)bold18CenteredStyle)).setHorizontalAlignment(HorizontalAlignment.RIGHT)}).newRow().add(new ComponentBuilder[]{DynamicReports.cmp.line()}).newRow().add(new ComponentBuilder[]{DynamicReports.cmp.verticalGap(10)});
    }

    public static CurrencyValueFormatter createCurrencyValueFormatter(String label) {
        return new CurrencyValueFormatter(label);
    }

    public static class CurrencyType
    extends BigDecimalType {
        private static final long serialVersionUID = 1L;

        public String getPattern() {
            return "$ #,###.00";
        }
    }

    private static class CurrencyValueFormatter
    extends AbstractValueFormatter<String, Number> {
        private static final long serialVersionUID = 1L;
        private String label;

        public CurrencyValueFormatter(String label) {
            this.label = label;
        }

        public String format(Number value, ReportParameters reportParameters) {
            return String.valueOf(this.label) + currencyType.valueToString(value, reportParameters.getLocale());
        }
    }
}

