/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.adhoc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import net.sf.dynamicreports.adhoc.AdhocManager;
import net.sf.dynamicreports.adhoc.configuration.AdhocColumn;
import net.sf.dynamicreports.adhoc.configuration.AdhocConfiguration;
import net.sf.dynamicreports.adhoc.configuration.AdhocReport;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class SimpleAdhocReport {
    public SimpleAdhocReport() {
        this.build();
    }

    private void build() {
        AdhocConfiguration configuration = new AdhocConfiguration();
        AdhocReport report = new AdhocReport();
        configuration.setReport(report);
        AdhocColumn column = new AdhocColumn();
        column.setName("item");
        report.addColumn(column);
        column = new AdhocColumn();
        column.setName("quantity");
        report.addColumn(column);
        try {
            AdhocManager.saveConfiguration((AdhocConfiguration)configuration, (OutputStream)new FileOutputStream("c:/temp/configuration.xml"));
            AdhocManager.loadConfiguration((InputStream)new FileInputStream("c:/temp/configuration.xml"));
            JasperReportBuilder reportBuilder = AdhocManager.createReport((AdhocReport)configuration.getReport());
            reportBuilder.setDataSource(this.createDataSource());
            reportBuilder.show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "orderdate", "quantity", "unitprice"});
        int i = 0;
        while (i < 20) {
            dataSource.add(new Object[]{"Book", new Date(), (int)(Math.random() * 10.0) + 1, new BigDecimal(Math.random() * 100.0 + 1.0)});
            ++i;
        }
        return dataSource;
    }

    public static void main(String[] args) {
        new SimpleAdhocReport();
    }
}

