/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.chart;

import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.chart.GanttChartBuilder;
import net.sf.dynamicreports.report.builder.chart.GanttChartSerieBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class GanttChartReport {
    public GanttChartReport() {
        this.build();
    }

    private void build() {
        TextColumnBuilder taskColumn = DynamicReports.col.column("Task", "task", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder actualStartDateColumn = DynamicReports.col.column("Actual start date", "actualstartdate", (DRIDataType)DynamicReports.type.dateType());
        TextColumnBuilder actualEndDateColumn = DynamicReports.col.column("Actual end date", "actualenddate", (DRIDataType)DynamicReports.type.dateType());
        TextColumnBuilder scheduledStartDateColumn = DynamicReports.col.column("Scheduled start date", "scheduledstartdate", (DRIDataType)DynamicReports.type.dateType());
        TextColumnBuilder scheduledEndDateColumn = DynamicReports.col.column("Scheduled end date", "scheduledenddate", (DRIDataType)DynamicReports.type.dateType());
        TextColumnBuilder actualColumn = DynamicReports.col.column("Actual", "actual", (DRIDataType)DynamicReports.type.doubleType());
        GanttChartBuilder chart1 = DynamicReports.cht.ganttChart().setTask((ValueColumnBuilder)taskColumn).series(new GanttChartSerieBuilder[]{DynamicReports.cht.ganttSerie().setStartDate((ValueColumnBuilder)scheduledStartDateColumn).setEndDate((ValueColumnBuilder)scheduledEndDateColumn).setLabel("Scheduled"), DynamicReports.cht.ganttSerie().setStartDate((ValueColumnBuilder)actualStartDateColumn).setEndDate((ValueColumnBuilder)actualEndDateColumn).setLabel("Actual")}).setTimeAxisFormat(DynamicReports.cht.axisFormat().setLabel("Time")).setTaskAxisFormat(DynamicReports.cht.axisFormat().setLabel("Task"));
        GanttChartBuilder chart2 = DynamicReports.cht.ganttChart().setTask((ValueColumnBuilder)taskColumn).series(new GanttChartSerieBuilder[]{DynamicReports.cht.ganttSerie().setStartDate((ValueColumnBuilder)scheduledStartDateColumn).setEndDate((ValueColumnBuilder)scheduledEndDateColumn).setPercent((ValueColumnBuilder)actualColumn).setLabel("Scheduled")}).setTimeAxisFormat(DynamicReports.cht.axisFormat().setLabel("Time")).setTaskAxisFormat(DynamicReports.cht.axisFormat().setLabel("Task"));
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{taskColumn, actualStartDateColumn, actualEndDateColumn, scheduledStartDateColumn, scheduledEndDateColumn, actualColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("GanttChart")})).summary(new ComponentBuilder[]{chart1, chart2})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"task", "actualstartdate", "actualenddate", "scheduledstartdate", "scheduledenddate", "actual"});
        dataSource.add(new Object[]{"Proposal", this.toDate(2011, 1, 5), this.toDate(2011, 1, 7), this.toDate(2011, 1, 4), this.toDate(2011, 1, 7), 1.0});
        dataSource.add(new Object[]{"Analysis", this.toDate(2011, 1, 7), this.toDate(2011, 1, 14), this.toDate(2011, 1, 7), this.toDate(2011, 1, 12), 0.8});
        dataSource.add(new Object[]{"Implementation", this.toDate(2011, 1, 15), this.toDate(2011, 1, 27), this.toDate(2011, 1, 12), this.toDate(2011, 1, 25), 0.3});
        dataSource.add(new Object[]{"Testing", this.toDate(2011, 1, 27), this.toDate(2011, 1, 30), this.toDate(2011, 1, 25), this.toDate(2011, 1, 28), 0.0});
        return dataSource;
    }

    private Date toDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }

    public static void main(String[] args) {
        new GanttChartReport();
    }
}

