/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.chart;

import java.math.BigDecimal;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.LayeredBarChartBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class LayeredBarChartReport {
    public LayeredBarChartReport() {
        this.build();
    }

    private void build() {
        FontBuilder boldFont = DynamicReports.stl.fontArialBold().setFontSize(Integer.valueOf(12));
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder unitPriceColumn = DynamicReports.col.column("Unit price", "unitprice", (DRIDataType)DynamicReports.type.bigDecimalType());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{itemColumn, quantityColumn, unitPriceColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("LayeredBarChart")})).summary(new ComponentBuilder[]{((LayeredBarChartBuilder)((LayeredBarChartBuilder)((LayeredBarChartBuilder)((LayeredBarChartBuilder)DynamicReports.cht.layeredBarChart().setTitle("LayeredBar chart")).setTitleFont(boldFont)).seriesBarWidths(new Double[]{1.0, 0.5}).setCategory((ValueColumnBuilder)itemColumn)).series(new AbstractCategoryChartSerieBuilder[]{DynamicReports.cht.serie((ValueColumnBuilder)quantityColumn), DynamicReports.cht.serie((ValueColumnBuilder)unitPriceColumn)})).setCategoryAxisFormat(DynamicReports.cht.axisFormat().setLabel("Item"))})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Book", 270, new BigDecimal(100)});
        dataSource.add(new Object[]{"Camera", 170, new BigDecimal(150)});
        dataSource.add(new Object[]{"PDA", 120, new BigDecimal(250)});
        return dataSource;
    }

    public static void main(String[] args) {
        new LayeredBarChartReport();
    }
}

