/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.chart;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.chart.CategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.TimeSeriesChartBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.style.FontBuilder;
import net.sf.dynamicreports.report.constant.TimePeriod;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class TimeSeriesChartReport {
    public TimeSeriesChartReport() {
        this.build();
    }

    private void build() {
        FontBuilder boldFont = DynamicReports.stl.fontArialBold().setFontSize(Integer.valueOf(12));
        TextColumnBuilder orderDateColumn = DynamicReports.col.column("Order date", "orderdate", (DRIDataType)DynamicReports.type.dateYearToMonthType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder priceColumn = DynamicReports.col.column("Price", "price", (DRIDataType)DynamicReports.type.bigDecimalType());
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{orderDateColumn, quantityColumn, priceColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("TimeSeriesChart")})).summary(new ComponentBuilder[]{((TimeSeriesChartBuilder)((TimeSeriesChartBuilder)((TimeSeriesChartBuilder)((TimeSeriesChartBuilder)((TimeSeriesChartBuilder)DynamicReports.cht.timeSeriesChart().setTitle("Time series chart")).setTitleFont(boldFont)).setTimePeriod((ValueColumnBuilder)orderDateColumn)).setTimePeriodType(TimePeriod.MONTH)).series(new CategoryChartSerieBuilder[]{DynamicReports.cht.serie((ValueColumnBuilder)quantityColumn), DynamicReports.cht.serie((ValueColumnBuilder)priceColumn)})).setTimeAxisFormat(DynamicReports.cht.axisFormat().setLabel("Date"))})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"orderdate", "quantity", "price"});
        dataSource.add(new Object[]{this.toDate(2010, 1), 50, new BigDecimal(200)});
        dataSource.add(new Object[]{this.toDate(2010, 2), 110, new BigDecimal(450)});
        dataSource.add(new Object[]{this.toDate(2010, 3), 70, new BigDecimal(280)});
        dataSource.add(new Object[]{this.toDate(2010, 4), 250, new BigDecimal(620)});
        dataSource.add(new Object[]{this.toDate(2010, 5), 100, new BigDecimal(400)});
        dataSource.add(new Object[]{this.toDate(2010, 6), 80, new BigDecimal(320)});
        dataSource.add(new Object[]{this.toDate(2010, 7), 180, new BigDecimal(490)});
        return dataSource;
    }

    private Date toDate(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(1, year);
        c.set(2, month - 1);
        return c.getTime();
    }

    public static void main(String[] args) {
        new TimeSeriesChartReport();
    }
}

