/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.chartcustomization;

import java.util.Calendar;
import java.util.Date;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.BarChartBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.constant.OrderType;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class ChartSeriesOrderReport {
    public ChartSeriesOrderReport() {
        this.build();
    }

    private void build() {
        TextColumnBuilder dateColumn = DynamicReports.col.column("Date", "date", (DRIDataType)DynamicReports.type.dateYearToMonthType());
        TextColumnBuilder stockColumn = DynamicReports.col.column("Stock", "stock", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder valueColumn = DynamicReports.col.column("Value", "value", (DRIDataType)DynamicReports.type.integerType());
        BarChartBuilder chart = (BarChartBuilder)((BarChartBuilder)((BarChartBuilder)((BarChartBuilder)DynamicReports.cht.barChart().setCategory((DRIExpression)new CategoryExpression())).series(new AbstractCategoryChartSerieBuilder[]{(AbstractCategoryChartSerieBuilder)DynamicReports.cht.serie((ValueColumnBuilder)valueColumn).setSeries((ValueColumnBuilder)stockColumn)})).setSeriesOrderType(OrderType.ASCENDING)).setValueAxisFormat(DynamicReports.cht.axisFormat().setLabel("Stock"));
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{dateColumn, stockColumn, valueColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("ChartSeriesOrder")})).groupBy(new ValueColumnBuilder[]{dateColumn})).summary(new ComponentBuilder[]{chart})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"date", "stock", "value"});
        dataSource.add(new Object[]{this.toDate(2010, 1), "stock3", 25});
        dataSource.add(new Object[]{this.toDate(2010, 2), "stock3", 10});
        dataSource.add(new Object[]{this.toDate(2010, 2), "stock1", 18});
        dataSource.add(new Object[]{this.toDate(2010, 3), "stock3", 12});
        dataSource.add(new Object[]{this.toDate(2010, 3), "stock1", 19});
        dataSource.add(new Object[]{this.toDate(2010, 3), "stock2", 9});
        dataSource.add(new Object[]{this.toDate(2010, 4), "stock1", 15});
        dataSource.add(new Object[]{this.toDate(2010, 4), "stock2", 14});
        dataSource.add(new Object[]{this.toDate(2010, 5), "stock2", 22});
        dataSource.add(new Object[]{this.toDate(2010, 5), "stock1", 15});
        return dataSource;
    }

    private Date toDate(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(1, year);
        c.set(2, month - 1);
        return c.getTime();
    }

    public static void main(String[] args) {
        new ChartSeriesOrderReport();
    }

    private class CategoryExpression
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private CategoryExpression() {
        }

        public String evaluate(ReportParameters reportParameters) {
            return DynamicReports.type.dateYearToMonthType().valueToString("date", reportParameters);
        }
    }
}

