/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.chartcustomization;

import java.math.BigDecimal;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.chart.AbstractCategoryChartSerieBuilder;
import net.sf.dynamicreports.report.builder.chart.Bar3DChartBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.column.ValueColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.group.ColumnGroupBuilder;
import net.sf.dynamicreports.report.builder.group.GroupBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class GroupChartReport {
    public GroupChartReport() {
        this.build();
    }

    private void build() {
        TextColumnBuilder countryColumn = DynamicReports.col.column("Country", "country", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder itemColumn = DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType());
        TextColumnBuilder quantityColumn = DynamicReports.col.column("Quantity", "quantity", (DRIDataType)DynamicReports.type.integerType());
        TextColumnBuilder salesColumn = DynamicReports.col.column("Sales", "sales", (DRIDataType)DynamicReports.type.bigDecimalType());
        Bar3DChartBuilder chart = (Bar3DChartBuilder)((Bar3DChartBuilder)((Bar3DChartBuilder)((Bar3DChartBuilder)DynamicReports.cht.bar3DChart().setFixedHeight(Integer.valueOf(180))).setCategory((ValueColumnBuilder)itemColumn)).series(new AbstractCategoryChartSerieBuilder[]{DynamicReports.cht.serie((ValueColumnBuilder)quantityColumn), DynamicReports.cht.serie((ValueColumnBuilder)salesColumn)})).setCategoryAxisFormat(DynamicReports.cht.axisFormat().setLabel("Item"));
        ColumnGroupBuilder countryGroup = (ColumnGroupBuilder)DynamicReports.grp.group((ValueColumnBuilder)countryColumn).footer(new ComponentBuilder[]{chart});
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).columns(new ColumnBuilder[]{countryColumn, itemColumn, quantityColumn, salesColumn})).title(new ComponentBuilder[]{Templates.createTitleComponent("GroupChart")})).groupBy(new GroupBuilder[]{countryGroup})).summary(new ComponentBuilder[]{DynamicReports.cmp.text("All countries").setStyle((ReportStyleBuilder)Templates.bold12CenteredStyle), chart})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"country", "item", "quantity", "sales"});
        dataSource.add(new Object[]{"USA", "Book", 170, new BigDecimal(100)});
        dataSource.add(new Object[]{"USA", "Notebook", 90, new BigDecimal(280)});
        dataSource.add(new Object[]{"USA", "PDA", 120, new BigDecimal(250)});
        dataSource.add(new Object[]{"Canada", "Book", 120, new BigDecimal(80)});
        dataSource.add(new Object[]{"Canada", "Notebook", 150, new BigDecimal(310)});
        dataSource.add(new Object[]{"Canada", "PDA", 100, new BigDecimal(180)});
        return dataSource;
    }

    public static void main(String[] args) {
        new GroupChartReport();
    }
}

