/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.column;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class ColumnDetectDataTypeReport {
    public ColumnDetectDataTypeReport() {
        this.build();
    }

    private void build() {
        try {
            JasperReportBuilder report = DynamicReports.report();
            for (Column column : this.createColumns()) {
                report.addColumn(new ColumnBuilder[]{DynamicReports.col.column(column.title, column.field, DynamicReports.type.detectType(column.dataType))});
            }
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)report.setTemplate(Templates.reportTemplate)).title(new ComponentBuilder[]{Templates.createTitleComponent("ColumnDetectDataTypes")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "orderdate", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Notebook", new Date(), 1, new BigDecimal(500)});
        return dataSource;
    }

    private List<Column> createColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column("Item", "item", "string"));
        columns.add(new Column("Quantity", "quantity", "integer"));
        columns.add(new Column("Unit price", "unitprice", "bigDecimal"));
        columns.add(new Column("Order date", "orderdate", "date"));
        columns.add(new Column("Order date", "orderdate", "dateYearToFraction"));
        columns.add(new Column("Order year", "orderdate", "dateYear"));
        columns.add(new Column("Order month", "orderdate", "dateMonth"));
        columns.add(new Column("Order day", "orderdate", "dateDay"));
        return columns;
    }

    public static void main(String[] args) {
        new ColumnDetectDataTypeReport();
    }

    private class Column {
        private String title;
        private String field;
        private String dataType;

        private Column(String title, String field, String dataType) {
            this.title = title;
            this.field = field;
            this.dataType = dataType;
        }
    }
}

