/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.column;

import java.math.BigDecimal;
import java.util.Date;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.FieldBuilder;
import net.sf.dynamicreports.report.builder.column.ColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.DRIValue;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.dynamicreports.report.exception.DRException;
import net.sf.jasperreports.engine.JRDataSource;

public class ExpressionColumnReport {
    private FieldBuilder<Integer> quantityField;

    public ExpressionColumnReport() {
        this.build();
    }

    private void build() {
        try {
            ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)DynamicReports.report().setTemplate(Templates.reportTemplate)).fields(new FieldBuilder[]{DynamicReports.field((String)"orderdate", Date.class), this.quantityField = DynamicReports.field((String)"quantity", Integer.class), DynamicReports.field((String)"unitprice", BigDecimal.class)})).columns(new ColumnBuilder[]{DynamicReports.col.column("Item", "item", (DRIDataType)DynamicReports.type.stringType()), DynamicReports.col.column("Expression column", (DRIExpression)new ExpressionColumn())})).title(new ComponentBuilder[]{Templates.createTitleComponent("ExpressionColumn")})).pageFooter(new ComponentBuilder[]{Templates.footerComponent})).setDataSource(this.createDataSource()).show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }

    private JRDataSource createDataSource() {
        DRDataSource dataSource = new DRDataSource(new String[]{"item", "orderdate", "quantity", "unitprice"});
        dataSource.add(new Object[]{"Notebook", new Date(), 1, new BigDecimal(500)});
        return dataSource;
    }

    public static void main(String[] args) {
        new ExpressionColumnReport();
    }

    private class ExpressionColumn
    extends AbstractSimpleExpression<String> {
        private static final long serialVersionUID = 1L;

        private ExpressionColumn() {
        }

        public String evaluate(ReportParameters reportParameters) {
            return "Item = " + reportParameters.getValue("item") + ", " + "Order date = " + DynamicReports.type.dateType().valueToString("orderdate", reportParameters) + ", " + "Quantity = " + DynamicReports.type.integerType().valueToString((DRIValue)ExpressionColumnReport.this.quantityField, reportParameters) + ", " + "Unit price = " + DynamicReports.type.bigDecimalType().valueToString("unitprice", reportParameters);
        }
    }
}

