/*
 * Decompiled with CFR 0.152.
 */
package net.sf.dynamicreports.examples.complex.applicationform;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.dynamicreports.examples.Templates;
import net.sf.dynamicreports.examples.complex.applicationform.ApplicationForm;
import net.sf.dynamicreports.examples.complex.applicationform.ApplicationFormData;
import net.sf.dynamicreports.examples.complex.applicationform.Gender;
import net.sf.dynamicreports.examples.complex.applicationform.MaritalStatus;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.FillerBuilder;
import net.sf.dynamicreports.report.builder.component.HorizontalListBuilder;
import net.sf.dynamicreports.report.builder.component.TextFieldBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.dynamicreports.report.constant.VerticalAlignment;
import net.sf.dynamicreports.report.exception.DRException;
import org.apache.commons.lang3.StringUtils;

public class ApplicationFormDesign {
    private static final int cellWidth = 18;
    private static final int cellHeight = 18;
    private ApplicationFormData data = new ApplicationFormData();
    private StyleBuilder textStyle;
    private StyleBuilder centeredStyle;
    private StyleBuilder labelStyle;
    private StyleBuilder cellStyle;

    public JasperReportBuilder build() throws DRException {
        JasperReportBuilder report = DynamicReports.report();
        ApplicationForm applicationForm = this.data.getApplicationForm();
        this.textStyle = (StyleBuilder)((StyleBuilder)DynamicReports.stl.style().setFontSize(Integer.valueOf(12))).setPadding(Integer.valueOf(2));
        this.centeredStyle = (StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)this.textStyle).setAlignment(HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE);
        this.labelStyle = (StyleBuilder)((StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)this.textStyle).setHorizontalAlignment(HorizontalAlignment.LEFT)).bold();
        this.cellStyle = (StyleBuilder)((StyleBuilder)DynamicReports.stl.style((ReportStyleBuilder)this.textStyle).setBorder(DynamicReports.stl.pen1Point())).setAlignment(HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE);
        HorizontalListBuilder applicant = DynamicReports.cmp.horizontalList().add(new ComponentBuilder[]{this.label("First name", 14), this.emptyCell(1), this.label("Last name", 16)}).newRow().add(new ComponentBuilder[]{this.textCell(applicationForm.getFirstName(), 14), this.emptyCell(1), this.textCell(applicationForm.getLastName(), 16)}).newRow(Integer.valueOf(5)).add(new ComponentBuilder[]{this.emptyCell(1), this.dateOfBirth(applicationForm.getDateOfBirth()), this.emptyCell(4), this.gender(applicationForm.getGender())}).newRow(Integer.valueOf(5)).add(new ComponentBuilder[]{this.emptyCell(1), this.maritalStatus(applicationForm.getMaritalStatus())});
        HorizontalListBuilder address = DynamicReports.cmp.horizontalList().add(new ComponentBuilder[]{this.label("Address", 31)}).newRow().add(new ComponentBuilder[]{this.textCell(applicationForm.getAddress(), 31)}).newRow().add(new ComponentBuilder[]{this.textCell("", 31)}).newRow().add(new ComponentBuilder[]{this.label("City", 21), this.emptyCell(5), this.label("Postal code", 5)}).newRow().add(new ComponentBuilder[]{this.textCell(applicationForm.getCity(), 21), this.emptyCell(5), this.textCell(applicationForm.getPostalCode(), 5)});
        HorizontalListBuilder contact = DynamicReports.cmp.horizontalList().add(new ComponentBuilder[]{this.label("Telephone", 12), this.emptyCell(7), this.label("Mobile", 12)}).newRow().add(new ComponentBuilder[]{this.textCell(applicationForm.getTelephone(), 12), this.emptyCell(7), this.textCell(applicationForm.getMobile(), 12)}).newRow().add(new ComponentBuilder[]{this.label("Email", 31)}).newRow().add(new ComponentBuilder[]{this.textCell(applicationForm.getEmail(), 31)});
        ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)report.setTemplate(Templates.reportTemplate)).setPageFormat(PageType.A5, PageOrientation.LANDSCAPE)).setTextStyle((ReportStyleBuilder)this.textStyle)).title(new ComponentBuilder[]{Templates.createTitleComponent("ApplicationForm"), DynamicReports.cmp.text("APPLICATION FORM").setStyle((ReportStyleBuilder)Templates.bold18CenteredStyle), applicant, DynamicReports.cmp.verticalGap(10), address, DynamicReports.cmp.verticalGap(10), contact});
        return report;
    }

    private HorizontalListBuilder dateOfBirth(Date dateOfBirth) {
        String date = new SimpleDateFormat("MM/dd/yyyy").format(dateOfBirth);
        HorizontalListBuilder list = DynamicReports.cmp.horizontalList().add(new ComponentBuilder[]{this.label("Date Of Birth", 5)}).add(new ComponentBuilder[]{this.textCell(StringUtils.substringBefore((String)date, (String)"/"), 2), this.label("/", 1, this.centeredStyle)}).add(new ComponentBuilder[]{this.textCell(StringUtils.substringBetween((String)date, (String)"/"), 2), this.label("/", 1, this.centeredStyle)}).add(new ComponentBuilder[]{this.textCell(StringUtils.substringAfterLast((String)date, (String)"/"), 4)});
        return list;
    }

    private HorizontalListBuilder gender(Gender gender) {
        HorizontalListBuilder list = DynamicReports.cmp.horizontalList().add(new ComponentBuilder[]{this.label("Gender", 3)}).add(new ComponentBuilder[]{this.textCell(gender.equals((Object)Gender.MALE) ? "X" : "", 1), this.label("Male", 2, this.textStyle)}).add(new ComponentBuilder[]{this.textCell(gender.equals((Object)Gender.FEMALE) ? "X" : "", 1), this.label("Female", 3, this.textStyle)});
        return list;
    }

    private HorizontalListBuilder maritalStatus(MaritalStatus maritalStatus) {
        HorizontalListBuilder list = DynamicReports.cmp.horizontalList().add(new ComponentBuilder[]{this.label("Marital status", 5)}).add(new ComponentBuilder[]{this.textCell(maritalStatus.equals((Object)MaritalStatus.SINGLE) ? "X" : "", 1), this.label("Single", 3, this.textStyle)}).add(new ComponentBuilder[]{this.textCell(maritalStatus.equals((Object)MaritalStatus.MARRIED) ? "X" : "", 1), this.label("Married", 3, this.textStyle)}).add(new ComponentBuilder[]{this.textCell(maritalStatus.equals((Object)MaritalStatus.DIVORCED) ? "X" : "", 1), this.label("Divorced", 3, this.textStyle)});
        return list;
    }

    private FillerBuilder emptyCell(int size) {
        return DynamicReports.cmp.gap(18 * size, 18);
    }

    private HorizontalListBuilder textCell(String text, int size) {
        HorizontalListBuilder list = DynamicReports.cmp.horizontalList();
        String cellText = StringUtils.rightPad((String)text, (int)size);
        cellText = StringUtils.left((String)cellText, (int)size);
        char[] cArray = cellText.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            TextFieldBuilder cell = (TextFieldBuilder)((TextFieldBuilder)DynamicReports.cmp.text(String.valueOf(character)).setStyle((ReportStyleBuilder)this.cellStyle)).setFixedDimension(Integer.valueOf(18), Integer.valueOf(18));
            list.add(new ComponentBuilder[]{cell});
            ++n2;
        }
        return list;
    }

    private TextFieldBuilder<String> label(String text, int size) {
        return this.label(text, size, this.labelStyle);
    }

    private TextFieldBuilder<String> label(String text, int size, StyleBuilder style) {
        TextFieldBuilder label = (TextFieldBuilder)DynamicReports.cmp.text(text).setFixedWidth(Integer.valueOf(18 * size));
        if (style != null) {
            label.setStyle((ReportStyleBuilder)style);
        }
        return label;
    }

    public static void main(String[] args) {
        ApplicationFormDesign design = new ApplicationFormDesign();
        try {
            JasperReportBuilder report = design.build();
            report.show();
        }
        catch (DRException e) {
            e.printStackTrace();
        }
    }
}

